/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.util.ClassFilterSet;

public class UnificationIDtoRDFIDLister {
    private static Log log = LogFactory.getLog(UnificationIDtoRDFIDLister.class);
    static BioPAXIOHandler handler = new SimpleIOHandler();

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException {
        for (String arg : args) {
            log.info(arg);
            if (!arg.toLowerCase().endsWith("owl")) continue;
            try {
                UnificationIDtoRDFIDLister.processXrefs(arg);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processXrefs(String arg) throws FileNotFoundException, IllegalAccessException, InvocationTargetException {
        FileInputStream in = new FileInputStream(new File(arg));
        Model level2 = handler.convertFromOWL(in);
        Set<unificationXref> unis = level2.getObjects(unificationXref.class);
        for (unificationXref uni : unis) {
            ClassFilterSet<XReferrable, physicalEntity> referrables = new ClassFilterSet<XReferrable, physicalEntity>(uni.isXREFof(), physicalEntity.class);
            for (Object referrable : referrables) {
                System.out.print(uni.getDB() + " : " + uni.getID() + " refers to " + ((physicalEntity)referrable).getRDFId());
            }
        }
    }
}

