/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.CellVocabularyImpl;
import org.biopax.paxtools.impl.level3.NamedImpl;
import org.biopax.paxtools.impl.level3.TissueVocabularyImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=BioSource.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class BioSourceImpl
extends NamedImpl
implements BioSource {
    private static final Log LOG = LogFactory.getLog(BioSourceImpl.class);
    private CellVocabulary celltype;
    private TissueVocabulary tissue;

    @Transient
    public Class<? extends BioSource> getModelInterface() {
        return BioSource.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof BioSource)) {
            return false;
        }
        BioSource bioSource2 = (BioSource)element;
        return (this.celltype != null ? this.celltype.isEquivalent(bioSource2.getCellType()) : bioSource2.getCellType() == null) && (this.tissue != null ? this.tissue.isEquivalent(bioSource2.getTissue()) : bioSource2.getTissue() == null) && SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, UnificationXref>(this.getXref(), UnificationXref.class), new ClassFilterSet<Xref, UnificationXref>(bioSource2.getXref(), UnificationXref.class));
    }

    @Override
    public int equivalenceCode() {
        int result = 29 * super.equivalenceCode() + (this.celltype != null ? this.celltype.hashCode() : 0);
        result = 29 * result + (this.tissue != null ? this.tissue.hashCode() : 0);
        return result;
    }

    @Override
    @ManyToOne(targetEntity=CellVocabularyImpl.class)
    public CellVocabulary getCellType() {
        return this.celltype;
    }

    @Override
    public void setCellType(CellVocabulary celltype) {
        this.celltype = celltype;
    }

    @Override
    @ManyToOne(targetEntity=TissueVocabularyImpl.class)
    public TissueVocabulary getTissue() {
        return this.tissue;
    }

    @Override
    public void setTissue(TissueVocabulary tissue) {
        this.tissue = tissue;
    }

    @Override
    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getRDFId()).append(" ");
            sb.append(this.getName().toString());
            if (this.tissue != null) {
                sb.append(" tissue: ").append(this.tissue.getTerm().toString());
            }
            if (this.celltype != null) {
                sb.append(" celltype: ").append(this.celltype.getTerm().toString());
            }
            sb.append(" xrefs: ").append(this.getXref().toString());
            return sb.toString();
        }
        catch (Exception e) {
            LOG.warn("Error in toString(): ", e);
            return this.getRDFId();
        }
    }
}

