/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.io.BioPAXIOHandlerAdapter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.util.BioPaxIOException;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public final class SimpleIOHandler
extends BioPAXIOHandlerAdapter {
    private static final Log log = LogFactory.getLog(SimpleIOHandler.class);
    private XMLStreamReader r;
    boolean propertyContext = false;
    private List<Triple> triples;
    private boolean mergeDuplicates = false;
    private static final String owlNS = "http://www.w3.org/2002/07/owl#";
    private static final String xsdNS = "http://www.w3.org/2001/XMLSchema#";
    private static final String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDF_ID = "rdf:ID=\"";
    private static final String RDF_about = "rdf:about=\"";
    private static final String newline = System.getProperty("line.separator");
    private static final String close = "\">";
    private boolean normalizeNameSpaces = true;
    private boolean absoluteUris;

    public SimpleIOHandler() {
        this(null, null);
    }

    public SimpleIOHandler(BioPAXLevel level) {
        this(level.getDefaultFactory(), level);
    }

    public SimpleIOHandler(BioPAXFactory factory, BioPAXLevel level) {
        super(factory, level);
    }

    public void mergeDuplicates(boolean mergeDuplicates) {
        this.mergeDuplicates = mergeDuplicates;
    }

    public void checkRestrictions(boolean checkRestrictions) {
        AbstractPropertyEditor.checkRestrictions.set(checkRestrictions);
    }

    @Override
    protected void resetEditorMap() {
        this.setEditorMap(SimpleEditorMap.get(this.getLevel()));
    }

    public String getXmlStreamInfo() {
        StringBuffer sb = new StringBuffer();
        int event = this.r.getEventType();
        if (event == 1 || event == 2 || event == 9) {
            sb.append(this.r.getLocalName());
        }
        if (this.r.getLocation() != null) {
            sb.append(" line ");
            sb.append(this.r.getLocation().getLineNumber());
            sb.append(" column ");
            sb.append(this.r.getLocation().getColumnNumber());
        }
        return sb.toString();
    }

    @Override
    protected void init(InputStream in) {
        try {
            XMLInputFactory xmlf = XMLInputFactory.newInstance();
            xmlf.setProperty("javax.xml.stream.isCoalescing", true);
            this.r = xmlf.createXMLStreamReader(in);
            this.triples = new LinkedList<Triple>();
        }
        catch (XMLStreamException e) {
            throw new BioPaxIOException(e.getClass().getSimpleName() + " " + e.getMessage() + "; " + e.getLocation());
        }
    }

    @Override
    protected void reset(InputStream in) {
        this.triples = null;
        try {
            this.r.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can't close the stream");
        }
        this.r = null;
        super.reset(in);
    }

    @Override
    protected Map<String, String> readNameSpaces() {
        HashMap<String, String> ns = new HashMap<String, String>();
        try {
            int i;
            if (this.r.getEventType() == 7) {
                this.r.next();
            } else {
                throw new BioPaxIOException("Unexpected element at start");
            }
            while (this.r.getEventType() == 5) {
                this.r.next();
            }
            if (this.r.getEventType() != 1) {
                throw new BioPaxIOException("Unexpected element at start: " + this.r.getEventType());
            }
            if (!this.r.getLocalName().equalsIgnoreCase("rdf")) {
                throw new BioPaxIOException("Unexpected element at start: " + this.r.getLocalName());
            }
            int count = this.r.getNamespaceCount();
            for (i = 0; i < count; ++i) {
                String pre = this.r.getNamespacePrefix(i);
                if (pre == null) {
                    pre = "";
                }
                String namespace = this.r.getNamespaceURI(pre);
                ns.put(pre, namespace);
            }
            this.base = null;
            for (i = 0; i < this.r.getAttributeCount(); ++i) {
                if (!"base".equalsIgnoreCase(this.r.getAttributeLocalName(i)) || !"xml".equalsIgnoreCase(this.r.getAttributePrefix(i))) continue;
                this.base = this.r.getAttributeValue(i);
            }
        }
        catch (XMLStreamException e) {
            throw new BioPaxIOException(e.getClass().getSimpleName() + " " + e.getMessage() + "; " + e.getLocation());
        }
        return ns;
    }

    @Override
    protected void createAndBind(Model model) {
        try {
            int type;
            while ((type = this.r.getEventType()) != 8) {
                switch (type) {
                    case 1: {
                        if (!BioPAXLevel.isInBioPAXNameSpace(this.r.getName().getNamespaceURI())) break;
                        String lname = this.r.getLocalName();
                        BioPAXLevel level = this.getLevel();
                        Class<? extends BioPAXElement> clazz = null;
                        try {
                            clazz = level.getInterfaceForName(lname);
                        }
                        catch (IllegalBioPAXArgumentException e) {
                            log.fatal("Unknown BioPAX element location " + lname + " at " + this.r.getLocation());
                            throw e;
                        }
                        if (this.getFactory().canInstantiate(clazz)) {
                            this.processIndividual(model);
                            break;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Ignoring element: " + lname);
                        }
                        this.skip();
                        break;
                    }
                    case 4: {
                        if (!log.isTraceEnabled()) break;
                        StringBuffer sb = new StringBuffer("Ignoring text ");
                        if (this.r.hasName()) {
                            sb.append(this.r.getLocalName());
                        }
                        if (this.r.hasText()) {
                            sb.append(this.r.getText());
                        }
                        log.trace(sb.toString());
                        break;
                    }
                    case 2: {
                        if (!log.isTraceEnabled()) break;
                        log.trace(this.r);
                        break;
                    }
                    default: {
                        if (!log.isTraceEnabled()) break;
                        log.trace("Test this!:" + type);
                    }
                }
                this.r.next();
            }
            this.r.close();
        }
        catch (XMLStreamException e) {
            throw new BioPaxIOException(e.getClass().getSimpleName() + " " + e.getMessage() + "; " + e.getLocation());
        }
        for (Triple triple : this.triples) {
            try {
                this.bindValue(triple, model);
            }
            catch (IllegalBioPAXArgumentException e) {
                log.warn("Binding " + e);
            }
        }
    }

    private void bindValue(Triple triple, Model model) {
        if (log.isDebugEnabled()) {
            log.debug(triple);
        }
        BioPAXElement domain = model.getByID(triple.domain);
        PropertyEditor<? extends BioPAXElement, ?> editor = this.getEditorMap().getEditorForProperty(triple.property, domain.getModelInterface());
        this.bindValue(triple.range, editor, domain, model);
    }

    private String processIndividual(Model model) throws XMLStreamException {
        String s = this.r.getLocalName();
        String id = null;
        try {
            id = this.getId();
        }
        catch (NullPointerException e) {
            throw new BioPaxIOException("Error processing individual " + s + ". rdf:ID or rdf:about not found!", e);
        }
        if (this.factory.canInstantiate(this.level.getInterfaceForName(s))) {
            if (!this.mergeDuplicates || model.getByID(id) == null) {
                this.createBpe(s, id, model);
            }
        } else {
            if (this.r.hasText()) {
                log.warn("Unknown class :" + this.r.getText());
            } else {
                log.warn("Unknown class :" + this.r);
            }
            this.skip();
        }
        this.propertyContext = true;
        this.r.next();
        while (this.r.getEventType() != 2) {
            if (this.r.getEventType() == 1) {
                this.processProperty(model, id);
                this.propertyContext = true;
            }
            this.r.next();
        }
        return id;
    }

    private void createBpe(String s, String id, Model model) {
        BioPAXElement bpe = this.factory.create(s, id);
        model.add(bpe);
    }

    private void skip() throws XMLStreamException {
        int depth = 1;
        while (this.r.getEventType() != 2 || depth != 0) {
            this.r.next();
            switch (this.r.getEventType()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
    }

    public String getId() {
        String id = this.r.getAttributeValue(rdfNS, "ID");
        if (id == null) {
            id = this.r.getAttributeValue(rdfNS, "about");
            if (id.startsWith("#")) {
                id = this.base + id.substring(1, id.length());
            }
        } else if (this.base != null) {
            id = this.base + id;
        }
        return id;
    }

    private void processProperty(Model model, String ownerID) throws XMLStreamException {
        if ("http://www.w3.org/2000/01/rdf-schema#".equals(this.r.getNamespaceURI()) && "comment".equals(this.r.getLocalName())) {
            BioPAXElement paxElement = model.getByID(ownerID);
            StringPropertyEditor commentor = this.getRDFCommentEditor(paxElement);
            this.r.next();
            assert (this.r.getEventType() == 4);
            String text = this.r.getText();
            commentor.setValueToBean(text, paxElement);
            log.warn("rdfs:comment is converted into the bp:comment; however, this can be overridden if there exists another bp:comment (element: " + paxElement.getRDFId() + " text: " + text + ")");
            this.gotoEndElement();
        } else if (this.bp != null && this.bp.equals(this.r.getNamespaceURI())) {
            String property = this.r.getLocalName();
            String resource = this.r.getAttributeValue(rdfNS, "resource");
            if (resource != null) {
                if (resource.startsWith("#")) {
                    resource = (this.base == null ? "" : this.base) + resource.substring(1, resource.length());
                }
                this.gotoEndElement();
            } else {
                this.r.next();
                boolean found = false;
                while (this.r.getEventType() != 2) {
                    if (!found && this.r.getEventType() == 4) {
                        StringBuffer buff = new StringBuffer(this.r.getText());
                        this.r.next();
                        while (this.r.getEventType() == 4) {
                            buff.append(this.r.getText());
                            this.r.next();
                        }
                        resource = buff.toString();
                        continue;
                    }
                    if (this.r.getEventType() == 1) {
                        this.propertyContext = false;
                        resource = this.processIndividual(model);
                        found = true;
                        this.r.next();
                        continue;
                    }
                    this.r.next();
                }
                resource = !found && resource != null ? resource.replaceAll("[\n\r\t ]+", " ") : resource;
            }
            log.trace("setting = " + resource);
            this.triples.add(new Triple(ownerID, resource, property));
            this.propertyContext = false;
        } else {
            log.trace("ignoring unknown element " + this.r.getNamespaceURI() + this.r.getLocalName());
            this.gotoEndElement();
        }
    }

    private void gotoEndElement() throws XMLStreamException {
        while (this.r.getEventType() != 2) {
            this.r.next();
        }
    }

    @Override
    public void convertToOWL(Model model, OutputStream outputStream) {
        this.initializeExporter(model);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            this.writeObjects(out, model);
            ((Writer)out).close();
        }
        catch (IOException e) {
            throw new BioPaxIOException("Cannot convert to OWL!", e);
        }
    }

    public void writeObject(Writer out, BioPAXElement bean) throws IOException {
        String name = "bp:" + bean.getModelInterface().getSimpleName();
        this.writeIDLine(out, bean, name);
        Set<PropertyEditor> editors = this.editorMap.getEditorsOf(bean);
        if (editors == null || editors.isEmpty()) {
            log.info("no editors for " + bean.getRDFId() + " | " + bean.getModelInterface().getSimpleName());
            out.write(newline + "</" + name + ">");
            return;
        }
        for (PropertyEditor editor : editors) {
            Set value = editor.getValueFromBean(bean);
            for (Object valueElement : value) {
                if (editor.isUnknown(valueElement)) continue;
                this.writeStatementFor(bean, editor, valueElement, out);
            }
        }
        out.write(newline + "</" + name + ">");
    }

    private void writeObjects(Writer out, Model model) throws IOException {
        this.writeHeader(out);
        Set<BioPAXElement> bioPAXElements = model.getObjects();
        for (BioPAXElement bean : bioPAXElements) {
            this.writeObject(out, bean);
        }
        out.write(newline + "</rdf:RDF>");
    }

    private void writeStatementFor(BioPAXElement bean, PropertyEditor editor, Object value, Writer out) throws IOException {
        assert (bean != null && editor != null && value != null);
        if (editor.getProperty().equalsIgnoreCase("name") && bean instanceof Named) {
            Named named = (Named)bean;
            if (value != null && (value.equals(named.getDisplayName()) || value.equals(named.getStandardName()))) {
                return;
            }
        }
        if (editor.getProperty().equalsIgnoreCase("stepProcess") && bean instanceof BiochemicalPathwayStep) {
            BiochemicalPathwayStep bps = (BiochemicalPathwayStep)bean;
            if (value != null && value.equals(bps.getStepConversion())) {
                return;
            }
        }
        String prop = "bp:" + editor.getProperty();
        out.write(newline + " <" + prop);
        if (value instanceof BioPAXElement) {
            String id = ((BioPAXElement)value).getRDFId();
            assert (id != null);
            if (!this.absoluteUris && this.base != null && id.startsWith(this.base)) {
                id = '#' + id.substring(this.base.length());
            }
            out.write(" rdf:resource=\"" + id + "\" />");
        } else {
            String type = this.findLiteralType(editor);
            String valString = StringEscapeUtils.escapeXml(value.toString());
            out.write(" rdf:datatype = \"http://www.w3.org/2001/XMLSchema#" + type + close + valString + "</" + prop + ">");
        }
    }

    private String findLiteralType(PropertyEditor editor) {
        Class range = editor.getRange();
        String type = null;
        if (range.isEnum() || range.equals(String.class)) {
            type = "string";
        } else if (range.equals(Double.TYPE) || range.equals(Double.class)) {
            type = "double";
        } else if (range.equals(Integer.TYPE) || range.equals(Integer.class)) {
            type = "int";
        } else if (range.equals(Float.TYPE) || range.equals(Float.class)) {
            type = "float";
        } else if (range.equals(Boolean.TYPE) || range.equals(Boolean.class)) {
            type = "boolean";
        } else if (range.equals(Long.TYPE) || range.equals(Long.class)) {
            type = "long";
        }
        return type;
    }

    private void writeIDLine(Writer out, BioPAXElement bpe, String name) throws IOException {
        out.write(newline + newline + "<" + name + " ");
        String s = bpe.getRDFId();
        if (!this.absoluteUris && this.base != null && s.startsWith(this.base)) {
            String id = s.substring(this.base.length());
            out.write(RDF_ID + id + close);
        } else {
            out.write(RDF_about + s + close);
        }
    }

    private void initializeExporter(Model model) {
        BioPAXLevel lev;
        this.base = model.getXmlBase();
        this.namespaces = new HashMap<String, String>(model.getNameSpacePrefixMap());
        this.normalizeNameSpaces();
        if (this.normalizeNameSpaces) {
            model.getNameSpacePrefixMap().clear();
            model.getNameSpacePrefixMap().putAll(this.namespaces);
        }
        if ((lev = model.getLevel()) != this.level) {
            this.resetLevel(lev, lev.getDefaultFactory());
        }
    }

    private void normalizeNameSpaces() {
        String owlPre = null;
        String rdfPre = null;
        String xsdPre = null;
        HashMap<String, String> reverseMap = new HashMap<String, String>();
        for (String pre : this.namespaces.keySet()) {
            String ns = (String)this.namespaces.get(pre);
            if (rdfNS.equalsIgnoreCase(ns)) {
                rdfPre = pre;
            } else if (owlNS.equalsIgnoreCase(ns)) {
                owlPre = pre;
            } else if (xsdNS.equalsIgnoreCase(ns)) {
                xsdPre = pre;
            }
            if (ns == null) continue;
            reverseMap.put(ns, pre);
        }
        if (owlPre != null) {
            reverseMap.remove(this.namespaces.get(owlPre));
            this.namespaces.remove(owlPre);
        }
        if (rdfPre != null) {
            reverseMap.remove(this.namespaces.get(rdfPre));
            this.namespaces.remove(rdfPre);
        }
        if (xsdPre != null) {
            reverseMap.remove(this.namespaces.get(xsdPre));
            this.namespaces.remove(xsdPre);
        }
        this.namespaces.put("rdf", rdfNS);
        this.namespaces.put("owl", owlNS);
        this.namespaces.put("xsd", xsdNS);
    }

    private void writeHeader(Writer out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.write(newline + "<rdf:RDF");
        String bpns = this.editorMap.getLevel().getNameSpace();
        for (String pre : this.namespaces.keySet()) {
            if (pre.equals("bp")) continue;
            out.write(newline + " xmlns" + ("".equals(pre) || pre == null ? "" : ":" + pre) + "=\"" + (String)this.namespaces.get(pre) + "\"");
        }
        out.write(newline + " xmlns:bp" + "=\"" + bpns + "\"");
        if (this.base != null) {
            out.write(newline + " xml:base=\"" + this.base + "\"");
        }
        out.write(">");
        out.write(newline + "<owl:Ontology rdf:about=\"\">");
        out.write(newline + " <owl:imports rdf:resource=\"" + bpns + "\" />");
        out.write(newline + "</owl:Ontology>");
    }

    public void absoluteUris(boolean absoluteUris) {
        this.absoluteUris = absoluteUris;
    }

    public boolean isAbsoluteUris() {
        return this.absoluteUris;
    }

    public void normalizeNameSpaces(boolean normalizeNameSpaces) {
        this.normalizeNameSpaces = normalizeNameSpaces;
    }

    public boolean isNormalizeNameSpaces() {
        return this.normalizeNameSpaces;
    }

    public boolean isMergeDuplicates() {
        return this.mergeDuplicates;
    }

    public static String convertToOwl(Model model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new SimpleIOHandler(model.getLevel()).convertToOWL(model, outputStream);
        try {
            return outputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e);
            return outputStream.toString();
        }
    }

    public class Triple {
        public String domain;
        public String range;
        public String property;

        private Triple(String domain, String range, String property) {
            this.domain = domain;
            this.range = range;
            this.property = property;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("domain: ");
            sb.append(this.domain);
            sb.append(", property: ");
            sb.append(this.property);
            sb.append(", range: ");
            sb.append(this.range);
            return sb.toString();
        }
    }
}

