/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.util.ProgressWatcher;

public class Searcher {
    private static BioPAXIOHandler handler = new SimpleIOHandler();
    private static final SimpleEditorMap EM = SimpleEditorMap.L3;

    public static List<Match> search(Match m, Pattern pattern) {
        assert (pattern.getStartingClass().isAssignableFrom(m.get(0).getModelInterface()));
        return Searcher.searchRecursive(m, pattern.getConstraints(), 0);
    }

    public static List<Match> search(BioPAXElement ele, Pattern pattern) {
        assert (pattern.getStartingClass().isAssignableFrom(ele.getModelInterface()));
        Match m = new Match(pattern.size());
        m.set(ele, 0);
        return Searcher.search(m, pattern);
    }

    public static List<Match> searchRecursive(Match match, List<MappedConst> mc, int index) {
        ArrayList<Match> result = new ArrayList<Match>();
        Constraint con = mc.get(index).getConstr();
        int[] ind = mc.get(index).getInds();
        int lastInd = ind[ind.length - 1];
        if (con.canGenerate() && match.get(lastInd) == null) {
            Collection<BioPAXElement> elements = con.generate(match, ind);
            for (BioPAXElement ele : elements) {
                match.set(ele, lastInd);
                if (mc.size() == index + 1) {
                    result.add((Match)match.clone());
                } else {
                    result.addAll(Searcher.searchRecursive(match, mc, index + 1));
                }
                match.set(null, lastInd);
            }
        } else if (con.satisfies(match, ind)) {
            if (mc.size() == index + 1) {
                result.add((Match)match.clone());
            } else {
                result.addAll(Searcher.searchRecursive(match, mc, index + 1));
            }
        }
        return result;
    }

    public static List<Match> searchPlain(Model model, Pattern pattern) {
        LinkedList<Match> list = new LinkedList<Match>();
        Map<BioPAXElement, List<Match>> map = Searcher.search(model, pattern);
        for (List<Match> matches : map.values()) {
            list.addAll(matches);
        }
        return list;
    }

    public static List<Match> searchPlain(Collection<? extends BioPAXElement> eles, Pattern pattern) {
        LinkedList<Match> list = new LinkedList<Match>();
        Map<BioPAXElement, List<Match>> map = Searcher.search(eles, pattern);
        for (List<Match> matches : map.values()) {
            list.addAll(matches);
        }
        return list;
    }

    public static Map<BioPAXElement, List<Match>> search(Model model, Pattern pattern) {
        return Searcher.search(model, pattern, null);
    }

    public static Map<BioPAXElement, List<Match>> search(Model model, Pattern pattern, ProgressWatcher prg) {
        HashMap<BioPAXElement, List<Match>> map = new HashMap<BioPAXElement, List<Match>>();
        Set<? extends BioPAXElement> eles = model.getObjects(pattern.getStartingClass());
        if (prg != null) {
            prg.setTotalTicks(eles.size());
        }
        for (BioPAXElement bioPAXElement : eles) {
            List<Match> matches = Searcher.search(bioPAXElement, pattern);
            if (!matches.isEmpty()) {
                map.put(bioPAXElement, matches);
            }
            if (prg == null) continue;
            prg.tick(1);
        }
        return map;
    }

    public static Map<BioPAXElement, List<Match>> search(Collection<? extends BioPAXElement> eles, Pattern pattern) {
        HashMap<BioPAXElement, List<Match>> map = new HashMap<BioPAXElement, List<Match>>();
        for (BioPAXElement bioPAXElement : eles) {
            List<Match> matches;
            if (!pattern.getStartingClass().isAssignableFrom(bioPAXElement.getModelInterface()) || (matches = Searcher.search(bioPAXElement, pattern)).isEmpty()) continue;
            map.put(bioPAXElement, matches);
        }
        return map;
    }

    public static <T extends BioPAXElement> Set<T> searchAndCollect(Model model, Pattern pattern, int index, Class<T> c) {
        return Searcher.searchAndCollect(model.getObjects(pattern.getStartingClass()), pattern, index, c);
    }

    public static <T extends BioPAXElement> Set<T> searchAndCollect(Collection<? extends BioPAXElement> eles, Pattern pattern, int index, Class<T> c) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (Match match : Searcher.searchPlain(eles, pattern)) {
            set.add(match.get(index));
        }
        return set;
    }

    public static <T extends BioPAXElement> Set<T> searchAndCollect(BioPAXElement ele, Pattern pattern, int index, Class<T> c) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (Match match : Searcher.search(ele, pattern)) {
            set.add(match.get(index));
        }
        return set;
    }

    public boolean hasSolution(Pattern p, BioPAXElement ... ele) {
        Match m = new Match(p.size());
        for (int i = 0; i < ele.length; ++i) {
            m.set(ele[i], i);
        }
        return !Searcher.search(m, p).isEmpty();
    }

    public static void searchInFile(Pattern p, String inFile, String outFile) throws FileNotFoundException {
        Searcher.searchInFile(p, inFile, outFile, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static void searchInFile(Pattern p, String inFile, String outFile, int seedLimit, int graphPerSeed) throws FileNotFoundException {
        SimpleIOHandler h = new SimpleIOHandler();
        Model model = h.convertFromOWL(new FileInputStream(inFile));
        Map<BioPAXElement, List<Match>> matchMap = Searcher.search(model, p);
        System.out.println("matching groups size = " + matchMap.size());
        LinkedList<Set<Interaction>> inters = new LinkedList<Set<Interaction>>();
        HashSet<Integer> encountered = new HashSet<Integer>();
        HashSet<BioPAXElement> toExise = new HashSet<BioPAXElement>();
        int seedCounter = 0;
        block0: for (BioPAXElement ele : matchMap.keySet()) {
            if (seedCounter >= seedLimit) break;
            int matchCounter = 0;
            List<Match> list = matchMap.get(ele);
            if (!list.isEmpty()) {
                ++seedCounter;
            }
            for (Match match : list) {
                if (++matchCounter > graphPerSeed) continue block0;
                Set<Interaction> ints = Searcher.getInter(match);
                toExise.addAll(Arrays.asList(match.getVariables()));
                toExise.addAll(ints);
                Integer hash = Searcher.hashSum(ints);
                if (encountered.contains(hash)) continue;
                encountered.add(hash);
                inters.add(ints);
            }
        }
        System.out.println("created pathways = " + inters.size());
        Model clonedModel = Searcher.excise(model, toExise);
        int i = 0;
        for (Set set : inters) {
            Pathway pathway2 = clonedModel.addNew(Pathway.class, System.currentTimeMillis() + "PaxtoolsPatternGeneratedMatch" + ++i);
            pathway2.setDisplayName("Match " + Searcher.getLeadingZeros(i, inters.size()) + i);
            for (Interaction anInt : set) {
                pathway2.addPathwayComponent((Process)clonedModel.getByID(anInt.getRDFId()));
            }
        }
        handler.convertToOWL(clonedModel, new FileOutputStream(outFile));
    }

    private static String getLeadingZeros(int i, int size) {
        assert (i <= size);
        int w1 = (int)Math.floor(Math.log10(size));
        int w2 = (int)Math.floor(Math.log10(i));
        String s = "";
        for (int j = w2; j < w1; ++j) {
            s = s + "0";
        }
        return s;
    }

    private static Model excise(Model model, Set<BioPAXElement> result) {
        Completer c = new Completer(EM);
        result = c.complete(result, model);
        Cloner cln = new Cloner(EM, BioPAXLevel.L3.getDefaultFactory());
        return cln.clone(model, result);
    }

    private static Set<Interaction> getInter(Match match) {
        HashSet<Interaction> set = new HashSet<Interaction>();
        for (BioPAXElement ele : match.getVariables()) {
            if (!(ele instanceof Interaction)) continue;
            set.add((Interaction)ele);
            Searcher.addControlsRecursive((Interaction)ele, set);
        }
        return set;
    }

    private static void addControlsRecursive(Interaction inter, Set<Interaction> set) {
        for (Control ctrl : inter.getControlledOf()) {
            set.add(ctrl);
            Searcher.addControlsRecursive(ctrl, set);
        }
    }

    private static Integer hashSum(Set<Interaction> set) {
        int x = 0;
        for (Interaction inter : set) {
            x += inter.hashCode();
        }
        return x;
    }
}

