/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.SequenceEntity;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.miner.MinerAdapter;

public class DirectedRelationMiner
extends MinerAdapter {
    public DirectedRelationMiner() {
        super("directed-relations", "Finds relations between proteins where the first one is controlling an interaction where the second protein is participant.");
    }

    @Override
    public Pattern constructPattern() {
        Pattern p = new Pattern(SequenceEntityReference.class, "controller ER");
        p.add(ConBox.isHuman(), "controller ER");
        p.add(ConBox.linkedER(true), "controller ER", "controller generic ER");
        p.add(ConBox.erToPE(), "controller generic ER", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToInter(), "Control", "Interaction");
        p.add((Constraint)new NOT(ConBox.participantER()), "Interaction", "controller ER");
        p.add(ConBox.participant(), "Interaction", "affected PE");
        p.add(ConBox.linkToSpecific(), "affected PE", "affected simple PE");
        p.add((Constraint)new Type(SequenceEntity.class), "affected simple PE");
        p.add(ConBox.peToER(), "affected simple PE", "affected generic ER");
        p.add(ConBox.peToER(), "affected generic ER", "affected ER");
        return p;
    }

    @Override
    public void writeResult(Map<BioPAXElement, List<Match>> matches, OutputStream out) throws IOException {
        this.writeResultAsSIF(matches, out, true, this.getSourceLabel(), this.getTargetLabel());
    }

    @Override
    public String getHeader() {
        return "Upstream\tDownstream";
    }

    public String getSourceLabel() {
        return "controller ER";
    }

    public String getTargetLabel() {
        return "affected ER";
    }

    @Override
    public String[] getMediatorLabels() {
        return new String[]{"Control", "Interaction"};
    }
}

