/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFInteraction;

public class OldFormatWriter {
    private static final PathAccessor[] ACCS = new PathAccessor[]{new PathAccessor("Named/displayName"), new PathAccessor("XReferrable/xref:UnificationXref"), new PathAccessor("XReferrable/xref:RelationshipXref")};

    public static boolean write(Set<SIFInteraction> inters, OutputStream out) {
        CustomFormat stt = new CustomFormat(OutputColumn.Type.RESOURCE.name(), OutputColumn.Type.PUBMED.name(), OutputColumn.Type.PATHWAY.name());
        if (!inters.isEmpty()) {
            ArrayList<SIFInteraction> interList = new ArrayList<SIFInteraction>(inters);
            Collections.sort(interList);
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out);
                writer.write("PARTICIPANT_A\tINTERACTION_TYPE\tPARTICIPANT_B\tINTERACTION_DATA_SOURCE\tINTERACTION_PUBMED_ID\tPATHWAY_NAMES");
                for (SIFInteraction inter : interList) {
                    writer.write("\n" + stt.convert(inter));
                }
                OldFormatWriter.writeSourceAndTargetDetails(inters, writer);
                writer.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void writeSourceAndTargetDetails(Collection<SIFInteraction> inters, Writer writer) throws IOException {
        Map<String, Set<BioPAXElement>> map = OldFormatWriter.collectEntityRefs(inters);
        writer.write("\n\nPARTICIPANT\tPARTICIPANT_TYPE\tPARTICIPANT_NAME\tUNIFICATION_XREF\tRELATIONSHIP_XREF");
        for (String id : map.keySet()) {
            writer.write("\n" + id + "\t" + OldFormatWriter.getParticipantTypes(map.get(id)));
            for (PathAccessor acc : ACCS) {
                writer.write("\t" + OldFormatWriter.getValue(map.get(id), acc));
            }
        }
    }

    private static Map<String, Set<BioPAXElement>> collectEntityRefs(Collection<SIFInteraction> inters) {
        HashMap<String, Set<BioPAXElement>> map = new HashMap<String, Set<BioPAXElement>>();
        for (SIFInteraction inter : inters) {
            if (!map.containsKey(inter.sourceID)) {
                map.put(inter.sourceID, new HashSet());
            }
            if (!map.containsKey(inter.targetID)) {
                map.put(inter.targetID, new HashSet());
            }
            ((Set)map.get(inter.sourceID)).addAll(inter.sourceERs);
            ((Set)map.get(inter.targetID)).addAll(inter.targetERs);
        }
        return map;
    }

    private static String getParticipantTypes(Set<BioPAXElement> elements) {
        HashSet<String> set = new HashSet<String>();
        for (BioPAXElement ele : elements) {
            String name = ele.getModelInterface().getName();
            set.add(name.substring(name.lastIndexOf(".") + 1));
        }
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return OldFormatWriter.concat(list);
    }

    private static String getValue(Set<BioPAXElement> elements, PathAccessor pa) {
        HashSet<String> set = new HashSet<String>();
        for (Object o : pa.getValueFromBeans((Collection<? extends BioPAXElement>)elements)) {
            set.add(o.toString());
        }
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return OldFormatWriter.concat(list);
    }

    private static String concat(Collection<String> col) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : col) {
            if (first) {
                first = false;
            } else {
                b.append(";");
            }
            b.append(s);
        }
        return b.toString();
    }
}

