/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.PathConstraint;
import org.biopax.paxtools.pattern.constraint.Size;
import org.biopax.paxtools.pattern.miner.MinerAdapter;

public class UbiquitousIDMiner
extends MinerAdapter {
    public UbiquitousIDMiner() {
        super("ubiquitous-molecule-lister", "Finds small molecules that participate in at least 50 Conversions. Writes down IDs of these molecules to the output file, one ID per line.");
    }

    @Override
    public Pattern constructPattern() {
        Pattern p = new Pattern(SmallMoleculeReference.class, "SMR");
        p.add((Constraint)new Size(new PathConstraint("SmallMoleculeReference/entityReferenceOf/participantOf:Conversion"), 50, Size.Type.GREATER_OR_EQUAL), "SMR");
        return p;
    }

    @Override
    public void writeResult(Map<BioPAXElement, List<Match>> matches, OutputStream out) throws IOException {
        this.writeResultDetailed(matches, out, 1);
    }

    @Override
    public String getHeader() {
        return "IDs of ubiquitous elements";
    }

    @Override
    public String getValue(Match m, int col) {
        assert (col == 0);
        return this.getRelatedIDs((SmallMoleculeReference)m.get("SMR", this.getPattern()));
    }

    private String getRelatedIDs(SmallMoleculeReference smr) {
        String ids = smr.getRDFId();
        for (Object o : new PathAccessor("SmallMoleculeReference/entityReferenceOf").getValueFromBean(smr)) {
            SimplePhysicalEntity spe = (SimplePhysicalEntity)o;
            ids = ids + "\n" + spe.getRDFId();
        }
        return ids;
    }
}

