/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.LNodeDegreeSort;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.avsdf.AVSDFCircle;
import org.ivis.layout.avsdf.AVSDFEdge;
import org.ivis.layout.avsdf.AVSDFLayout;
import org.ivis.layout.avsdf.AVSDFNode;
import org.ivis.layout.cise.CiSECircle;
import org.ivis.layout.cise.CiSEEdge;
import org.ivis.layout.cise.CiSEGraphManager;
import org.ivis.layout.cise.CiSENode;
import org.ivis.layout.cise.CiSENodeSort;
import org.ivis.layout.cise.CiSEOnCircleNodeExt;
import org.ivis.layout.cise.CiSEOnCircleNodePair;
import org.ivis.layout.cise.CircularForce;
import org.ivis.layout.cose.CoSEEdge;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.fd.FDLayout;
import org.ivis.util.IndexedObjectSort;
import org.ivis.util.IntegerQuickSort;
import org.ivis.util.PointD;

public class CiSELayout
extends FDLayout {
    public int nodeSeperation = 12;
    public double idealInterClusterEdgeLengthCoefficient = 1.4;
    public boolean allowNodesInsideCircle;
    public double maxRatioOfNodesInsideCircle;
    private int step = 0;
    private int phase = 0;
    private Set<CiSEOnCircleNodePair> swappedPairsInLastIteration = new HashSet<CiSEOnCircleNodePair>();
    public static final int STEP_NOT_STARTED = 0;
    public static final int STEP_1 = 1;
    public static final int STEP_2 = 2;
    public static final int STEP_3 = 3;
    public static final int STEP_4 = 4;
    public static final int STEP_5 = 5;
    int iterations = 0;
    public static final int PHASE_NOT_STARTED = 0;
    public static final int PHASE_SWAP_PREPERATION = 1;
    public static final int PHASE_PERFORM_SWAP = 2;
    public static final int PHASE_OTHER = 3;

    public CiSELayout() {
        this.oldTotalDisplacement = 0.0;
    }

    @Override
    protected LGraphManager newGraphManager() {
        CiSEGraphManager gm = new CiSEGraphManager(this);
        this.graphManager = gm;
        return gm;
    }

    @Override
    public LGraph newGraph(Object vGraph) {
        return new CiSECircle(null, this.graphManager, vGraph);
    }

    @Override
    public LNode newNode(Object vNode) {
        return new CiSENode(this.graphManager, vNode);
    }

    public LNode newCiSEOnCircleNode(Object vNode) {
        CiSENode newNode = (CiSENode)this.newNode(vNode);
        newNode.setAsOnCircleNode();
        return newNode;
    }

    @Override
    public LEdge newEdge(Object vEdge) {
        return new CiSEEdge(null, null, vEdge);
    }

    protected boolean convertToClusteredGraph() {
        CiSECircle circle;
        String targetClusterID;
        String sourceClusterID;
        CiSENode targetNode;
        CiSEEdge edge;
        LinkedList[] nodeAndEdgeLists;
        if (this.graphManager.getGraphs().size() > 1) {
            return false;
        }
        LGraph rootGraph = this.graphManager.getRoot();
        HashMap<String, LinkedList[]> clusterMap = new HashMap<String, LinkedList[]>();
        for (Object obj : this.getAllNodes()) {
            String clusterID2 = ((LNode)obj).getClusterID();
            if (clusterID2 == null) continue;
            nodeAndEdgeLists = (LinkedList[])clusterMap.get(clusterID2);
            if (nodeAndEdgeLists == null) {
                nodeAndEdgeLists = new LinkedList[]{new LinkedList(), new LinkedList()};
                clusterMap.put(clusterID2, nodeAndEdgeLists);
            }
            nodeAndEdgeLists[0].add(obj);
        }
        Iterator iter = clusterMap.keySet().iterator();
        LinkedList<String> singleNodeClusterList = new LinkedList<String>();
        while (iter.hasNext()) {
            String clusterID = (String)iter.next();
            nodeAndEdgeLists = (LinkedList[])clusterMap.get(clusterID);
            LinkedList nodeList = nodeAndEdgeLists[0];
            if (nodeList.size() >= 2) continue;
            singleNodeClusterList.add(clusterID);
            ((LNode)nodeList.getFirst()).resetClusters();
        }
        for (Object e : singleNodeClusterList) {
            clusterMap.remove(e);
        }
        for (Object obj : this.getAllEdges()) {
            edge = (CiSEEdge)obj;
            CiSENode ciSENode = (CiSENode)edge.getSource();
            targetNode = (CiSENode)edge.getTarget();
            sourceClusterID = ciSENode.getClusterID();
            targetClusterID = targetNode.getClusterID();
            edge.isIntraCluster = false;
            if (sourceClusterID != null && targetClusterID != null) {
                if (sourceClusterID.equals(targetClusterID)) {
                    edge.isIntraCluster = true;
                }
                nodeAndEdgeLists = (LinkedList[])clusterMap.get(sourceClusterID);
                nodeAndEdgeLists[1].add(edge);
                rootGraph.remove(edge);
                continue;
            }
            if (sourceClusterID != null && targetClusterID == null) {
                nodeAndEdgeLists = (LinkedList[])clusterMap.get(sourceClusterID);
                nodeAndEdgeLists[1].add(edge);
                rootGraph.remove(edge);
                continue;
            }
            if (sourceClusterID != null || targetClusterID == null) continue;
            nodeAndEdgeLists = (LinkedList[])clusterMap.get(targetClusterID);
            nodeAndEdgeLists[1].add(edge);
            rootGraph.remove(edge);
        }
        for (String clusterID : clusterMap.keySet()) {
            nodeAndEdgeLists = (LinkedList[])clusterMap.get(clusterID);
            LinkedList nodeList = nodeAndEdgeLists[0];
            CiSENode clusterNode = (CiSENode)this.newNode(null);
            this.graphManager.getRoot().add(clusterNode);
            circle = (CiSECircle)this.newGraph(null);
            this.graphManager.add(circle, clusterNode);
            circle.setMargin(circle.getMargin() + 15);
            for (Object obj : nodeList) {
                CiSENode node = (CiSENode)obj;
                assert (node.getEdges().size() == 0);
                node.getOwner().remove(node);
                node.setAsOnCircleNode();
                circle.add(node);
                circle.getInNodes().add(node);
            }
        }
        for (String clusterID : clusterMap.keySet()) {
            nodeAndEdgeLists = (LinkedList[])clusterMap.get(clusterID);
            LinkedList edgeList = nodeAndEdgeLists[1];
            for (Object obj : edgeList) {
                edge = (CiSEEdge)obj;
                if (edge.isIntraCluster) {
                    edge.getSource().getOwner().add(edge, edge.getSource(), edge.getTarget());
                    assert (!edge.isInterGraph()) : "Must not be an inter-graph edge!";
                    continue;
                }
                this.graphManager.add(edge, edge.getSource(), edge.getTarget());
                assert (edge.isInterGraph()) : "Must be an inter-graph edge!";
            }
        }
        this.graphManager.resetAllNodes();
        int onCircleNodeCount = 0;
        for (Object lGraph : this.graphManager.getGraphs()) {
            if (lGraph == rootGraph) continue;
            onCircleNodeCount += ((LGraph)lGraph).getNodes().size();
        }
        int nonOnCircleNodeCount = rootGraph.getNodes().size();
        CiSENode[] nonOnCircleNodes = new CiSENode[nonOnCircleNodeCount];
        CiSENode[] onCircleNodes = new CiSENode[onCircleNodeCount];
        int onCircleIndex = 0;
        int nonOnCircleIndex = 0;
        for (Object obj : this.graphManager.getAllNodes()) {
            CiSENode node = (CiSENode)obj;
            if (node.getOnCircleNodeExt() != null) {
                onCircleNodes[onCircleIndex] = node;
                ++onCircleIndex;
                continue;
            }
            nonOnCircleNodes[nonOnCircleIndex] = node;
            ++nonOnCircleIndex;
        }
        this.getCiSEGraphManager().setOnCircleNodes(onCircleNodes);
        this.getCiSEGraphManager().setNonOnCircleNodes(nonOnCircleNodes);
        this.getCiSEGraphManager().setInCircleNodes(new CiSENode[0]);
        for (Object obj : this.getGraphManager().getInterGraphEdges()) {
            edge = (CiSEEdge)obj;
            assert (edge.isInterGraph());
            CiSENode ciSENode = (CiSENode)edge.getSource();
            targetNode = (CiSENode)edge.getTarget();
            sourceClusterID = ciSENode.getClusterID();
            targetClusterID = targetNode.getClusterID();
            assert (sourceClusterID == null || targetClusterID == null || !sourceClusterID.equals(targetClusterID));
            if (sourceClusterID != null && (circle = (CiSECircle)ciSENode.getOwner()).getInNodes().remove(ciSENode)) {
                circle.getOutNodes().add(ciSENode);
            }
            if (targetClusterID == null || !(circle = (CiSECircle)targetNode.getOwner()).getInNodes().remove(targetNode)) continue;
            circle.getOutNodes().add(targetNode);
        }
        return true;
    }

    @Override
    public void initParameters() {
        super.initParameters();
        if (!this.isSubLayout) {
            LayoutOptionsPack.CiSE layoutOptionsPack = LayoutOptionsPack.getInstance().getCiSE();
            this.nodeSeperation = layoutOptionsPack.nodeSeparation;
            this.idealEdgeLength = layoutOptionsPack.desiredEdgeLength;
            this.idealInterClusterEdgeLengthCoefficient = CiSELayout.transform(layoutOptionsPack.interClusterEdgeLengthFactor, 1.4);
            this.allowNodesInsideCircle = layoutOptionsPack.allowNodesInsideCircle;
            this.maxRatioOfNodesInsideCircle = layoutOptionsPack.maxRatioOfNodesInsideCircle;
        }
        this.springConstant = 0.675;
        this.repulsionConstant = 4500.0;
        this.gravityConstant = 0.4;
        this.incremental = true;
    }

    public CiSENode[] getOnCircleNodes() {
        return this.getCiSEGraphManager().getOnCircleNodes();
    }

    public CiSENode[] getNonOnCircleNodes() {
        return this.getCiSEGraphManager().getNonOnCircleNodes();
    }

    public CiSENode[] getInCircleNodes() {
        return this.getCiSEGraphManager().getInCircleNodes();
    }

    public CiSEGraphManager getCiSEGraphManager() {
        return (CiSEGraphManager)this.graphManager;
    }

    public int getNodeSeparation() {
        return this.nodeSeperation;
    }

    @Override
    public boolean layout() {
        LGraph root = this.graphManager.getRoot();
        if (!this.convertToClusteredGraph()) {
            return false;
        }
        root.updateConnected();
        root.calcEstimatedSize();
        this.doStep1();
        this.doStep2();
        root.setEstimatedSize(root.getBiggerDimension());
        this.prepareCirclesForReversal();
        this.calcIdealEdgeLengths(false);
        this.doStep5();
        this.doStep3();
        this.doStep5();
        this.doStep4();
        this.findAndMoveInnerNodes();
        this.calcIdealEdgeLengths(true);
        this.doStep5();
        System.out.println("CiSE layout finished after " + this.totalIterations + " iterations");
        return true;
    }

    public void doStep1() {
        this.step = 1;
        this.phase = 3;
        HashMap<CiSENode, AVSDFNode> ciseToAvsdf = new HashMap<CiSENode, AVSDFNode>();
        for (Object graph : this.graphManager.getGraphs()) {
            PointD loc;
            AVSDFNode avsdfNode;
            LGraph lgraph = (LGraph)graph;
            if (lgraph == this.graphManager.getRoot()) {
                assert (lgraph.getParent().getOwner() == null);
                continue;
            }
            AVSDFLayout avsdfLayout = new AVSDFLayout();
            avsdfLayout.isSubLayout = true;
            avsdfLayout.setNodeSeparation(this.nodeSeperation);
            AVSDFCircle avsdfCircle = (AVSDFCircle)avsdfLayout.getGraphManager().addRoot();
            CiSECircle ciseCircle = (CiSECircle)lgraph;
            List<Object> clusteredNodes = ciseCircle.getOnCircleNodes();
            Iterator<CiSENode> i$ = clusteredNodes.iterator();
            while (i$.hasNext()) {
                CiSENode node;
                CiSENode ciseOnCircleNode = node = i$.next();
                avsdfNode = (AVSDFNode)avsdfLayout.newNode(ciseOnCircleNode.vGraphObject);
                loc = ciseOnCircleNode.getLocation();
                avsdfNode.setLocation(loc.x, loc.y);
                avsdfNode.setWidth(ciseOnCircleNode.getWidth());
                avsdfNode.setHeight(ciseOnCircleNode.getHeight());
                avsdfCircle.add(avsdfNode);
                ciseToAvsdf.put(ciseOnCircleNode, avsdfNode);
            }
            for (Object edge : this.getAllEdges()) {
                CiSEEdge ciseEdge = (CiSEEdge)edge;
                if (!clusteredNodes.contains(ciseEdge.getSource()) || !clusteredNodes.contains(ciseEdge.getTarget())) continue;
                AVSDFNode avsdfSource = (AVSDFNode)ciseToAvsdf.get(ciseEdge.getSource());
                AVSDFNode avsdfTarget = (AVSDFNode)ciseToAvsdf.get(ciseEdge.getTarget());
                AVSDFEdge avsdfEdge = (AVSDFEdge)avsdfLayout.newEdge("");
                avsdfCircle.add(avsdfEdge, avsdfSource, avsdfTarget);
            }
            avsdfLayout.runLayout();
            i$ = clusteredNodes.iterator();
            while (i$.hasNext()) {
                CiSENode node;
                CiSENode ciseOnCircleNode = node = i$.next();
                avsdfNode = (AVSDFNode)ciseToAvsdf.get(ciseOnCircleNode);
                loc = avsdfNode.getLocation();
                ciseOnCircleNode.setLocation(loc.x, loc.y);
                ciseOnCircleNode.getOnCircleNodeExt().setIndex(avsdfNode.getIndex());
                ciseOnCircleNode.getOnCircleNodeExt().setAngle(avsdfNode.getAngle());
            }
            CiSENodeSort sorter = new CiSENodeSort(clusteredNodes);
            sorter.quicksort();
            if (avsdfCircle.getNodes().size() <= 0) continue;
            LNode parentCiSE = ciseCircle.getParent();
            LNode parentAVSDF = avsdfCircle.getParent();
            parentCiSE.setLocation(parentAVSDF.getLocation().x, parentAVSDF.getLocation().y);
            ciseCircle.setRadius(avsdfCircle.getRadius());
            ciseCircle.calculateParentNodeDimension();
        }
    }

    public void doStep2() {
        CiSENode ciseNode;
        int i;
        PointD loc;
        this.step = 2;
        this.phase = 3;
        ArrayList<CoSENode> newCoSENodes = new ArrayList<CoSENode>();
        ArrayList<CoSEEdge> newCoSEEdges = new ArrayList<CoSEEdge>();
        HashMap<CiSENode, CoSENode> ciseNodeToCoseNode = new HashMap<CiSENode, CoSENode>();
        HashMap<CoSEEdge, Set<CiSEEdge>> coseEdgeToCiseEdges = new HashMap<CoSEEdge, Set<CiSEEdge>>();
        CoSELayout coseLayout = new CoSELayout();
        coseLayout.isSubLayout = true;
        coseLayout.useMultiLevelScaling = false;
        coseLayout.useFRGridVariant = true;
        coseLayout.springConstant *= 1.5;
        LGraph coseRoot = coseLayout.getGraphManager().addRoot();
        CiSENode[] nonOnCircleNodes = this.getNonOnCircleNodes();
        for (int i2 = 0; i2 < nonOnCircleNodes.length; ++i2) {
            CiSENode ciseNode2 = nonOnCircleNodes[i2];
            CoSENode newNode = (CoSENode)coseLayout.newNode(ciseNode2.vGraphObject);
            loc = ciseNode2.getLocation();
            newNode.setLocation(loc.x, loc.y);
            newNode.setWidth(ciseNode2.getWidth());
            newNode.setHeight(ciseNode2.getHeight());
            if (ciseNode2.getChild() != null) {
                newNode.setWidth(1.2 * newNode.getWidth());
                newNode.setHeight(1.2 * newNode.getHeight());
            }
            coseRoot.add(newNode);
            newCoSENodes.add(newNode);
            ciseNodeToCoseNode.put(ciseNode2, newNode);
        }
        CoSEEdge[][] nodePairs = new CoSEEdge[newCoSENodes.size()][newCoSENodes.size()];
        Object[] allEdges = this.graphManager.getAllEdges();
        for (i = 0; i < allEdges.length; ++i) {
            CoSEEdge newEdge;
            int targetIndex;
            CiSEEdge ciseEdge = (CiSEEdge)allEdges[i];
            CiSENode sourceCise = (CiSENode)ciseEdge.getSource();
            CiSENode targetCise = (CiSENode)ciseEdge.getTarget();
            if (sourceCise.getOnCircleNodeExt() != null) {
                sourceCise = (CiSENode)ciseEdge.getSource().getOwner().getParent();
            }
            if (targetCise.getOnCircleNodeExt() != null) {
                targetCise = (CiSENode)ciseEdge.getTarget().getOwner().getParent();
            }
            CoSENode sourceCose = ciseNodeToCoseNode.get(sourceCise);
            CoSENode targetCose = ciseNodeToCoseNode.get(targetCise);
            assert (sourceCose != null && targetCose != null);
            int sourceIndex = newCoSENodes.indexOf(sourceCose);
            if (sourceIndex == (targetIndex = newCoSENodes.indexOf(targetCose))) continue;
            if (nodePairs[sourceIndex][targetIndex] == null && nodePairs[targetIndex][sourceIndex] == null) {
                newEdge = (CoSEEdge)coseLayout.newEdge("");
                coseRoot.add(newEdge, sourceCose, targetCose);
                newCoSEEdges.add(newEdge);
                coseEdgeToCiseEdges.put(newEdge, new HashSet());
                nodePairs[sourceIndex][targetIndex] = newEdge;
                nodePairs[targetIndex][sourceIndex] = newEdge;
            } else {
                assert (nodePairs[sourceIndex][targetIndex] == nodePairs[targetIndex][sourceIndex]);
                newEdge = nodePairs[sourceIndex][targetIndex];
            }
            coseEdgeToCiseEdges.get(newEdge).add(ciseEdge);
        }
        this.reorderIncidentEdges(ciseNodeToCoseNode, coseEdgeToCiseEdges);
        coseLayout.runLayout();
        nonOnCircleNodes = this.getNonOnCircleNodes();
        for (i = 0; i < nonOnCircleNodes.length; ++i) {
            ciseNode = nonOnCircleNodes[i];
            CoSENode coseNode = ciseNodeToCoseNode.get(ciseNode);
            loc = coseNode.getLocation();
            ciseNode.setLocation(loc.x, loc.y);
        }
        CiSENode[] onCircleNodes = this.getOnCircleNodes();
        for (int i3 = 0; i3 < onCircleNodes.length; ++i3) {
            ciseNode = onCircleNodes[i3];
            loc = ciseNode.getLocation();
            PointD parentLoc = ciseNode.getOwner().getParent().getLocation();
            ciseNode.setLocation(loc.x + parentLoc.x, loc.y + parentLoc.y);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reorderIncidentEdges(HashMap<CiSENode, CoSENode> ciseNodeToCoseNode, HashMap<CoSEEdge, Set<CiSEEdge>> coseEdgeToCiseEdges) {
        CiSENode[] nonOnCircleNodes = this.getNonOnCircleNodes();
        for (int i = 0; i < nonOnCircleNodes.length; ++i) {
            if (nonOnCircleNodes[i].getChild() == null) continue;
            CiSECircle ciseCircle = (CiSECircle)nonOnCircleNodes[i].getChild();
            int mod = ciseCircle.getOnCircleNodes().size();
            CoSENode coseNode = ciseNodeToCoseNode.get(ciseCircle.getParent());
            List incidentCoseEdges = coseNode.getEdges();
            HashMap<Object, Double> indexMapping = new HashMap<Object, Double>();
            for (int j = 0; j < incidentCoseEdges.size(); ++j) {
                void var20_23;
                CoSEEdge coseEdge = (CoSEEdge)incidentCoseEdges.get(j);
                ArrayList<Object> edgeIndices = new ArrayList<Object>();
                Set<CiSEEdge> ciseEdges = coseEdgeToCiseEdges.get(coseEdge);
                for (CiSEEdge ciseEdge : ciseEdges) {
                    int edgeIndex = -1;
                    if (ciseEdge.getSource().getOwner() == ciseCircle) {
                        edgeIndex = ((CiSENode)ciseEdge.getSource()).getOnCircleNodeExt().getIndex();
                    } else if (ciseEdge.getTarget().getOwner() == ciseCircle) {
                        edgeIndex = ((CiSENode)ciseEdge.getTarget()).getOnCircleNodeExt().getIndex();
                    }
                    assert (edgeIndex != -1);
                    edgeIndices.add(new Integer(edgeIndex));
                }
                IntegerQuickSort intSort = new IntegerQuickSort(edgeIndices);
                intSort.quicksort();
                int indexLargestGapStart = -1;
                int largestGap = -1;
                Iterator indexIter = edgeIndices.iterator();
                Object var20_22 = null;
                Integer firstEdgeIndex = -1;
                int edgeIndexPos = -1;
                while (indexIter.hasNext()) {
                    void prevEdgeIndex = var20_23;
                    Integer n = (Integer)indexIter.next();
                    ++edgeIndexPos;
                    if (prevEdgeIndex != null) {
                        int gap = n - prevEdgeIndex.intValue();
                        assert (gap >= 0);
                        if (gap <= largestGap) continue;
                        largestGap = gap;
                        indexLargestGapStart = edgeIndexPos - 1;
                        continue;
                    }
                    firstEdgeIndex = n;
                }
                if (firstEdgeIndex != -1 && firstEdgeIndex + mod - var20_23.intValue() > largestGap) {
                    largestGap = firstEdgeIndex + mod - var20_23.intValue();
                    indexLargestGapStart = edgeIndexPos;
                    assert (indexLargestGapStart == edgeIndices.size() - 1);
                }
                int edgeCount = edgeIndices.size();
                assert (edgeCount != 0);
                if (largestGap > 0) {
                    for (int k = indexLargestGapStart + 1; k < edgeCount; ++k) {
                        Integer index = (Integer)edgeIndices.get(k);
                        edgeIndices.set(k, index - mod);
                    }
                }
                double totalIndex = 0.0;
                for (Integer n : edgeIndices) {
                    totalIndex += (double)n.intValue();
                }
                double averageIndex = totalIndex / (double)edgeCount;
                if (averageIndex < 0.0) {
                    averageIndex += (double)mod;
                }
                indexMapping.put(coseEdge, averageIndex);
            }
            IndexedObjectSort sort = new IndexedObjectSort(incidentCoseEdges, indexMapping);
            sort.quicksort();
        }
    }

    protected void calcIdealEdgeLengths(boolean isPolishingStep) {
        CiSEEdge edge;
        Object[] lEdges = this.getAllEdges();
        for (int i = 0; i < lEdges.length; ++i) {
            edge = (CiSEEdge)lEdges[i];
            edge.idealLength = isPolishingStep ? 1.5 * this.idealEdgeLength * this.idealInterClusterEdgeLengthCoefficient : this.idealEdgeLength * this.idealInterClusterEdgeLengthCoefficient;
        }
        CiSENode[] lNodes = this.getInCircleNodes();
        for (int i = 0; i < lNodes.length; ++i) {
            CiSENode node = lNodes[i];
            for (Object obj : node.getEdges()) {
                edge = (CiSEEdge)obj;
                edge.idealLength = 16.0;
            }
        }
    }

    double calcIdealEdgeLengthFactor(CiSEEdge edge) {
        CiSECircle trgCluster;
        int trgSize;
        if (edge.isIntraCluster) {
            return 1.5;
        }
        LGraph rootGraph = this.getGraphManager().getRoot();
        CiSECircle srcCluster = (CiSECircle)edge.getSource().getOwner();
        int srcSize = srcCluster == rootGraph ? 1 : srcCluster.getNodes().size();
        int totalSize = srcSize + (trgSize = (trgCluster = (CiSECircle)edge.getTarget().getOwner()) == rootGraph ? 1 : trgCluster.getNodes().size());
        if (totalSize <= 8) {
            return 1.5;
        }
        return 0.12 * (double)totalSize;
    }

    public void doStep3() {
        this.step = 3;
        this.phase = 3;
        this.initSpringEmbedder();
        this.runSpringEmbedder();
    }

    public void doStep4() {
        this.step = 4;
        this.phase = 3;
        this.initSpringEmbedder();
        this.runSpringEmbedder();
    }

    public void doStep5() {
        this.step = 5;
        this.phase = 3;
        this.initSpringEmbedder();
        this.runSpringEmbedder();
    }

    private void runSpringEmbedder() {
        if (this.step == 4) {
            for (int i = 0; i < this.getOnCircleNodes().length; ++i) {
                this.getOnCircleNodes()[i].getOnCircleNodeExt().updateSwappingConditions();
            }
        }
        this.totalDisplacement = 1000.0;
        int iterations = 0;
        do {
            if (++iterations % 100 == 0) {
                boolean notTooEarly;
                boolean bl = notTooEarly = this.step != 4 || iterations > this.maxIterations / 4;
                if (notTooEarly && this.isConverged()) break;
                this.coolingFactor = this.initialCoolingFactor * ((double)(this.maxIterations - iterations) / (double)this.maxIterations);
            }
            this.totalDisplacement = 0.0;
            if (this.step == 3) {
                if (iterations % 25 == 0) {
                    this.checkAndReverseIfReverseIsBetter();
                }
            } else if (this.step == 4) {
                int iterationInPeriod;
                if (iterations % 300 == 0) {
                    this.swappedPairsInLastIteration.clear();
                }
                this.phase = (iterationInPeriod = iterations % 50) >= 45 ? 1 : (iterationInPeriod == 0 ? 2 : 3);
            }
            this.calcSpringForces();
            this.calcRepulsionForces();
            this.calcGravitationalForces();
            this.calcTotalForces();
            this.moveNodes();
            this.animate();
        } while (iterations < this.maxIterations);
        this.totalIterations += iterations;
    }

    @Override
    public void calcSpringForces() {
        Object[] lEdges = this.getAllEdges();
        for (int i = 0; i < lEdges.length; ++i) {
            CiSEEdge edge = (CiSEEdge)lEdges[i];
            CiSENode source = (CiSENode)edge.getSource();
            CiSENode target = (CiSENode)edge.getTarget();
            if (edge.isIntraCluster && source.getOnCircleNodeExt() != null && target.getOnCircleNodeExt() != null) continue;
            this.calcSpringForce(edge, edge.idealLength);
        }
    }

    @Override
    public void calcRepulsionForces() {
        CiSENode[] inCircleNodes;
        CiSENode[] lNodes = this.getNonOnCircleNodes();
        for (int i = 0; i < lNodes.length; ++i) {
            CiSENode nodeA = lNodes[i];
            for (int j = i + 1; j < lNodes.length; ++j) {
                CiSENode nodeB = lNodes[j];
                assert (nodeA.getOnCircleNodeExt() == null);
                assert (nodeB.getOnCircleNodeExt() == null);
                this.calcRepulsionForce(nodeA, nodeB);
            }
        }
        for (CiSENode inCircleNode : inCircleNodes = this.getInCircleNodes()) {
            CiSECircle ownerCircle = (CiSECircle)inCircleNode.getOwner();
            for (Object childNode : ownerCircle.getNodes()) {
                CiSENode childCiSENode = (CiSENode)childNode;
                if (childCiSENode == inCircleNode) continue;
                this.calcRepulsionForce(inCircleNode, childCiSENode);
            }
        }
    }

    @Override
    public void calcGravitationalForces() {
        CiSENode node;
        int i;
        CiSENode[] lNodes;
        if (!this.getGraphManager().getRoot().isConnected()) {
            lNodes = this.getNonOnCircleNodes();
            for (i = 0; i < lNodes.length; ++i) {
                node = lNodes[i];
                this.calcGravitationalForce(node);
            }
        }
        lNodes = this.getInCircleNodes();
        for (i = 0; i < lNodes.length; ++i) {
            node = lNodes[i];
            this.calcGravitationalForce(node);
        }
    }

    public void calcTotalForces() {
        CiSENode node;
        Object[] allNodes = this.getAllNodes();
        for (int i = 0; i < allNodes.length; ++i) {
            node = (CiSENode)allNodes[i];
            node.displacementX = this.coolingFactor * (node.springForceX + node.repulsionForceX + node.gravitationForceX);
            node.displacementY = this.coolingFactor * (node.springForceY + node.repulsionForceY + node.gravitationForceY);
            node.rotationAmount = 0.0;
            node.springForceX = 0.0;
            node.springForceY = 0.0;
            node.repulsionForceX = 0.0;
            node.repulsionForceY = 0.0;
            node.gravitationForceX = 0.0;
            node.gravitationForceY = 0.0;
        }
        CiSENode[] onCircleNodes = this.getOnCircleNodes();
        for (int i = 0; i < onCircleNodes.length; ++i) {
            node = onCircleNodes[i];
            CiSENode parentNode = (CiSENode)node.getOwner().getParent();
            CircularForce values = ((CiSECircle)node.getOwner()).decomposeForce(node);
            if (this.phase == 1) {
                node.getOnCircleNodeExt().addDisplacementForSwap(values.getRotationAmount());
            }
            parentNode.displacementX += values.getDisplacementX();
            parentNode.displacementY += values.getDisplacementY();
            node.displacementX = 0.0;
            node.displacementY = 0.0;
            parentNode.rotationAmount += values.getRotationAmount();
            node.rotationAmount = 0.0;
        }
    }

    @Override
    public void moveNodes() {
        if (this.phase != 2) {
            CiSENode[] nonOnCircleNodes = this.getNonOnCircleNodes();
            for (int i = 0; i < nonOnCircleNodes.length; ++i) {
                assert (nonOnCircleNodes[i].getOnCircleNodeExt() == null);
                nonOnCircleNodes[i].move();
                if (nonOnCircleNodes[i].getChild() == null) continue;
                ((CiSECircle)nonOnCircleNodes[i].getChild()).rotate();
            }
            CiSENode[] inCircleNodes = this.getInCircleNodes();
            for (int i = 0; i < inCircleNodes.length; ++i) {
                CiSENode inCircleNode = inCircleNodes[i];
                assert (inCircleNode.getOnCircleNodeExt() == null);
                inCircleNode.displacementX /= 20.0;
                inCircleNode.displacementY /= 20.0;
                inCircleNode.move();
            }
        } else {
            CiSEOnCircleNodeExt secondNodeExt;
            CiSEOnCircleNodeExt firstNodeExt;
            CiSENode secondNode;
            CiSENode firstNode;
            assert (this.step == 4);
            CiSENode[] ciseOnCircleNodes = this.getOnCircleNodes();
            int size = ciseOnCircleNodes.length;
            TreeSet<CiSEOnCircleNodePair> nonSafePairs = new TreeSet<CiSEOnCircleNodePair>();
            ArrayList<CiSEOnCircleNodePair> safePairs = new ArrayList<CiSEOnCircleNodePair>();
            HashSet<CiSENode> swappedNodes = new HashSet<CiSENode>();
            HashSet<CiSEOnCircleNodePair> swappedPairs = new HashSet<CiSEOnCircleNodePair>();
            for (int i = 0; i < size; ++i) {
                double secondNodeDisp;
                double firstNodeDisp;
                double discrepancy;
                firstNode = ciseOnCircleNodes[i];
                secondNode = firstNode.getOnCircleNodeExt().getNextNode();
                firstNodeExt = firstNode.getOnCircleNodeExt();
                secondNodeExt = secondNode.getOnCircleNodeExt();
                if (!firstNodeExt.canSwapWithNext() || !secondNodeExt.canSwapWithPrev() || (discrepancy = (firstNodeDisp = firstNodeExt.getDisplacementForSwap()) - (secondNodeDisp = secondNodeExt.getDisplacementForSwap())) < 0.0) continue;
                boolean inSameDirection = firstNodeDisp > 0.0 && secondNodeDisp > 0.0 || firstNodeDisp < 0.0 && secondNodeDisp < 0.0;
                CiSEOnCircleNodePair pair = new CiSEOnCircleNodePair(firstNode, secondNode, discrepancy, inSameDirection);
                if (firstNodeDisp == 0.0 || secondNodeDisp == 0.0) {
                    safePairs.add(pair);
                    continue;
                }
                nonSafePairs.add(pair);
            }
            boolean lookForSwap = true;
            while (lookForSwap && nonSafePairs.size() > 0) {
                CiSEOnCircleNodePair nonSafePair = (CiSEOnCircleNodePair)nonSafePairs.last();
                firstNode = nonSafePair.getFirstNode();
                secondNode = nonSafePair.getSecondNode();
                firstNodeExt = firstNode.getOnCircleNodeExt();
                secondNodeExt = secondNode.getOnCircleNodeExt();
                if (this.isSwappedPreviously(nonSafePair)) {
                    nonSafePairs.remove(nonSafePair);
                    swappedPairs.add(nonSafePair);
                    continue;
                }
                int int1 = firstNodeExt.getInterClusterIntersections(secondNodeExt);
                nonSafePair.swap();
                boolean rollback = false;
                int int2 = firstNodeExt.getInterClusterIntersections(secondNodeExt);
                assert (nonSafePair.getDiscrepancy() >= 0.0);
                boolean bl = rollback = int2 > int1;
                if (!rollback && int2 == int1) {
                    boolean bl2 = rollback = nonSafePair.inSameDirection() || nonSafePair.getDiscrepancy() < 6.0;
                }
                if (rollback) {
                    nonSafePair.swap();
                    nonSafePairs.remove(nonSafePair);
                    continue;
                }
                swappedNodes.add(nonSafePair.getFirstNode());
                swappedNodes.add(nonSafePair.getSecondNode());
                swappedPairs.add(nonSafePair);
                lookForSwap = false;
            }
            for (CiSEOnCircleNodePair safePair : safePairs) {
                if (safePair.inSameDirection() || safePair.getDiscrepancy() < 6.0 || swappedNodes.contains(safePair.getFirstNode()) || swappedNodes.contains(safePair.getSecondNode())) continue;
                if (!this.isSwappedPreviously(safePair)) {
                    safePair.swap();
                    swappedNodes.add(safePair.getFirstNode());
                    swappedNodes.add(safePair.getSecondNode());
                }
                swappedPairs.add(safePair);
            }
            this.swappedPairsInLastIteration.clear();
            this.swappedPairsInLastIteration.addAll(swappedPairs);
            for (int i = 0; i < size; ++i) {
                CiSENode node = ciseOnCircleNodes[i];
                node.getOnCircleNodeExt().setDisplacementForSwap(0.0);
                assert (ciseOnCircleNodes[i].rotationAmount == 0.0);
            }
        }
    }

    private boolean isSwappedPreviously(CiSEOnCircleNodePair pair) {
        for (CiSEOnCircleNodePair swappedPair : this.swappedPairsInLastIteration) {
            if ((swappedPair.getFirstNode() != pair.getFirstNode() || swappedPair.getSecondNode() != pair.getSecondNode()) && (swappedPair.getSecondNode() != pair.getFirstNode() || swappedPair.getFirstNode() != pair.getSecondNode())) continue;
            return true;
        }
        return false;
    }

    public void calculateNodesToApplyGravitationTo() {
        CiSEGraphManager gm = (CiSEGraphManager)this.graphManager;
        LGraph root = gm.getRoot();
        assert (gm.getGraphs().get(0) == root);
        root.updateConnected();
        if (!root.isConnected()) {
            gm.setAllNodesToApplyGravitation(gm.getOnCircleNodes());
        } else {
            gm.setAllNodesToApplyGravitation(new LinkedList());
        }
    }

    private void prepareCirclesForReversal() {
        CiSEGraphManager gm = (CiSEGraphManager)this.getGraphManager();
        for (CiSENode node : gm.getRoot().getNodes()) {
            CiSECircle circle = (CiSECircle)node.getChild();
            if (circle == null) continue;
            if (circle.getInterClusterEdges().size() < 2) {
                circle.setMayNotBeReversed();
            }
            circle.computeOrderMatrix();
        }
    }

    private boolean checkAndReverseIfReverseIsBetter() {
        CiSEGraphManager gm = (CiSEGraphManager)this.getGraphManager();
        for (CiSENode node : gm.getRoot().getNodes()) {
            CiSECircle circle = (CiSECircle)node.getChild();
            if (circle == null || !circle.mayBeReversed() || circle.getNodes().size() > 52 || !circle.checkAndReverseIfReverseIsBetter()) continue;
            return true;
        }
        return false;
    }

    private void findAndMoveInnerNodes() {
        if (!this.allowNodesInsideCircle) {
            return;
        }
        for (Object ciseCircleObject : this.getGraphManager().getGraphs()) {
            CiSECircle ciseCircle = (CiSECircle)ciseCircleObject;
            int innerNodeCount = 0;
            if (ciseCircle == this.getGraphManager().getRoot()) continue;
            int maxInnerNodes = (int)((double)ciseCircle.getNodes().size() * this.maxRatioOfNodesInsideCircle);
            CiSENode innerNode = this.findInnerNode(ciseCircle);
            while (innerNode != null && innerNodeCount < maxInnerNodes) {
                this.moveInnerNode(innerNode);
                if (++innerNodeCount >= maxInnerNodes) continue;
                innerNode = this.findInnerNode(ciseCircle);
            }
        }
    }

    private CiSENode findInnerNode(CiSECircle ciseCircle) {
        CiSENode innerNode = null;
        int onCircleNodeCount = ciseCircle.getOnCircleNodes().size();
        ArrayList<Object> sortedNodes = new ArrayList<Object>(ciseCircle.getOnCircleNodes());
        new LNodeDegreeSort(sortedNodes).quicksort();
        for (int i = onCircleNodeCount - 1; i >= 0 && innerNode == null; --i) {
            List<CiSENode> circleSegment;
            CiSENode candidateNode = (CiSENode)sortedNodes.get(i);
            if (candidateNode.getOnCircleNodeExt().getInterClusterEdges().size() != 0 || (circleSegment = this.findMinimalSpanningSegment(candidateNode)).size() == 0) continue;
            boolean connectedToNonImmediate = false;
            block1: for (CiSENode spanningNode : circleSegment) {
                if (connectedToNonImmediate) break;
                for (Object neighborOfSpanningNodeObject : spanningNode.getNeighborsList()) {
                    CiSENode neighborOfSpanningNode = (CiSENode)neighborOfSpanningNodeObject;
                    if (neighborOfSpanningNode == candidateNode || neighborOfSpanningNode.getOwner() != ciseCircle || neighborOfSpanningNode.getOnCircleNodeExt() == null) continue;
                    int spanningIndex = spanningNode.getOnCircleNodeExt().getIndex();
                    int neighborOfSpanningIndex = neighborOfSpanningNode.getOnCircleNodeExt().getIndex();
                    int indexDiff = spanningIndex - neighborOfSpanningIndex;
                    indexDiff += onCircleNodeCount;
                    if ((indexDiff %= onCircleNodeCount) > 1) {
                        indexDiff = neighborOfSpanningIndex - spanningIndex;
                        indexDiff += onCircleNodeCount;
                        indexDiff %= onCircleNodeCount;
                    }
                    if (indexDiff <= 1) continue;
                    connectedToNonImmediate = true;
                    continue block1;
                }
            }
            if (connectedToNonImmediate) continue;
            innerNode = candidateNode;
        }
        return innerNode;
    }

    private void moveInnerNode(CiSENode innerNode) {
        CiSECircle ciseCircle = (CiSECircle)innerNode.getOwner();
        ciseCircle.moveOnCircleNodeInside(innerNode);
        ArrayList<CiSENode> onCircleNodesList = new ArrayList<CiSENode>(Arrays.asList(this.getCiSEGraphManager().getOnCircleNodes()));
        onCircleNodesList.remove(innerNode);
        this.getCiSEGraphManager().setOnCircleNodes(onCircleNodesList.toArray(new CiSENode[0]));
        ArrayList<CiSENode> inCircleNodesList = new ArrayList<CiSENode>(Arrays.asList(this.getCiSEGraphManager().getInCircleNodes()));
        inCircleNodesList.add(innerNode);
        this.getCiSEGraphManager().setInCircleNodes(inCircleNodesList.toArray(new CiSENode[0]));
    }

    private List<CiSENode> findMinimalSpanningSegment(CiSENode node) {
        ArrayList<CiSENode> segment = new ArrayList<CiSENode>();
        ArrayList<Object> orderedNeigbors = new ArrayList<Object>(node.getOnCircleNeighbors());
        if (orderedNeigbors.size() == 0) {
            return segment;
        }
        new CiSENodeSort(orderedNeigbors).quicksort();
        List<CiSENode> orderedNodes = ((CiSECircle)node.getOwner()).getOnCircleNodes();
        CiSENode shortestSegmentStartNode = null;
        CiSENode shortestSegmentEndNode = null;
        int shortestSegmentLength = orderedNodes.size();
        int segmentLength = orderedNodes.size();
        int neighSize = orderedNeigbors.size();
        for (int i = 0; i < neighSize; ++i) {
            int j = (i - 1 + neighSize) % neighSize;
            CiSENode tempSegmentStartNode = (CiSENode)orderedNeigbors.get(i);
            CiSENode tempSegmentEndNode = (CiSENode)orderedNeigbors.get(j);
            int tempSegmentLength = (tempSegmentEndNode.getOnCircleNodeExt().getIndex() - tempSegmentStartNode.getOnCircleNodeExt().getIndex() + segmentLength) % segmentLength + 1;
            if (tempSegmentLength >= shortestSegmentLength) continue;
            shortestSegmentStartNode = tempSegmentStartNode;
            shortestSegmentEndNode = tempSegmentEndNode;
            shortestSegmentLength = tempSegmentLength;
        }
        boolean segmentEndReached = false;
        CiSENode currentNode = shortestSegmentStartNode;
        while (!segmentEndReached) {
            if (currentNode != node) {
                segment.add(currentNode);
            }
            if (currentNode == shortestSegmentEndNode) {
                segmentEndReached = true;
                continue;
            }
            int nextIndex = currentNode.getOnCircleNodeExt().getIndex() + 1;
            if (nextIndex == orderedNodes.size()) {
                nextIndex = 0;
            }
            currentNode = orderedNodes.get(nextIndex);
        }
        return segment;
    }
}

