/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.xml2tab.InteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.MitabInteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.directoryProcessor.InputDirectoryProcessorStrategy;
import psidev.psi.mi.tab.directoryProcessor.PatternBasedFilenameSelection;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2Tab {
    public static final Log log = LogFactory.getLog(Xml2Tab.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    public static final String UNKNOWN = "unknown";
    private static final Pattern XML_EXTENSION = Pattern.compile(".*\\.xml");
    public static final InputDirectoryProcessorStrategy DEFAULT_DIRECTORY_PROCESSOR = new PatternBasedFilenameSelection(true, XML_EXTENSION);
    private PostProcessorStrategy postProcessor;
    private ExpansionStrategy expansionStrategy;
    private InputDirectoryProcessorStrategy directoryProcessorStrategy = DEFAULT_DIRECTORY_PROCESSOR;
    private InteractionConverter<?> interactionConverter;

    public Xml2Tab() {
        this(new MitabInteractionConverter(), null);
    }

    public Xml2Tab(InteractionConverter<?> interactionConverter) {
        this(interactionConverter, null);
    }

    public Xml2Tab(InteractionConverter<?> interactionConverter, PostProcessorStrategy postProcessorStrategy) {
        this.interactionConverter = interactionConverter;
        this.postProcessor = postProcessorStrategy;
    }

    public PostProcessorStrategy getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessorStrategy postProcessor) {
        this.postProcessor = postProcessor;
    }

    public ExpansionStrategy getExpansionStrategy() {
        return this.expansionStrategy;
    }

    public void setExpansionStrategy(ExpansionStrategy expansionStrategy) {
        this.expansionStrategy = expansionStrategy;
    }

    public InputDirectoryProcessorStrategy getDirectoryProcessorStrategy() {
        return this.directoryProcessorStrategy;
    }

    public void setDirectoryProcessorStrategy(InputDirectoryProcessorStrategy directoryProcessorStrategy) {
        this.directoryProcessorStrategy = directoryProcessorStrategy;
    }

    public Collection<BinaryInteraction> convert(File file) throws TabConversionException {
        return this.convert(file, false);
    }

    public Collection<BinaryInteraction> convert(File file, boolean skipPostProcessing) throws TabConversionException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        ArrayList<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        File f2 = null;
        try {
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug("Converting directory: " + file.getAbsolutePath());
                }
                Collection<File> files = null;
                files = this.directoryProcessorStrategy == null ? DEFAULT_DIRECTORY_PROCESSOR.process(file) : this.directoryProcessorStrategy.process(file);
                for (File f2 : files) {
                    if (log.isDebugEnabled()) {
                        log.debug("Converting file: " + f2.getAbsolutePath());
                    }
                    PsimiXmlReader reader = new PsimiXmlReader();
                    EntrySet entrySet = reader.read(f2);
                    interactions.addAll(this.convert(entrySet, true));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Converting file: " + file);
                }
                PsimiXmlReader reader = new PsimiXmlReader();
                EntrySet entrySet = reader.read(file);
                interactions.addAll(this.convert(entrySet, true));
            }
        }
        catch (Exception e) {
            throw new TabConversionException("An error occured during PSIMITAB conversion of " + (f2 == null ? file.getAbsolutePath() : f2.getAbsolutePath()), e);
        }
        return interactions;
    }

    public Collection<BinaryInteraction> convert(Collection<File> inputFiles) throws TabConversionException {
        return this.convert(inputFiles, false);
    }

    public Collection<BinaryInteraction> convert(Collection<File> inputFiles, boolean skipPostProcessing) throws TabConversionException {
        ArrayList<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>(128);
        for (File file : inputFiles) {
            interactions.addAll(this.convert(file));
        }
        return interactions;
    }

    public Collection<BinaryInteraction> convert(EntrySet entrySet) throws TabConversionException {
        return this.convert(entrySet, false);
    }

    public Collection<BinaryInteraction> convert(EntrySet entrySet, boolean skipPostProcessing) throws TabConversionException {
        if (entrySet == null) {
            throw new IllegalArgumentException("You must give a non null entrySet.");
        }
        ArrayList<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        for (Entry entry : entrySet.getEntries()) {
            String sourceName = null;
            String sourceId = null;
            String sourceDb = null;
            if (entry.hasSource()) {
                Source source = entry.getSource();
                if (source.hasNames()) {
                    Names names = source.getNames();
                    sourceName = names.getShortLabel() != null ? names.getShortLabel() : (names.getFullName() != null ? names.getFullName() : UNKNOWN);
                }
                if (source.hasXref()) {
                    DbReference ref;
                    Xref xref2 = source.getXref();
                    Collection<DbReference> refs = XrefUtils.searchByType(xref2, IDENTITY, IDENTITY_REF);
                    Iterator<DbReference> dbReferenceIterator = refs.iterator();
                    while (dbReferenceIterator.hasNext()) {
                        DbReference dbReference = dbReferenceIterator.next();
                        if (dbReference.getDbAc() != null && !dbReference.getDbAc().equals(PSI_MI_REF)) {
                            dbReferenceIterator.remove();
                            continue;
                        }
                        if (dbReference.getDbAc() != null || dbReference.getDb().equals(PSI_MI)) continue;
                        dbReferenceIterator.remove();
                    }
                    if (refs.size() >= 1 && (ref = refs.iterator().next()) != null) {
                        sourceId = ref.getId();
                        sourceDb = ref.getDb();
                    }
                }
            }
            if (sourceId != null && sourceDb != null) {
                this.interactionConverter.addSourceDatabase(new CrossReferenceImpl(sourceDb, sourceId, sourceName));
            } else {
                this.interactionConverter.addSourceDatabase(new CrossReferenceImpl(UNKNOWN, sourceName, sourceName));
            }
            if (log.isDebugEnabled()) {
                log.debug("Interaction count: " + entry.getInteractions().size());
            }
            for (Interaction interaction2 : entry.getInteractions()) {
                if (this.expansionStrategy != null && interaction2.getParticipants().size() != 2) {
                    Collection<Interaction> expandedInteractions = this.expansionStrategy.expand(interaction2);
                    for (Interaction exi : expandedInteractions) {
                        BinaryInteraction binaryInteraction = this.interactionConverter.toMitab(exi);
                        if (binaryInteraction == null) continue;
                        String expansionName = this.expansionStrategy.getName();
                        ArrayList<CrossReference> complexExpansion = new ArrayList<CrossReference>();
                        if (expansionName.equalsIgnoreCase("spoke")) {
                            complexExpansion.add(new CrossReferenceImpl(PSI_MI, "MI:1060", "spoke expansion"));
                        } else if (expansionName.equalsIgnoreCase("matrix")) {
                            complexExpansion.add(new CrossReferenceImpl(PSI_MI, "MI:1061", "matrix expansion"));
                        } else if (expansionName.equalsIgnoreCase("bipartite")) {
                            complexExpansion.add(new CrossReferenceImpl(PSI_MI, "MI:1062", "bipartite expansion"));
                        }
                        binaryInteraction.setComplexExpansion(complexExpansion);
                        ArrayList<Date> creationDate = new ArrayList<Date>();
                        creationDate.add(entry.getSource().getReleaseDate());
                        if (!creationDate.isEmpty()) {
                            binaryInteraction.setCreationDate(creationDate);
                            binaryInteraction.setUpdateDate(creationDate);
                        }
                        interactions.add(binaryInteraction);
                    }
                    continue;
                }
                BinaryInteraction binaryInteraction = this.interactionConverter.toMitab(interaction2);
                if (binaryInteraction == null) continue;
                ArrayList<Date> creationDate = new ArrayList<Date>();
                creationDate.add(entry.getSource().getReleaseDate());
                if (!creationDate.isEmpty()) {
                    binaryInteraction.setCreationDate(creationDate);
                    binaryInteraction.setUpdateDate(creationDate);
                }
                interactions.add(binaryInteraction);
            }
        }
        return interactions;
    }

    public EntrySet convert(Collection<BinaryInteraction> interactions) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        IdentifierGenerator.remove();
    }
}

