/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.EntrySetConverter;
import psidev.psi.mi.xml.dao.inMemory.InMemoryDAOFactory;
import psidev.psi.mi.xml.io.PsimiXmlReader;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml253.jaxb.ObjectFactory;

public class PsimiXmlReader253
implements PsimiXmlReader {
    private static final Log log = LogFactory.getLog(PsimiXmlReader253.class);
    private static final int BUFFER_SIZE = 100000;

    public EntrySet read(String s) throws PsimiXmlReaderException {
        return this.read(new StringReader(s));
    }

    public EntrySet read(File file) throws PsimiXmlReaderException {
        try {
            return this.read(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new PsimiXmlReaderException(e);
        }
    }

    public EntrySet read(InputStream is) throws PsimiXmlReaderException {
        return this.read(new InputStreamReader(is));
    }

    public EntrySet read(URL url) throws PsimiXmlReaderException {
        try {
            return this.read(url.openStream());
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("Problem reading from String");
        }
    }

    public EntrySet read(Reader reader) throws PsimiXmlReaderException {
        BufferedReader bufferedReader = new BufferedReader(reader, 100000);
        psidev.psi.mi.xml253.jaxb.EntrySet jEntrySet = this.unmarshall(bufferedReader);
        return this.convertInMemory(jEntrySet);
    }

    private psidev.psi.mi.xml253.jaxb.EntrySet unmarshall(Reader reader) throws PsimiXmlReaderException {
        if (reader == null) {
            throw new IllegalArgumentException("You must give a non null reader.");
        }
        try {
            Unmarshaller u = this.getUnmarshaller();
            psidev.psi.mi.xml253.jaxb.EntrySet es = (psidev.psi.mi.xml253.jaxb.EntrySet)u.unmarshal(reader);
            return es;
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while unmarshalling data", e);
        }
    }

    private Unmarshaller getUnmarshaller() throws PsimiXmlReaderException {
        try {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXBContext jc = JAXBContext.newInstance(psidev.psi.mi.xml253.jaxb.EntrySet.class.getPackage().getName(), cl);
            return jc.createUnmarshaller();
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while building an unmarshaller", e);
        }
    }

    private EntrySet convertInMemory(psidev.psi.mi.xml253.jaxb.EntrySet jEntrySet) throws PsimiXmlReaderException {
        EntrySetConverter converter = new EntrySetConverter();
        InMemoryDAOFactory dao = new InMemoryDAOFactory();
        converter.setDAOFactory(dao);
        try {
            EntrySet mEntrySet = converter.fromJaxb(jEntrySet);
            return mEntrySet;
        }
        catch (ConverterException e) {
            throw new PsimiXmlReaderException("An error occured while converting the data model", e);
        }
    }
}

