/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.EntrySetConverter;
import psidev.psi.mi.xml.dao.inMemory.InMemoryDAOFactory;
import psidev.psi.mi.xml.io.PsimiXmlReader;
import psidev.psi.mi.xml254.jaxb.EntrySet;
import psidev.psi.mi.xml254.jaxb.ObjectFactory;

public class PsimiXmlReader254
implements PsimiXmlReader {
    public static final Log log = LogFactory.getLog(PsimiXmlReader254.class);
    private static final int BUFFER_SIZE = 100000;

    public psidev.psi.mi.xml.model.EntrySet read(String s) throws PsimiXmlReaderException {
        return this.read(new StringReader(s));
    }

    public psidev.psi.mi.xml.model.EntrySet read(File file) throws PsimiXmlReaderException {
        try {
            return this.read(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new PsimiXmlReaderException(e);
        }
    }

    public psidev.psi.mi.xml.model.EntrySet read(InputStream is) throws PsimiXmlReaderException {
        return this.read(new InputStreamReader(is));
    }

    public psidev.psi.mi.xml.model.EntrySet read(URL url) throws PsimiXmlReaderException {
        try {
            return this.read(new InputStreamReader(url.openStream()));
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("Problem reading from String");
        }
    }

    public psidev.psi.mi.xml.model.EntrySet read(Reader reader) throws PsimiXmlReaderException {
        BufferedReader bufferedReader = new BufferedReader(reader, 100000);
        EntrySet jEntrySet = this.unmarshall(bufferedReader);
        return this.convertInMemory(jEntrySet);
    }

    private EntrySet unmarshall(Reader reader) throws PsimiXmlReaderException {
        if (reader == null) {
            throw new IllegalArgumentException("You must give a non null reader.");
        }
        try {
            Unmarshaller u = this.getUnmarshaller();
            EntrySet es = (EntrySet)u.unmarshal(reader);
            return es;
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while unmarshalling data", e);
        }
    }

    private Unmarshaller getUnmarshaller() throws PsimiXmlReaderException {
        try {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXBContext jc = JAXBContext.newInstance(EntrySet.class.getPackage().getName(), cl);
            return jc.createUnmarshaller();
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while building an unmarshaller", e);
        }
    }

    private psidev.psi.mi.xml.model.EntrySet convertInMemory(EntrySet jEntrySet) throws PsimiXmlReaderException {
        EntrySetConverter converter = new EntrySetConverter();
        InMemoryDAOFactory dao = new InMemoryDAOFactory();
        converter.setDAOFactory(dao);
        try {
            psidev.psi.mi.xml.model.EntrySet mEntrySet = converter.fromJaxb(jEntrySet);
            return mEntrySet;
        }
        catch (ConverterException e) {
            throw new PsimiXmlReaderException("An error occured while converting the data model", e);
        }
    }
}

