/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jena;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Set;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.junit.Test;

public class EquivalenceTest {
    @Test
    public void loadAndCheckForEquivalentPEPs() throws URISyntaxException, IOException {
        JenaIOHandler jenaIOHandler = new JenaIOHandler(null, BioPAXLevel.L2);
        String pathname = File.separator + "biopax_id_557861_mTor_signaling.owl";
        this.readAndCheckEquivalents(pathname, pathname, jenaIOHandler);
    }

    private void readAndCheckEquivalents(String pathname, String s, JenaIOHandler jenaIOHandler) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(s);
        Model level2 = jenaIOHandler.convertFromOWL(in);
        Set bpeSet = level2.getObjects(physicalEntity.class);
        for (physicalEntity pe : bpeSet) {
            Set pepSet = pe.isPHYSICAL_ENTITYof();
            for (physicalEntityParticipant pep : pepSet) {
                for (physicalEntityParticipant pep2 : pepSet) {
                    pep.isInEquivalentState(pep2);
                }
            }
        }
    }
}

