/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jena;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.junit.Test;

public class JenaIOHandlerTest {
    @Test
    public void testL2File() throws Exception {
        long l = System.currentTimeMillis();
        JenaIOHandler jenaIOHandler = new JenaIOHandler(null, BioPAXLevel.L2);
        jenaIOHandler.setConvertingFromLevel1ToLevel2(true);
        jenaIOHandler.treatNilAsNull(true);
        this.readWriteReadTest("biopax_id_557861_mTor_signaling.owl", jenaIOHandler);
        l = System.currentTimeMillis() - l;
        System.out.println(l);
    }

    @Test
    public void testL3File() throws Exception {
        long l = System.currentTimeMillis();
        JenaIOHandler jenaIOHandler = new JenaIOHandler(null, BioPAXLevel.L3);
        jenaIOHandler.setConvertingFromLevel1ToLevel2(true);
        jenaIOHandler.treatNilAsNull(true);
        this.readWriteReadTest("biopax3-short-metabolic-pathway.owl", jenaIOHandler);
        l = System.currentTimeMillis() - l;
        System.out.println(l);
    }

    private void readWriteReadTest(String s, JenaIOHandler jenaIOHandler) throws IllegalAccessException, InvocationTargetException, IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(s);
        Model model = jenaIOHandler.convertFromOWL(in);
        FileOutputStream out = new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "out-" + s);
        jenaIOHandler.convertToOWL(model, (OutputStream)out);
        in.close();
        out.close();
        in = new FileInputStream(new File(this.getClass().getResource("").getFile() + File.separator + "out-" + s));
        Model level21 = jenaIOHandler.convertFromOWL(in);
        assert (model.getObjects().size() == level21.getObjects().size());
        in.close();
    }

    @Test
    public void scratchTest() throws Exception {
        Model model = BioPAXLevel.L2.getDefaultFactory().createModel();
        JenaIOHandler jenaIOHandler = new JenaIOHandler(null, BioPAXLevel.L2);
        FileOutputStream fileOutputStream = new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "scratch.owl");
        jenaIOHandler.convertToOWL(model, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }
}

