/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.InteractionParticipant;
import org.biopax.paxtools.model.level2.bioSource;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalInteraction;
import org.biopax.paxtools.model.level2.sequenceEntity;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceParticipant;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.model.level2.xref;
import org.junit.Assert;
import org.junit.Test;
import org.mskcc.psibiopax.converter.BioPAXMapper;
import org.mskcc.psibiopax.converter.BioPAXMapperImp;
import org.mskcc.psibiopax.converter.BioPAXMarshaller;
import org.mskcc.psibiopax.converter.EntryMapper;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;

public class TestMappingL2
implements BioPAXMarshaller {
    private static final String PSI_MI_TEST_FILE = "10523676-compact.xml";
    private Model bpModel;

    public String getName() {
        return "TestMapping: Tests the proper mapping of a PSI-MI XML file (level 2-compact) to an in memory Paxtools Model";
    }

    @Test
    public void testMapping() {
        try {
            PsimiXmlReader reader = new PsimiXmlReader();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(PSI_MI_TEST_FILE);
            EntrySet es = reader.read(is);
            is.close();
            Collection entries = es.getEntries();
            Assert.assertEquals((long)entries.size(), (long)1L);
            BioPAXMapperImp bpMapper = new BioPAXMapperImp(BioPAXLevel.L2);
            bpMapper.setNamespace("");
            Entry entry = (Entry)entries.iterator().next();
            EntryMapper mapper = new EntryMapper((BioPAXMapper)bpMapper, (BioPAXMarshaller)this, entry, 1970L);
            mapper.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.checkModel();
    }

    private void checkModel() {
        Set biopaxElements = this.bpModel.getObjects();
        Assert.assertEquals((long)135L, (long)biopaxElements.size());
        BioPAXElement bpElement = null;
        for (BioPAXElement biopaxElement : biopaxElements) {
            if (!biopaxElement.getRDFId().equals("3323281832130706316")) continue;
            bpElement = biopaxElement;
            break;
        }
        Assert.assertTrue((bpElement != null ? 1 : 0) != 0);
        physicalInteraction bpInteraction = (physicalInteraction)bpElement;
        Set interactionParticipants = bpInteraction.getPARTICIPANTS();
        Assert.assertEquals((long)2L, (long)interactionParticipants.size());
        sequenceParticipant participant = null;
        for (InteractionParticipant interactionParticipant : interactionParticipants) {
            if (!interactionParticipant.getRDFId().equals("5767007948877890882")) continue;
            participant = (sequenceParticipant)interactionParticipant;
        }
        Assert.assertTrue((participant != null ? 1 : 0) != 0);
        this.checkSequenceFeatures(participant);
        this.checkPhysicalEntity(participant);
    }

    private void checkSequenceFeatures(sequenceParticipant participant) {
        Set sequenceFeatureList = participant.getSEQUENCE_FEATURE_LIST();
        Assert.assertEquals((long)1L, (long)sequenceFeatureList.size());
        boolean featureFound = false;
        sequenceFeature bpSequenceFeature = null;
        for (sequenceFeature sf : sequenceFeatureList) {
            if (!sf.getRDFId().equals("2681741952554656410")) continue;
            featureFound = true;
            bpSequenceFeature = sf;
            break;
        }
        Assert.assertTrue((boolean)featureFound);
        boolean featureTypeFound = false;
        openControlledVocabulary featureType = bpSequenceFeature.getFEATURE_TYPE();
        Set featureTypes = featureType.getTERM();
        for (String ft : featureTypes) {
            if (!ft.equals("ha tagged")) continue;
            featureTypeFound = true;
            break;
        }
        Assert.assertTrue((boolean)featureTypeFound);
        Set featureLocation = bpSequenceFeature.getFEATURE_LOCATION();
        Assert.assertEquals((long)0L, (long)featureLocation.size());
    }

    private void checkPhysicalEntity(sequenceParticipant participant) {
        physicalEntity bpPhysicalEntity = participant.getPHYSICAL_ENTITY();
        Assert.assertEquals((Object)"8", (Object)bpPhysicalEntity.getRDFId());
        Assert.assertEquals((Object)"DNA primase small subunit", (Object)bpPhysicalEntity.getNAME());
        Assert.assertEquals((Object)"pri1_mouse", (Object)bpPhysicalEntity.getSHORT_NAME());
        Set physicalEntityXRefList = bpPhysicalEntity.getXREF();
        Assert.assertEquals((long)4L, (long)physicalEntityXRefList.size());
        xref physicalEntityXRef = null;
        for (xref x : physicalEntityXRefList) {
            if (!(x instanceof unificationXref)) continue;
            physicalEntityXRef = x;
            break;
        }
        if (physicalEntityXRef == null) {
            Assert.fail((String)"no unification xrefs found!");
        }
        Assert.assertEquals((Object)"UXR-P20664", (Object)physicalEntityXRef.getRDFId());
        Assert.assertEquals((Object)"uniprotkb", (Object)physicalEntityXRef.getDB());
        Assert.assertEquals((Object)"P20664", (Object)physicalEntityXRef.getID());
        bioSource bpBioSource = ((sequenceEntity)bpPhysicalEntity).getORGANISM();
        Assert.assertEquals((Object)"Mus musculus", (Object)bpBioSource.getNAME());
        Assert.assertEquals((Object)"BS-10090", (Object)bpBioSource.getRDFId());
        unificationXref bioSourceXRef = bpBioSource.getTAXON_XREF();
        Assert.assertEquals((Object)"8992476572203004810", (Object)bioSourceXRef.getRDFId());
        Assert.assertEquals((Object)"TAXONOMY", (Object)bioSourceXRef.getDB());
        Assert.assertEquals((Object)"10090", (Object)bioSourceXRef.getID());
        Assert.assertEquals((Object)"MEPFDPAELPELLKLYYRRLFPYAQYYRWLNYGGVTKNYFQHREFSFTLKDDIYIRYQSFNNQSELEKEMQKMNPYKIDIGAVYSHRPNQHNTVKLGAFQAQEKELVFDIDMTDYDDVRRCCSSADICSKCWTLMTMAMRIIDRALKEDFGFKHRLWVYSGRRGVHCWVCDESVRKLSSAVRSGIVEYLSLVKGGQDVKKKVHLNEKVHPFVRKSINIIKKYFEEYALVGQDILENKENWDKILALVPETIHDELQRGFQKFHSSPQRWEHLRKVANSSQNMKNDKCGPWLEWEVMLQYCFPRLDVNVSKGVNHLLKSPFSVHPKTGRISVPIDFHKVDQFDPFTVPTISAICRELDMVSTHEKEKEENEADSKHRVRGYKKTSLAPYVKVFEQFLENLDKSRKGELLKKSDLQKDF", (Object)((sequenceEntity)bpPhysicalEntity).getSEQUENCE());
    }

    public void marshallData() {
        throw new UnsupportedOperationException();
    }

    public void addModel(Model bpModel) {
        this.bpModel = bpModel;
    }
}

