/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.junit.Assert;
import org.junit.Test;
import org.mskcc.psibiopax.converter.BioPAXMapper;
import org.mskcc.psibiopax.converter.BioPAXMapperImp;
import org.mskcc.psibiopax.converter.BioPAXMarshaller;
import org.mskcc.psibiopax.converter.EntryMapper;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;

public class TestMappingL3
implements BioPAXMarshaller {
    private static final String PSI_MI_TEST_FILE = "10523676-compact.xml";
    private Model bpModel;

    public String getName() {
        return "TestMapping: Tests the proper mapping of a PSI-MI XML file (level 3-compact) to an in memory Paxtools Model";
    }

    @Test
    public void testMapping() {
        try {
            PsimiXmlReader reader = new PsimiXmlReader();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(PSI_MI_TEST_FILE);
            EntrySet es = reader.read(is);
            is.close();
            Collection entries = es.getEntries();
            Assert.assertEquals((long)entries.size(), (long)1L);
            BioPAXMapperImp bpMapper = new BioPAXMapperImp(BioPAXLevel.L3);
            bpMapper.setNamespace("");
            Entry entry = (Entry)entries.iterator().next();
            EntryMapper mapper = new EntryMapper((BioPAXMapper)bpMapper, (BioPAXMarshaller)this, entry, 1970L);
            mapper.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.checkModel();
    }

    private void checkModel() {
        Set biopaxElements = this.bpModel.getObjects();
        Assert.assertEquals((long)112L, (long)biopaxElements.size());
        BioPAXElement bpElement = null;
        for (BioPAXElement biopaxElement : biopaxElements) {
            if (!biopaxElement.getRDFId().equals("8694781173405777161")) continue;
            bpElement = biopaxElement;
            break;
        }
        Assert.assertTrue((bpElement != null ? 1 : 0) != 0);
        MolecularInteraction bpInteraction = (MolecularInteraction)bpElement;
        Set interactionParticipants = bpInteraction.getParticipant();
        Assert.assertEquals((long)2L, (long)interactionParticipants.size());
        Protein participant = null;
        for (PhysicalEntity interactionParticipant : interactionParticipants) {
            if (!interactionParticipant.getRDFId().equals("8")) continue;
            participant = (Protein)interactionParticipant;
        }
        Assert.assertTrue((participant != null ? 1 : 0) != 0);
        this.checkSequenceFeatures(participant);
        this.checkPhysicalEntity(participant);
    }

    private void checkSequenceFeatures(Protein participant) {
        Set entityFeatureList = participant.getFeature();
        Assert.assertEquals((long)4L, (long)entityFeatureList.size());
        boolean featureFound = false;
        EntityFeature bpEntityFeature = null;
        for (EntityFeature ef : entityFeatureList) {
            if (!ef.getRDFId().equals("2681741952554656410")) continue;
            featureFound = true;
            bpEntityFeature = ef;
            break;
        }
        SequenceLocation sequenceLocation = bpEntityFeature.getFeatureLocation();
        Assert.assertEquals(null, (Object)sequenceLocation);
        boolean featureLocationTypeFound = false;
        SequenceRegionVocabulary featureLocationType = bpEntityFeature.getFeatureLocationType();
        Set featureLocationTypes = featureLocationType.getTerm();
        for (String flt : featureLocationTypes) {
            if (!flt.equals("ha tagged")) continue;
            featureLocationTypeFound = true;
            break;
        }
        Assert.assertTrue((boolean)featureLocationTypeFound);
    }

    private void checkPhysicalEntity(Protein participant) {
        Assert.assertEquals((Object)"8", (Object)participant.getRDFId());
        Assert.assertEquals((Object)"Prim1", participant.getName().iterator().next());
        Set physicalEntityXRefList = participant.getEntityReference().getXref();
        Assert.assertEquals((long)4L, (long)physicalEntityXRefList.size());
        Xref physicalEntityXRef = null;
        for (Xref x : physicalEntityXRefList) {
            if (!(x instanceof UnificationXref)) continue;
            physicalEntityXRef = x;
            break;
        }
        if (physicalEntityXRef == null) {
            Assert.fail((String)"no unification xrefs found!");
        }
        Assert.assertEquals((Object)"UXR-P20664", (Object)physicalEntityXRef.getRDFId());
        Assert.assertEquals((Object)"uniprotkb", (Object)physicalEntityXRef.getDb());
        Assert.assertEquals((Object)"P20664", (Object)physicalEntityXRef.getId());
        ProteinReference proteinReference = (ProteinReference)participant.getEntityReference();
        BioSource bpBioSource = proteinReference.getOrganism();
        Assert.assertEquals((Object)"Mus musculus", bpBioSource.getName().iterator().next());
        Assert.assertEquals((Object)"BS-10090", (Object)bpBioSource.getRDFId());
        Set bioSourceXRef = bpBioSource.getXref();
        Assert.assertEquals((long)1L, (long)bioSourceXRef.size());
        for (Xref unificationXref2 : bioSourceXRef) {
            Assert.assertEquals((Object)"8992476572203004810", (Object)unificationXref2.getRDFId());
            Assert.assertEquals((Object)"TAXONOMY", (Object)unificationXref2.getDb());
            Assert.assertEquals((Object)"10090", (Object)unificationXref2.getId());
        }
        Assert.assertEquals((Object)"MEPFDPAELPELLKLYYRRLFPYAQYYRWLNYGGVTKNYFQHREFSFTLKDDIYIRYQSFNNQSELEKEMQKMNPYKIDIGAVYSHRPNQHNTVKLGAFQAQEKELVFDIDMTDYDDVRRCCSSADICSKCWTLMTMAMRIIDRALKEDFGFKHRLWVYSGRRGVHCWVCDESVRKLSSAVRSGIVEYLSLVKGGQDVKKKVHLNEKVHPFVRKSINIIKKYFEEYALVGQDILENKENWDKILALVPETIHDELQRGFQKFHSSPQRWEHLRKVANSSQNMKNDKCGPWLEWEVMLQYCFPRLDVNVSKGVNHLLKSPFSVHPKTGRISVPIDFHKVDQFDPFTVPTISAICRELDMVSTHEKEKEENEADSKHRVRGYKKTSLAPYVKVFEQFLENLDKSRKGELLKKSDLQKDF", (Object)proteinReference.getSequence());
    }

    public void marshallData() {
        throw new UnsupportedOperationException();
    }

    public void addModel(Model bpModel) {
        this.bpModel = bpModel;
    }
}

