/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.bioSource;
import org.biopax.paxtools.model.level2.confidence;
import org.biopax.paxtools.model.level2.dna;
import org.biopax.paxtools.model.level2.evidence;
import org.biopax.paxtools.model.level2.experimentalForm;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.physicalInteraction;
import org.biopax.paxtools.model.level2.protein;
import org.biopax.paxtools.model.level2.publicationXref;
import org.biopax.paxtools.model.level2.relationshipXref;
import org.biopax.paxtools.model.level2.rna;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceInterval;
import org.biopax.paxtools.model.level2.sequenceParticipant;
import org.biopax.paxtools.model.level2.sequenceSite;
import org.biopax.paxtools.model.level2.smallMolecule;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.ExperimentalForm;
import org.biopax.paxtools.model.level3.ExperimentalFormVocabulary;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.Score;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SequenceInterval;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;

class BioPAXMapper {
    private Model bpModel;
    private BioPAXLevel bpLevel;
    private final String xmlBase;
    private final Random random = new Random(System.currentTimeMillis());
    Set<openControlledVocabulary> vocabularyL2;
    Set<ControlledVocabulary> vocabularyL3;

    public BioPAXMapper(BioPAXLevel bpLevel, String xmlBase) {
        this.bpLevel = bpLevel;
        this.xmlBase = xmlBase;
        if (bpLevel == BioPAXLevel.L2) {
            this.bpModel = BioPAXLevel.L2.getDefaultFactory().createModel();
        } else if (bpLevel == BioPAXLevel.L3) {
            this.bpModel = BioPAXLevel.L3.getDefaultFactory().createModel();
        }
        this.bpModel.setXmlBase(this.xmlBase);
        this.vocabularyL2 = new HashSet<openControlledVocabulary>();
        this.vocabularyL3 = new HashSet<ControlledVocabulary>();
    }

    public Model getModel() {
        return this.bpModel;
    }

    public <T extends BioPAXElement> T addNewUnificationXref(String uri) {
        if (uri == null) {
            uri = this.genUri(UnificationXref.class);
        }
        return (T)(this.bpLevel == BioPAXLevel.L3 ? this.bpModel.addNew(UnificationXref.class, uri) : this.bpModel.addNew(unificationXref.class, uri));
    }

    public <T extends BioPAXElement> T getRelationshipXref(String uri, String refType) {
        if (this.bpLevel == BioPAXLevel.L2) {
            relationshipXref toReturn = (relationshipXref)this.bpModel.addNew(relationshipXref.class, uri);
            if (refType != null) {
                toReturn.setRELATIONSHIP_TYPE(refType);
            }
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            RelationshipXref toReturn = (RelationshipXref)this.bpModel.addNew(RelationshipXref.class, uri);
            if (refType != null) {
                RelationshipTypeVocabulary rtv = (RelationshipTypeVocabulary)this.bpModel.addNew(RelationshipTypeVocabulary.class, this.genUri(RelationshipTypeVocabulary.class));
                rtv.addTerm(refType);
                toReturn.setRelationshipType(rtv);
            }
            return (T)toReturn;
        }
        return null;
    }

    public <T extends BioPAXElement> T getPublicationXref(String id) {
        if (this.bpLevel == BioPAXLevel.L2) {
            return (T)this.bpModel.addNew(publicationXref.class, id);
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            return (T)this.bpModel.addNew(PublicationXref.class, id);
        }
        return null;
    }

    public <T extends BioPAXElement> T getEvidence(Set<? extends BioPAXElement> bpXrefs, Set<? extends BioPAXElement> evidenceCodes, Set<? extends BioPAXElement> scoresOrConfidences, Set<String> comments, Set<? extends BioPAXElement> experimentalForms) {
        if (this.bpLevel == BioPAXLevel.L2) {
            evidence bpEvidence = (evidence)this.bpModel.addNew(evidence.class, this.genUri(evidence.class));
            if (bpXrefs != null && bpXrefs.size() > 0) {
                bpEvidence.setXREF(bpXrefs);
            }
            if (evidenceCodes != null && evidenceCodes.size() > 0) {
                bpEvidence.setEVIDENCE_CODE(evidenceCodes);
            }
            if (scoresOrConfidences != null && scoresOrConfidences.size() > 0) {
                bpEvidence.setCONFIDENCE(scoresOrConfidences);
            }
            if (comments != null && comments.size() > 0) {
                bpEvidence.setCOMMENT(comments);
            }
            if (experimentalForms != null && experimentalForms.size() > 0) {
                bpEvidence.setEXPERIMENTAL_FORM(experimentalForms);
            }
            return (T)bpEvidence;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            Evidence bpEvidence = (Evidence)this.bpModel.addNew(Evidence.class, this.genUri(Evidence.class));
            if (bpXrefs != null) {
                for (BioPAXElement bioPAXElement : bpXrefs) {
                    bpEvidence.addXref((Xref)bioPAXElement);
                }
            }
            if (evidenceCodes != null && evidenceCodes.size() > 0) {
                for (ControlledVocabulary controlledVocabulary : evidenceCodes) {
                    if (this.bpModel.contains((BioPAXElement)controlledVocabulary)) {
                        this.bpModel.remove((BioPAXElement)controlledVocabulary);
                    }
                    EvidenceCodeVocabulary ecv = (EvidenceCodeVocabulary)this.bpModel.addNew(EvidenceCodeVocabulary.class, controlledVocabulary.getRDFId());
                    this.replaceControlledVocabulary(controlledVocabulary, (ControlledVocabulary)ecv);
                    if (bpEvidence.getEvidenceCode().contains(ecv)) continue;
                    bpEvidence.addEvidenceCode(ecv);
                }
            }
            if (scoresOrConfidences != null && scoresOrConfidences.size() > 0) {
                for (BioPAXElement bioPAXElement : scoresOrConfidences) {
                    bpEvidence.addConfidence((Score)bioPAXElement);
                }
            }
            if (comments != null && comments.size() > 0) {
                for (String string : comments) {
                    bpEvidence.addComment(string);
                }
            }
            if (experimentalForms != null && experimentalForms.size() > 0) {
                for (BioPAXElement bioPAXElement : experimentalForms) {
                    bpEvidence.addExperimentalForm((ExperimentalForm)bioPAXElement);
                }
            }
            return (T)bpEvidence;
        }
        return null;
    }

    public <T extends BioPAXElement> T getScoreOrConfidence(String value, Set<? extends BioPAXElement> bpXrefs, Set<String> comments) {
        if (this.bpLevel == BioPAXLevel.L2) {
            confidence bpConfidence = (confidence)this.bpModel.addNew(confidence.class, this.genUri(confidence.class));
            if (value != null) {
                bpConfidence.setCONFIDENCE_VALUE(value);
            }
            if (bpXrefs != null && bpXrefs.size() > 0) {
                bpConfidence.setXREF(bpXrefs);
            }
            if (comments != null && comments.size() > 0) {
                bpConfidence.setCOMMENT(comments);
            }
            return (T)bpConfidence;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            Score bpScore = (Score)this.bpModel.addNew(Score.class, this.genUri(Score.class));
            if (value != null) {
                bpScore.setValue(value);
            }
            if (bpXrefs != null && bpXrefs.size() > 0) {
                for (BioPAXElement bioPAXElement : bpXrefs) {
                    bpScore.addXref((Xref)bioPAXElement);
                }
            }
            if (comments != null && comments.size() > 0) {
                for (String string : comments) {
                    bpScore.addComment(string);
                }
            }
            return (T)bpScore;
        }
        return null;
    }

    public <T extends BioPAXElement> T getExperimentalForm(BioPAXElement formType, BioPAXElement participant) {
        if (this.bpLevel == BioPAXLevel.L2) {
            experimentalForm bpExperimentalForm = (experimentalForm)this.bpModel.addNew(experimentalForm.class, this.genUri(experimentalForm.class));
            if (formType != null) {
                bpExperimentalForm.addEXPERIMENTAL_FORM_TYPE((openControlledVocabulary)formType);
            }
            if (participant != null) {
                bpExperimentalForm.setPARTICIPANT((physicalEntityParticipant)participant);
            }
            return (T)bpExperimentalForm;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            ExperimentalForm bpExperimentalForm = (ExperimentalForm)this.bpModel.addNew(ExperimentalForm.class, this.genUri(ExperimentalForm.class));
            if (formType != null) {
                if (this.bpModel.contains(formType)) {
                    this.bpModel.remove(formType);
                }
                ExperimentalFormVocabulary efv = (ExperimentalFormVocabulary)this.bpModel.addNew(ExperimentalFormVocabulary.class, formType.getRDFId());
                this.replaceControlledVocabulary((ControlledVocabulary)formType, (ControlledVocabulary)efv);
                bpExperimentalForm.addExperimentalFormDescription(efv);
            }
            if (participant != null) {
                bpExperimentalForm.setExperimentalFormEntity((Entity)participant);
            }
            return (T)bpExperimentalForm;
        }
        return null;
    }

    public <T extends BioPAXElement> T getOpenControlledVocabulary(String termToSearch) {
        block5: {
            block4: {
                if (this.bpLevel != BioPAXLevel.L2) break block4;
                for (openControlledVocabulary ocv : this.vocabularyL2) {
                    for (String term : ocv.getTERM()) {
                        if (!term.equals(termToSearch)) continue;
                        return (T)ocv;
                    }
                }
                break block5;
            }
            if (this.bpLevel != BioPAXLevel.L3) break block5;
            for (ControlledVocabulary cv : this.vocabularyL3) {
                for (String term : cv.getTerm()) {
                    if (!term.equals(termToSearch)) continue;
                    return (T)cv;
                }
            }
        }
        return null;
    }

    public <T extends BioPAXElement> T getOpenControlledVocabulary(String term, Set<? extends BioPAXElement> bpXrefs) {
        if (this.bpLevel == BioPAXLevel.L2) {
            openControlledVocabulary toReturn = (openControlledVocabulary)this.bpModel.addNew(openControlledVocabulary.class, this.genUri(openControlledVocabulary.class));
            if (term != null) {
                HashSet<String> terms = new HashSet<String>();
                terms.add(term);
                toReturn.setTERM(terms);
            }
            if (bpXrefs != null && bpXrefs.size() > 0) {
                toReturn.setXREF(bpXrefs);
            }
            this.vocabularyL2.add(toReturn);
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            ControlledVocabulary toReturn = (ControlledVocabulary)this.bpModel.addNew(ControlledVocabulary.class, this.genUri(ControlledVocabulary.class));
            if (term != null) {
                toReturn.addTerm(term);
            }
            if (bpXrefs != null && bpXrefs.size() > 0) {
                for (BioPAXElement bioPAXElement : bpXrefs) {
                    toReturn.addXref((Xref)bioPAXElement);
                }
            }
            this.vocabularyL3.add(toReturn);
            return (T)toReturn;
        }
        return null;
    }

    public <T extends BioPAXElement> T getInteraction(String name, String shortName, Set<String> availability, Set<? extends BioPAXElement> participants, Set<? extends BioPAXElement> bpEvidence) {
        if (this.bpLevel == BioPAXLevel.L2) {
            physicalInteraction toReturn = (physicalInteraction)this.bpModel.addNew(physicalInteraction.class, this.genUri(physicalInteraction.class));
            if (name != null) {
                toReturn.setNAME(name);
            }
            if (shortName != null) {
                toReturn.setSHORT_NAME(shortName);
            }
            if (availability != null && availability.size() > 0) {
                toReturn.setAVAILABILITY(availability);
            }
            if (participants != null && participants.size() > 0) {
                toReturn.setPARTICIPANTS(participants);
            }
            if (bpEvidence != null && bpEvidence.size() > 0) {
                toReturn.setEVIDENCE(bpEvidence);
            }
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            MolecularInteraction toReturn = (MolecularInteraction)this.bpModel.addNew(MolecularInteraction.class, this.genUri(MolecularInteraction.class));
            if (name != null) {
                toReturn.setStandardName(name);
            }
            if (shortName != null) {
                toReturn.setDisplayName(shortName);
            }
            if (availability != null && availability.size() > 0) {
                for (String string : availability) {
                    toReturn.addAvailability(string);
                }
            }
            if (participants != null && participants.size() > 0) {
                for (BioPAXElement bioPAXElement : participants) {
                    toReturn.addParticipant((Entity)bioPAXElement);
                }
            }
            if (bpEvidence != null && bpEvidence.size() > 0) {
                for (BioPAXElement bioPAXElement : bpEvidence) {
                    toReturn.addEvidence((Evidence)bioPAXElement);
                }
            }
            return (T)toReturn;
        }
        return null;
    }

    public <T extends BioPAXElement> T getParticipant(Set<? extends BioPAXElement> features, BioPAXElement cellularLocation, BioPAXElement bpPhysicalEntity) {
        if (this.bpLevel == BioPAXLevel.L2) {
            sequenceParticipant toReturn = (sequenceParticipant)this.bpModel.addNew(sequenceParticipant.class, this.genUri(sequenceParticipant.class));
            if (features != null && features.size() > 0) {
                toReturn.setSEQUENCE_FEATURE_LIST(features);
            }
            if (cellularLocation != null) {
                toReturn.setCELLULAR_LOCATION((openControlledVocabulary)cellularLocation);
            }
            if (bpPhysicalEntity != null) {
                toReturn.setPHYSICAL_ENTITY((physicalEntity)bpPhysicalEntity);
            }
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            if (bpPhysicalEntity != null) {
                if (features != null && features.size() > 0) {
                    for (BioPAXElement bioPAXElement : features) {
                        ((PhysicalEntity)bpPhysicalEntity).addFeature((EntityFeature)bioPAXElement);
                    }
                }
                if (cellularLocation != null && bpPhysicalEntity != null) {
                    if (this.bpModel.contains(cellularLocation)) {
                        this.bpModel.remove(cellularLocation);
                    }
                    CellularLocationVocabulary clv = (CellularLocationVocabulary)this.bpModel.addNew(CellularLocationVocabulary.class, cellularLocation.getRDFId());
                    this.replaceControlledVocabulary((ControlledVocabulary)cellularLocation, (ControlledVocabulary)clv);
                    ((PhysicalEntity)bpPhysicalEntity).setCellularLocation(clv);
                }
            }
            return (T)bpPhysicalEntity;
        }
        return null;
    }

    public <T extends BioPAXElement> T getPhysicalEntity(String physicalEntityType, String name, String shortName, Set<String> synonyms, Set<? extends BioPAXElement> bpXrefs, BioPAXElement bioSource2, String sequence) {
        if (this.bpLevel == BioPAXLevel.L2) {
            physicalEntity toReturn = null;
            if (physicalEntityType != null && physicalEntityType.equalsIgnoreCase("small molecule")) {
                toReturn = (physicalEntity)this.bpModel.addNew(smallMolecule.class, this.genUri(smallMolecule.class));
            } else if (physicalEntityType != null && physicalEntityType.equalsIgnoreCase("dna")) {
                toReturn = (physicalEntity)this.bpModel.addNew(dna.class, this.genUri(dna.class));
            } else if (physicalEntityType != null && physicalEntityType.equalsIgnoreCase("rna")) {
                toReturn = (physicalEntity)this.bpModel.addNew(rna.class, this.genUri(rna.class));
            } else {
                toReturn = (physicalEntity)this.bpModel.addNew(protein.class, this.genUri(protein.class));
                if (bioSource2 != null) {
                    ((protein)toReturn).setORGANISM((bioSource)bioSource2);
                }
                if (sequence != null) {
                    ((protein)toReturn).setSEQUENCE(sequence);
                }
            }
            if (name != null) {
                toReturn.setNAME(name);
            }
            if (shortName != null) {
                toReturn.setSHORT_NAME(shortName);
            }
            for (String synonym : synonyms) {
                toReturn.addSYNONYMS(synonym);
            }
            if (bpXrefs != null && bpXrefs.size() > 0) {
                toReturn.setXREF(bpXrefs);
            }
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            SimplePhysicalEntity toReturn = null;
            EntityReference er = null;
            if (physicalEntityType != null && physicalEntityType.equalsIgnoreCase("small molecule")) {
                toReturn = (SimplePhysicalEntity)this.bpModel.addNew(SmallMolecule.class, this.genUri(SmallMolecule.class));
                er = (EntityReference)this.bpModel.addNew(SmallMoleculeReference.class, this.genUri(SmallMoleculeReference.class));
            } else if (physicalEntityType != null && physicalEntityType.equalsIgnoreCase("dna")) {
                toReturn = (SimplePhysicalEntity)this.bpModel.addNew(Dna.class, this.genUri(Dna.class));
                er = (EntityReference)this.bpModel.addNew(DnaReference.class, this.genUri(DnaReference.class));
            } else if (physicalEntityType != null && physicalEntityType.equalsIgnoreCase("rna")) {
                toReturn = (SimplePhysicalEntity)this.bpModel.addNew(Rna.class, this.genUri(Rna.class));
                er = (EntityReference)this.bpModel.addNew(RnaReference.class, this.genUri(RnaReference.class));
            } else {
                toReturn = (SimplePhysicalEntity)this.bpModel.addNew(Protein.class, this.genUri(Protein.class));
                er = (EntityReference)this.bpModel.addNew(ProteinReference.class, this.genUri(ProteinReference.class));
            }
            if (name != null) {
                er.setStandardName(name);
                toReturn.setStandardName(name);
            }
            if (shortName != null) {
                er.setDisplayName(shortName);
                toReturn.setDisplayName(shortName);
            }
            if (synonyms != null && synonyms.size() > 0) {
                for (String string : synonyms) {
                    er.addName(string);
                    toReturn.addName(string);
                }
            }
            if (bpXrefs != null && bpXrefs.size() > 0) {
                for (BioPAXElement bioPAXElement : bpXrefs) {
                    er.addXref((Xref)bioPAXElement);
                }
            }
            if (er instanceof SequenceEntityReference) {
                SequenceEntityReference ser = (SequenceEntityReference)er;
                ser.setOrganism((BioSource)bioSource2);
                ser.setSequence(sequence);
            }
            toReturn.setEntityReference(er);
            return (T)toReturn;
        }
        return null;
    }

    public <T extends BioPAXElement> T getBioSource(String id, BioPAXElement taxonXref, BioPAXElement cellType, BioPAXElement tissue, String name) {
        if (this.bpLevel == BioPAXLevel.L2) {
            bioSource toReturn = (bioSource)this.bpModel.addNew(bioSource.class, id);
            if (taxonXref != null) {
                toReturn.setTAXON_XREF((unificationXref)taxonXref);
            }
            if (cellType != null) {
                toReturn.setCELLTYPE((openControlledVocabulary)cellType);
            }
            if (tissue != null) {
                toReturn.setTISSUE((openControlledVocabulary)tissue);
            }
            if (name != null) {
                toReturn.setNAME(name);
            }
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            BioSource toReturn = (BioSource)this.bpModel.addNew(BioSource.class, id);
            if (taxonXref != null) {
                toReturn.addXref((Xref)taxonXref);
            }
            if (cellType != null) {
                toReturn.setCellType((CellVocabulary)cellType);
            }
            if (tissue != null) {
                toReturn.setTissue((TissueVocabulary)tissue);
            }
            if (name != null) {
                toReturn.setStandardName(name);
            }
            return (T)toReturn;
        }
        return null;
    }

    private <T extends BioPAXElement> T getFeature(BioPAXElement bpFeature, Set<? extends BioPAXElement> bpXrefs, Set<? extends BioPAXElement> featureLocations, BioPAXElement featureType) {
        if (this.bpLevel == BioPAXLevel.L2) {
            sequenceFeature toReturn = (sequenceFeature)bpFeature;
            if (bpXrefs != null && bpXrefs.size() > 0) {
                for (xref xref2 : bpXrefs) {
                    toReturn.addXREF(xref2);
                }
            }
            if (featureLocations != null) {
                toReturn.setFEATURE_LOCATION(featureLocations);
            }
            if (featureType != null) {
                toReturn.setFEATURE_TYPE((openControlledVocabulary)featureType);
            }
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            EntityFeature toReturn = (EntityFeature)bpFeature;
            if (featureLocations != null) {
                for (BioPAXElement bioPAXElement : featureLocations) {
                    toReturn.setFeatureLocation((SequenceLocation)bioPAXElement);
                }
            }
            if (featureType != null) {
                toReturn.setFeatureLocationType((SequenceRegionVocabulary)featureType);
            }
            return (T)toReturn;
        }
        return null;
    }

    public <T extends BioPAXElement> T getFeature(Set<? extends BioPAXElement> bpXrefs, Set<? extends BioPAXElement> featureLocations, BioPAXElement featureType) {
        sequenceFeature feature;
        BioPAXElement firstXref = null;
        if (bpXrefs != null && !bpXrefs.isEmpty()) {
            firstXref = bpXrefs.iterator().next();
            String id = this.getNamespace() + "SF-" + this.getXrefID(firstXref);
            BioPAXElement bpSequenceFeature = this.bpModel.getByID(id);
            if (bpSequenceFeature != null) {
                return this.getFeature(bpSequenceFeature, bpXrefs, featureLocations, featureType);
            }
        }
        sequenceFeature toReturn = null;
        if (this.bpLevel == BioPAXLevel.L2) {
            if (firstXref != null) {
                String id = this.getNamespace() + "SF-" + this.getXrefID(firstXref);
                feature = (sequenceFeature)this.bpModel.addNew(sequenceFeature.class, id);
                feature.setXREF(bpXrefs);
            } else {
                feature = (sequenceFeature)this.bpModel.addNew(sequenceFeature.class, this.genUri(sequenceFeature.class));
            }
            if (featureLocations != null) {
                feature.setFEATURE_LOCATION(featureLocations);
            }
            if (featureType != null) {
                feature.setFEATURE_TYPE((openControlledVocabulary)featureType);
            }
            toReturn = feature;
        } else if (this.bpLevel == BioPAXLevel.L3) {
            feature = (EntityFeature)this.bpModel.addNew(EntityFeature.class, this.genUri(EntityFeature.class));
            if (featureLocations != null) {
                for (BioPAXElement bioPAXElement : featureLocations) {
                    feature.setFeatureLocation((SequenceLocation)bioPAXElement);
                }
            }
            if (featureType != null) {
                if (this.bpModel.contains(featureType)) {
                    this.bpModel.remove(featureType);
                }
                SequenceRegionVocabulary srv = (SequenceRegionVocabulary)this.bpModel.addNew(SequenceRegionVocabulary.class, featureType.getRDFId());
                this.replaceControlledVocabulary((ControlledVocabulary)featureType, (ControlledVocabulary)srv);
                feature.setFeatureLocationType(srv);
            }
            toReturn = feature;
        }
        return (T)toReturn;
    }

    public <T extends BioPAXElement> T getSequenceLocation(long beginSequenceInterval, long endSequenceInterval) {
        if (this.bpLevel == BioPAXLevel.L2) {
            sequenceInterval toReturn = (sequenceInterval)this.bpModel.addNew(sequenceInterval.class, this.genUri(sequenceInterval.class));
            sequenceSite bpSequenceSiteBegin = (sequenceSite)this.bpModel.addNew(sequenceSite.class, this.genUri(sequenceSite.class));
            bpSequenceSiteBegin.setSEQUENCE_POSITION((int)beginSequenceInterval);
            toReturn.setSEQUENCE_INTERVAL_BEGIN(bpSequenceSiteBegin);
            sequenceSite bpSequenceSiteEnd = (sequenceSite)this.bpModel.addNew(sequenceSite.class, this.genUri(sequenceSite.class));
            bpSequenceSiteEnd.setSEQUENCE_POSITION((int)endSequenceInterval);
            toReturn.setSEQUENCE_INTERVAL_END(bpSequenceSiteEnd);
            return (T)toReturn;
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            SequenceInterval toReturn = (SequenceInterval)this.bpModel.addNew(SequenceInterval.class, this.genUri(SequenceInterval.class));
            SequenceSite bpSequenceSiteBegin = (SequenceSite)this.bpModel.addNew(SequenceSite.class, this.genUri(SequenceSite.class));
            bpSequenceSiteBegin.setSequencePosition((int)beginSequenceInterval);
            toReturn.setSequenceIntervalBegin(bpSequenceSiteBegin);
            SequenceSite bpSequenceSiteEnd = (SequenceSite)this.bpModel.addNew(SequenceSite.class, this.genUri(SequenceSite.class));
            bpSequenceSiteEnd.setSequencePosition((int)endSequenceInterval);
            toReturn.setSequenceIntervalEnd(bpSequenceSiteEnd);
            return (T)toReturn;
        }
        return null;
    }

    public String getXrefID(BioPAXElement bpXref) {
        if (this.bpLevel == BioPAXLevel.L2) {
            return ((xref)bpXref).getID();
        }
        if (this.bpLevel == BioPAXLevel.L3) {
            return ((Xref)bpXref).getId();
        }
        return null;
    }

    public void setXrefDBAndID(BioPAXElement bpXref, String db, String id) {
        if (this.bpLevel == BioPAXLevel.L2) {
            ((xref)bpXref).setDB(db);
            ((xref)bpXref).setID(id);
        } else if (this.bpLevel == BioPAXLevel.L3) {
            ((Xref)bpXref).setDb(db);
            ((Xref)bpXref).setId(id);
        }
    }

    public String getNamespace() {
        return this.xmlBase;
    }

    public <T extends BioPAXElement> void addXrefsToInteraction(T interaction, Set<? extends BioPAXElement> bpXrefs) {
        block3: {
            block2: {
                if (this.bpLevel != BioPAXLevel.L2) break block2;
                for (BioPAXElement bioPAXElement : bpXrefs) {
                    if (!(bioPAXElement instanceof xref)) continue;
                    ((physicalInteraction)interaction).addXREF((xref)bioPAXElement);
                }
                break block3;
            }
            if (this.bpLevel != BioPAXLevel.L3) break block3;
            for (BioPAXElement bioPAXElement : bpXrefs) {
                if (!(bioPAXElement instanceof Xref)) continue;
                ((MolecularInteraction)interaction).addXref((Xref)bioPAXElement);
            }
        }
    }

    public boolean isGeneticInteraction(List<String> geneticInteractionTerms, Set<? extends BioPAXElement> bpEvidence) {
        block8: {
            block7: {
                if (this.bpLevel != BioPAXLevel.L2) break block7;
                if (bpEvidence == null || bpEvidence.size() <= 0) break block8;
                for (evidence evidence2 : bpEvidence) {
                    Set evidenceCodes = evidence2.getEVIDENCE_CODE();
                    if (evidenceCodes == null) continue;
                    for (openControlledVocabulary ocv : evidenceCodes) {
                        Set terms = ocv.getTERM();
                        if (terms == null) continue;
                        for (String term : terms) {
                            if (geneticInteractionTerms == null || !geneticInteractionTerms.contains(term.toLowerCase())) continue;
                            return true;
                        }
                    }
                }
                break block8;
            }
            if (this.bpLevel == BioPAXLevel.L3 && bpEvidence != null && bpEvidence.size() > 0) {
                for (Evidence evidence3 : bpEvidence) {
                    Set evidenceCodes = evidence3.getEvidenceCode();
                    if (evidenceCodes == null) continue;
                    for (EvidenceCodeVocabulary cv : evidenceCodes) {
                        Set terms = cv.getTerm();
                        if (terms == null) continue;
                        for (String term : terms) {
                            if (geneticInteractionTerms == null || !geneticInteractionTerms.contains(term.toLowerCase())) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private void replaceControlledVocabulary(ControlledVocabulary previous, ControlledVocabulary current) {
        for (String term : previous.getTerm()) {
            current.addTerm(term);
        }
        for (Xref xref2 : previous.getXref()) {
            current.addXref(xref2);
        }
        if (this.vocabularyL3.contains(previous)) {
            this.vocabularyL3.remove(previous);
        }
        this.vocabularyL3.add(current);
    }

    private String genUri(Class<? extends BioPAXElement> type) {
        return this.getNamespace() + type.getSimpleName() + Long.toString(this.random.nextLong());
    }
}

