/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.mskcc.psibiopax.converter.PSIMIBioPAXConverter;

class BioPAXMarshaller {
    private PSIMIBioPAXConverter converter;
    private OutputStream outputStream;
    private List<Model> bpModelList;

    public BioPAXMarshaller() {
    }

    public BioPAXMarshaller(PSIMIBioPAXConverter converter, OutputStream outputStream) {
        this.converter = converter;
        this.bpModelList = new ArrayList<Model>();
        this.outputStream = outputStream;
    }

    public void addModel(Model bpModel) {
        this.bpModelList.add(bpModel);
    }

    public void marshallData() {
        Model completeModel = this.converter.getBpLevel().getDefaultFactory().createModel();
        completeModel.setXmlBase(this.converter.getXmlBase());
        for (Model bpModel : this.bpModelList) {
            Set elementList = bpModel.getObjects();
            for (BioPAXElement elementInstance : elementList) {
                completeModel.add(elementInstance);
            }
        }
        SimpleIOHandler io = new SimpleIOHandler();
        io.convertToOWL(completeModel, this.outputStream);
    }
}

