/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.mskcc.psibiopax.converter.BioPAXMapper;
import org.mskcc.psibiopax.converter.BioPAXMarshaller;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Interval;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.OpenCvType;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Range;
import psidev.psi.mi.xml.model.Unit;
import psidev.psi.mi.xml.model.Xref;

class EntryMapper
implements Runnable {
    private static final ArrayList<String> GENETIC_INTERACTIONS = new ArrayList();
    private static final String BIOGRID_EVIDENCE_CODE = "BioGRID Evidence Code";
    private final BioPAXMapper bpMapper;
    private final Entry entry;
    private final BioPAXMarshaller biopaxMarshaller;
    private Map<String, Interactor> interactorMap;
    private Map<Integer, ExperimentDescription> experimentMap;

    public EntryMapper(BioPAXLevel bpLevel, String xmlBase, BioPAXMarshaller biopaxMarshaller, Entry entry) {
        this.entry = entry;
        this.bpMapper = new BioPAXMapper(bpLevel, xmlBase);
        this.biopaxMarshaller = biopaxMarshaller;
    }

    @Override
    public void run() {
        this.interactorMap = this.createInteractorMap(this.entry);
        this.experimentMap = this.createExperimentMap(this.entry);
        String entryDataSourceName = null;
        if (this.entry.hasSource() && this.entry.getSource().hasNames()) {
            entryDataSourceName = this.getName(this.entry.getSource().getNames());
        }
        HashSet<String> availabilitySet = new HashSet<String>();
        if (this.entry.hasAvailabilities()) {
            for (Availability availability : this.entry.getAvailabilities()) {
                if (!availability.hasValue()) continue;
                availabilitySet.add(availability.getValue());
            }
        }
        for (Interaction interaction : this.entry.getInteractions()) {
            this.createInteraction(entryDataSourceName, availabilitySet, interaction);
        }
        this.biopaxMarshaller.addModel(this.bpMapper.getModel());
    }

    private Map<String, Interactor> createInteractorMap(Entry entry) {
        HashMap<String, Interactor> map = new HashMap<String, Interactor>();
        if (entry.getInteractors() != null) {
            for (Interactor interactor : entry.getInteractors()) {
                map.put(Integer.toString(interactor.getId()), interactor);
            }
        }
        return map;
    }

    private Map<Integer, ExperimentDescription> createExperimentMap(Entry entry) {
        HashMap<Integer, ExperimentDescription> map = new HashMap<Integer, ExperimentDescription>();
        if (entry.hasExperiments()) {
            for (ExperimentDescription experimentDescription : entry.getExperiments()) {
                map.put(new Integer(experimentDescription.getId()), experimentDescription);
            }
        }
        return map;
    }

    private void createInteraction(String entryDataSourceName, Set<String> availability, Interaction interaction) {
        Set<BioPAXElement> bpEvidence;
        HashMap<Participant, BioPAXElement> psimiParticipantToBiopaxParticipantMap = new HashMap<Participant, BioPAXElement>();
        if (interaction.hasAttributes()) {
            for (Attribute attribute : interaction.getAttributes()) {
                String value;
                if (!attribute.getName().equalsIgnoreCase(BIOGRID_EVIDENCE_CODE) || !GENETIC_INTERACTIONS.contains(value = attribute.hasValue() ? attribute.getValue().toLowerCase() : "")) continue;
                return;
            }
        }
        if (this.bpMapper.isGeneticInteraction(GENETIC_INTERACTIONS, bpEvidence = this.getExperimentalData(interaction, psimiParticipantToBiopaxParticipantMap))) {
            return;
        }
        String name = null;
        String shortName = null;
        if (interaction.hasNames()) {
            Names names = interaction.getNames();
            name = names.hasFullName() ? names.getFullName() : "";
            shortName = names.hasShortLabel() ? names.getShortLabel() : "";
        }
        HashSet<BioPAXElement> bpParticipants = new HashSet<BioPAXElement>();
        for (Participant participant : interaction.getParticipants()) {
            BioPAXElement bpParticipant = this.createParticipant(participant);
            if (bpParticipant == null) continue;
            bpParticipants.add(bpParticipant);
            psimiParticipantToBiopaxParticipantMap.put(participant, bpParticipant);
        }
        HashSet<BioPAXElement> bpXrefs = new HashSet<BioPAXElement>();
        if (this.entry.hasSource() && this.entry.getSource().hasBibref()) {
            bpXrefs.addAll(this.getPublicationXref(this.entry.getSource().getBibref().getXref()));
        }
        if (interaction.hasXref()) {
            bpXrefs.addAll(this.getXrefs(interaction.getXref(), true));
        }
        Object bpInteraction = this.bpMapper.getInteraction(name, shortName, availability, bpParticipants, bpEvidence);
        this.bpMapper.addXrefsToInteraction(bpInteraction, (Set<? extends BioPAXElement>)bpXrefs);
    }

    private BioPAXElement createParticipant(Participant participant) {
        Set<BioPAXElement> features = this.getFeatureList(participant.getFeatures());
        String interactorRef = "";
        Interactor interactor = null;
        if (participant.hasInteractorRef()) {
            interactorRef = Integer.toString(participant.getInteractorRef().getRef());
            interactor = this.interactorMap.get(interactorRef);
        } else if (participant.hasInteractor()) {
            interactor = participant.getInteractor();
            interactorRef = Integer.toString(interactor.getId());
        }
        if (interactor == null || interactorRef.length() == 0) {
            System.err.println("EntryMapper.createParticipant(): Error - interactor or interactor ref cannot be found");
            System.err.println("participant: " + participant.toString());
            return null;
        }
        BioPAXElement cellularLocation = this.getOpenControlledVocabulary((OpenCvType)(interactor.hasOrganism() && interactor.getOrganism().hasCompartment() ? interactor.getOrganism().getCompartment() : null));
        String physicalEntityRdfId = this.bpMapper.getNamespace() + interactorRef;
        BioPAXElement bpPhysicalEntity = this.bpMapper.getModel().getByID(physicalEntityRdfId);
        bpPhysicalEntity = bpPhysicalEntity == null ? this.createPhysicalEntity(physicalEntityRdfId, interactor) : bpPhysicalEntity;
        return this.bpMapper.getParticipant(features, cellularLocation, bpPhysicalEntity);
    }

    private BioPAXElement createPhysicalEntity(String physicalEntityRdfId, Interactor interactor) {
        String physicalEntityType = null;
        InteractorType interactorType = interactor.getInteractorType();
        if (interactorType != null && interactorType.hasNames()) {
            physicalEntityType = this.getName(interactorType.getNames());
        }
        String name = null;
        String shortName = null;
        HashSet<String> synonyms = new HashSet<String>();
        Names psiNames = interactor.getNames();
        if (psiNames != null) {
            name = psiNames.hasFullName() ? psiNames.getFullName() : null;
            String string = shortName = psiNames.hasShortLabel() ? psiNames.getShortLabel() : null;
            if (psiNames.hasAliases()) {
                for (Alias alias : psiNames.getAliases()) {
                    if (!alias.hasValue()) continue;
                    synonyms.add(alias.getValue());
                }
            }
        }
        return this.bpMapper.getPhysicalEntity(physicalEntityType, name, shortName, synonyms, this.getXrefs(interactor.getXref(), false), this.getBioSource(interactor.getOrganism()), interactor.getSequence());
    }

    private Set<BioPAXElement> getFeatureList(Collection<Feature> psiFeatureList) {
        if (psiFeatureList == null || psiFeatureList.size() == 0) {
            return null;
        }
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        for (Feature psiFeature : psiFeatureList) {
            Set<BioPAXElement> sequenceLocationSet = this.getSequenceLocation(psiFeature.getRanges());
            BioPAXElement bpFeatureType = null;
            if (psiFeature.hasFeatureType()) {
                bpFeatureType = this.getOpenControlledVocabulary((CvType)psiFeature.getFeatureType());
            }
            Xref psiFeatureXref = psiFeature.getXref();
            Set<BioPAXElement> bpSequenceFeatureXref = this.getXrefs(psiFeatureXref, false);
            toReturn.add((BioPAXElement)this.bpMapper.getFeature(bpSequenceFeatureXref, sequenceLocationSet, bpFeatureType));
        }
        return toReturn;
    }

    private Set<BioPAXElement> getSequenceLocation(Collection<Range> rangeList) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        for (Range range : rangeList) {
            Interval endInterval;
            Interval beginInterval = range.hasBeginInterval() ? range.getBeginInterval() : null;
            Interval interval = endInterval = range.hasEndInterval() ? range.getEndInterval() : null;
            if (beginInterval == null) continue;
            toReturn.add((BioPAXElement)this.bpMapper.getSequenceLocation(beginInterval.getBegin(), beginInterval.getEnd()));
            if (endInterval == null) continue;
            toReturn.add((BioPAXElement)this.bpMapper.getSequenceLocation(endInterval.getBegin(), endInterval.getEnd()));
        }
        return toReturn;
    }

    private BioPAXElement getBioSource(Organism organism) {
        if (organism == null) {
            return null;
        }
        String ncbiId = Integer.toString(organism.getNcbiTaxId());
        String bioSourceUri = this.bpMapper.getNamespace() + "BS-" + ncbiId;
        BioPAXElement bpBioSource = this.bpMapper.getModel().getByID(bioSourceUri);
        if (bpBioSource != null) {
            return bpBioSource;
        }
        Object taxonXref = this.bpMapper.addNewUnificationXref(null);
        this.bpMapper.setXrefDBAndID((BioPAXElement)taxonXref, "Taxonomy", ncbiId);
        BioPAXElement cellType = this.getOpenControlledVocabulary((OpenCvType)organism.getCellType());
        BioPAXElement tissue = this.getOpenControlledVocabulary((OpenCvType)organism.getTissue());
        String bioSourceName = null;
        if (organism.hasNames()) {
            bioSourceName = this.getName(organism.getNames());
        }
        return this.bpMapper.getBioSource(bioSourceUri, (BioPAXElement)taxonXref, cellType, tissue, bioSourceName);
    }

    private BioPAXElement getOpenControlledVocabulary(OpenCvType openCvType) {
        if (openCvType == null) {
            return null;
        }
        return this.getOpenControlledVocabulary((CvType)openCvType);
    }

    private BioPAXElement getOpenControlledVocabulary(CvType cvType) {
        if (cvType == null) {
            return null;
        }
        String nameToSearch = null;
        if (cvType.hasNames() && (nameToSearch = this.getName(cvType.getNames())) == null) {
            return null;
        }
        Object toReturn = this.bpMapper.getOpenControlledVocabulary(nameToSearch);
        if (toReturn != null) {
            return toReturn;
        }
        Set<BioPAXElement> bpXrefs = this.getXrefs(cvType.getXref(), true);
        toReturn = this.bpMapper.getOpenControlledVocabulary(nameToSearch, bpXrefs);
        return toReturn;
    }

    private Set<BioPAXElement> getXrefs(Xref psiXREF, boolean forOCVorInteraction) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        if (psiXREF == null) {
            return toReturn;
        }
        ArrayList<DbReference> psiDBRefList = new ArrayList<DbReference>();
        psiDBRefList.add(psiXREF.getPrimaryRef());
        if (psiXREF.hasSecondaryRef()) {
            psiDBRefList.addAll(psiXREF.getSecondaryRef());
        }
        for (DbReference psiDBRef : psiDBRefList) {
            if (psiDBRef == null) continue;
            Object bpXref = null;
            String refType = psiDBRef.hasRefType() ? psiDBRef.getRefType() : null;
            String psiDBRefId = psiDBRef.getId();
            for (String dbRefId : psiDBRefId.split(",")) {
                String id;
                if (refType != null && (refType.equals("identity") || refType.equals("identical object"))) {
                    id = this.bpMapper.getNamespace() + "UXR-" + this.validateDBID(dbRefId);
                    bpXref = this.bpMapper.getModel().getByID(id);
                    if (bpXref != null) {
                        toReturn.add((BioPAXElement)bpXref);
                        continue;
                    }
                    bpXref = this.bpMapper.addNewUnificationXref(id);
                } else if (!forOCVorInteraction) {
                    id = this.bpMapper.getNamespace() + "RXR-" + this.validateDBID(dbRefId);
                    bpXref = this.bpMapper.getModel().getByID(id);
                    if (bpXref != null) {
                        toReturn.add((BioPAXElement)bpXref);
                        continue;
                    }
                    Object object = refType != null ? this.bpMapper.getRelationshipXref(id, refType) : (bpXref = psiDBRef.getDb().toLowerCase().equals("uniprot") ? this.bpMapper.addNewUnificationXref(id) : this.bpMapper.getRelationshipXref(id, null));
                }
                if (bpXref == null) continue;
                this.bpMapper.setXrefDBAndID((BioPAXElement)bpXref, psiDBRef.getDb(), dbRefId);
                toReturn.add((BioPAXElement)bpXref);
            }
        }
        return toReturn;
    }

    private Set<BioPAXElement> getPublicationXref(Xref psiXREF) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        if (psiXREF == null) {
            return toReturn;
        }
        DbReference psiDBRef = psiXREF.getPrimaryRef();
        if (psiDBRef == null) {
            return toReturn;
        }
        String id = this.bpMapper.getNamespace() + "PXR-" + this.validateDBID(psiDBRef.getId());
        Object bpXref = this.bpMapper.getModel().getByID(id);
        if (bpXref != null) {
            toReturn.add((BioPAXElement)bpXref);
            return toReturn;
        }
        bpXref = this.bpMapper.getPublicationXref(id);
        this.bpMapper.setXrefDBAndID((BioPAXElement)bpXref, psiDBRef.getDb(), psiDBRef.getId());
        toReturn.add((BioPAXElement)bpXref);
        return toReturn;
    }

    private String validateDBID(String id) {
        return id.replaceAll("\\$|\\&|\\+|,|/|:|;|=|\\?|@| ", "-");
    }

    private Set<BioPAXElement> getExperimentalData(Interaction interaction, Map<Participant, BioPAXElement> psimiParticipantToBiopaxParticipantMap) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        Collection experimentList = new ArrayList();
        if (interaction.hasExperiments()) {
            experimentList = interaction.getExperiments();
        } else if (interaction.hasExperimentRefs()) {
            experimentList = interaction.getExperimentRefs();
        }
        for (Object o : experimentList) {
            String name;
            ExperimentDescription experimentDescription = interaction.hasExperiments() ? (ExperimentDescription)o : this.experimentMap.get(((ExperimentRef)o).getRef());
            if (experimentDescription == null) continue;
            HashSet<String> comments = new HashSet<String>();
            if (experimentDescription.hasNames() && (name = this.getName(experimentDescription.getNames())) != null) {
                comments.add(name);
            }
            HashSet<BioPAXElement> bpXrefs = new HashSet<BioPAXElement>();
            if (experimentDescription.hasXref()) {
                bpXrefs.addAll(this.getXrefs(experimentDescription.getXref(), false));
            }
            if (experimentDescription.getBibref() != null) {
                bpXrefs.addAll(this.getPublicationXref(experimentDescription.getBibref().getXref()));
            }
            Set<BioPAXElement> evidenceCodes = this.getEvidenceCodes(experimentDescription);
            HashSet<BioPAXElement> scoresOrConfidences = new HashSet<BioPAXElement>();
            if (experimentDescription.hasConfidences()) {
                for (Confidence psiConfidence : experimentDescription.getConfidences()) {
                    BioPAXElement bpScoreOrConfidence = this.getScoreOrConfidence(psiConfidence);
                    if (bpScoreOrConfidence == null) continue;
                    scoresOrConfidences.add(bpScoreOrConfidence);
                }
            }
            if (experimentDescription.hasAttributes()) {
                comments.addAll(this.getAttributes(experimentDescription.getAttributes()));
            }
            Set<BioPAXElement> experimentalForms = this.getExperimentalFormSet(experimentDescription, interaction, psimiParticipantToBiopaxParticipantMap);
            toReturn.add((BioPAXElement)this.bpMapper.getEvidence(bpXrefs, evidenceCodes, scoresOrConfidences, comments, experimentalForms));
        }
        return toReturn;
    }

    private Set<BioPAXElement> getEvidenceCodes(ExperimentDescription experimentDescription) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        HashSet<Object> cvTypeSet = new HashSet<Object>(3);
        cvTypeSet.add(experimentDescription.getInteractionDetectionMethod());
        cvTypeSet.add(experimentDescription.getParticipantIdentificationMethod());
        cvTypeSet.add(experimentDescription.getFeatureDetectionMethod());
        for (CvType cvType : cvTypeSet) {
            BioPAXElement ocv;
            if (cvType == null || (ocv = this.getOpenControlledVocabulary(cvType)) == null) continue;
            toReturn.add(ocv);
        }
        return toReturn;
    }

    private BioPAXElement getScoreOrConfidence(Confidence psiConfidence) {
        String unitName;
        if (psiConfidence == null) {
            return null;
        }
        String value = psiConfidence.getValue();
        Unit ocv = psiConfidence.getUnit();
        HashSet<BioPAXElement> bpXrefs = new HashSet<BioPAXElement>();
        if (ocv != null && ocv.getXref() != null) {
            bpXrefs.addAll(this.getXrefs(ocv.getXref(), false));
        }
        HashSet<String> comments = new HashSet<String>();
        if (ocv != null && ocv.getNames() != null && (unitName = this.getName(ocv.getNames())) != null) {
            comments.add(unitName);
        }
        if (ocv.hasAttributes()) {
            comments.addAll(this.getAttributes(ocv.getAttributes()));
        }
        return this.bpMapper.getScoreOrConfidence(value, bpXrefs, comments);
    }

    private Set<String> getAttributes(Collection<Attribute> attributes) {
        HashSet<String> toReturn = new HashSet<String>();
        for (Attribute attribute : attributes) {
            String name;
            String attributeStr = "";
            if (attribute.hasValue()) {
                attributeStr = attribute.getValue();
            }
            String string = attributeStr = (name = attribute.getName()) != null ? (attributeStr = attributeStr + " " + name) : attributeStr;
            if (attribute.hasNameAc()) {
                attributeStr = attributeStr + " " + attribute.getNameAc();
            }
            if (attributeStr.length() <= 0) continue;
            toReturn.add(attributeStr);
        }
        return toReturn;
    }

    private Set<BioPAXElement> getExperimentalFormSet(ExperimentDescription experimentDescription, Interaction interaction, Map<Participant, BioPAXElement> psimiParticipantToBiopaxParticipantMap) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        HashSet<String> processedRoles = new HashSet<String>();
        for (Participant participant : interaction.getParticipants()) {
            BioPAXElement bpParticipant = psimiParticipantToBiopaxParticipantMap.get(participant.getId());
            if (!participant.hasExperimentalRoles()) continue;
            for (ExperimentalRole experimentalRole : participant.getExperimentalRoles()) {
                String roleName;
                boolean relevantExperimentalRole = false;
                if (!experimentalRole.hasExperimentRefs()) {
                    relevantExperimentalRole = true;
                } else {
                    for (ExperimentRef experimentRef : experimentalRole.getExperimentRefs()) {
                        ExperimentDescription thisExperimentDescription = this.experimentMap.get(experimentRef.getRef());
                        if (thisExperimentDescription != experimentDescription) continue;
                        relevantExperimentalRole = true;
                        break;
                    }
                }
                if (!relevantExperimentalRole || !experimentalRole.hasNames() || processedRoles.contains(roleName = this.getName(experimentalRole.getNames()))) continue;
                toReturn.add((BioPAXElement)this.bpMapper.getExperimentalForm(this.getOpenControlledVocabulary((CvType)experimentalRole), bpParticipant));
                processedRoles.add(roleName);
            }
        }
        return toReturn;
    }

    private String getName(Names name) {
        if (name.hasFullName()) {
            return name.getFullName();
        }
        if (name.hasShortLabel()) {
            return name.getShortLabel();
        }
        return null;
    }

    static {
        GENETIC_INTERACTIONS.add("dosage growth defect");
        GENETIC_INTERACTIONS.add("dosage lethality");
        GENETIC_INTERACTIONS.add("dosage rescue");
        GENETIC_INTERACTIONS.add("negative genetic");
        GENETIC_INTERACTIONS.add("phenotypic enhancement");
        GENETIC_INTERACTIONS.add("phenotypic suppression");
        GENETIC_INTERACTIONS.add("positive genetic");
        GENETIC_INTERACTIONS.add("synthetic growth defect");
        GENETIC_INTERACTIONS.add("synthetic haploinsufficiency");
        GENETIC_INTERACTIONS.add("synthetic lethality");
        GENETIC_INTERACTIONS.add("synthetic rescue");
    }
}

