/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.level3.GroupMap;
import org.biopax.paxtools.io.sif.level3.Grouper;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class GroupConverterTest {
    @Test
    public void testGroups() {
        MockFactory mf = new MockFactory(BioPAXLevel.L3);
        Model model = mf.createModel();
        Protein p1 = (Protein)model.addNew(Protein.class, "p1");
        Protein p2 = (Protein)model.addNew(Protein.class, "p2");
        Protein p3 = (Protein)model.addNew(Protein.class, "p3");
        ProteinReference pr1 = (ProteinReference)model.addNew(ProteinReference.class, "pr1");
        ProteinReference pr2 = (ProteinReference)model.addNew(ProteinReference.class, "pr2");
        p1.setEntityReference((EntityReference)pr1);
        p2.setEntityReference((EntityReference)pr2);
        p3.addMemberPhysicalEntity((PhysicalEntity)p1);
        p3.addMemberPhysicalEntity((PhysicalEntity)p2);
        GroupMap groupMap = Grouper.inferGroups((Model)model);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)(groupMap.getMap().size() == 1 ? 1 : 0)));
    }
}

