/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionSet;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class InteractionSetTest {
    @Test
    public void testMergingAdd() {
        Model model = new MockFactory(BioPAXLevel.L3).createModel();
        ProteinReference p1 = (ProteinReference)model.addNew(ProteinReference.class, "p1");
        ProteinReference p2 = (ProteinReference)model.addNew(ProteinReference.class, "p2");
        MolecularInteraction mi = (MolecularInteraction)model.addNew(MolecularInteraction.class, "mi");
        MolecularInteraction mi2 = (MolecularInteraction)model.addNew(MolecularInteraction.class, "mi2");
        SimpleInteraction si1 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.INTERACTS_WITH);
        SimpleInteraction si2 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.INTERACTS_WITH);
        si1.addMediator((BioPAXElement)mi);
        si2.addMediator((BioPAXElement)mi2);
        Assert.assertThat((Object)si1, (Matcher)CoreMatchers.is((Object)si2));
        InteractionSet ms = new InteractionSet();
        ms.add(si1);
        ms.add(si2);
        junit.framework.Assert.assertTrue((ms.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((si1.getMediators().contains(mi) && si1.getMediators().contains(mi2) ? 1 : 0) != 0);
    }
}

