/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.io.sif.level2.ComponentRule;
import org.biopax.paxtools.io.sif.level2.ControlRule;
import org.biopax.paxtools.io.sif.level2.ParticipatesRule;
import org.biopax.paxtools.io.sif.level3.ConsecutiveCatalysisRule;
import org.biopax.paxtools.io.sif.level3.ControlsTogetherRule;
import org.biopax.paxtools.io.sif.level3.ExpressionRule;
import org.biopax.paxtools.model.Model;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SimpleInteractionConverterTest {
    static BioPAXIOHandler handler = new SimpleIOHandler();
    static final String outFile = SimpleInteractionConverterTest.class.getResource("/").getPath() + "simpleInteractionConverterTest.out" + ".txt";
    PrintStream out = null;

    @Before
    public void setupTest() throws IOException {
        FileOutputStream out1 = new FileOutputStream(outFile, true);
        FileDescriptor fd = out1.getFD();
        System.out.println(outFile);
        this.out = new PrintStream(out1);
    }

    @After
    public void finishTest() throws IOException {
        this.out.flush();
        this.out.close();
    }

    @Test
    public void testWriteInteractionsInSIF() throws Exception {
        File testDir = new File(this.getClass().getResource("/L2").getFile());
        this.out.println("testWriteInteractionsInSIF (L2)");
        for (String s : testDir.list(this.getFilter())) {
            InputStream in = this.getClass().getResourceAsStream("/L2/" + s);
            Model level2 = handler.convertFromOWL(in);
            SimpleInteractionConverter converter = new SimpleInteractionConverter(new InteractionRule[]{new ControlRule(), new ParticipatesRule(), new ComponentRule(), new org.biopax.paxtools.io.sif.level2.ConsecutiveCatalysisRule(), new org.biopax.paxtools.io.sif.level2.ControlsTogetherRule()});
            converter.writeInteractionsInSIF(level2, (OutputStream)this.out);
            in.close();
        }
    }

    public void testWriteInteractionsInSIFNX() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("REDUCE_COMPLEXES", "");
        SimpleInteractionConverter converter = new SimpleInteractionConverter(options, new InteractionRule[]{new ControlRule(), new ParticipatesRule()});
        File testDir = new File(this.getClass().getResource("/L2").getFile());
        this.out.println("testWriteInteractionsInSIFNX (L2) ");
        for (String s : testDir.list(this.getFilter())) {
            InputStream in = this.getClass().getResourceAsStream("/L2/" + s);
            Model level2 = handler.convertFromOWL(in);
            converter.writeInteractionsInSIFNX(level2, (OutputStream)this.out, (OutputStream)this.out, null, Arrays.asList("entity/NAME", "entity/XREF", "entity/ORGANISM"), true);
            in.close();
        }
    }

    @Test
    public void testWriteInteractionsInSIFl3() throws Exception {
        SimpleInteractionConverter converter = this.getDefaultConverter(new HashMap());
        File testDir = new File(this.getClass().getResource("/L3").getFile());
        this.out.println("testWriteInteractionsInSIF (L3)");
        for (String s : testDir.list(this.getFilter())) {
            InputStream in = this.getClass().getResourceAsStream("/L3/" + s);
            Model model = handler.convertFromOWL(in);
            converter.writeInteractionsInSIF(model, (OutputStream)this.out);
            in.close();
        }
    }

    private FilenameFilter getFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".owl");
            }
        };
    }

    @Test
    public void testWriteInteractionsInSIFNXl3() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("REDUCE_COMPLEXES", "");
        SimpleInteractionConverter converter = this.getDefaultConverter(options);
        File testDir = new File(this.getClass().getResource("/L3").getFile());
        for (String s : testDir.list(this.getFilter())) {
            InputStream in = this.getClass().getResourceAsStream("/L3/" + s);
            Model m = handler.convertFromOWL(in);
            converter.writeInteractionsInSIFNX(m, (OutputStream)this.out, (OutputStream)this.out, Arrays.asList("EntityReference/name", "EntityReference/xref"), Arrays.asList("Interaction/dataSource/displayName"), true);
            in.close();
        }
    }

    private SimpleInteractionConverter getDefaultConverter(Map options) {
        return new SimpleInteractionConverter(options, new InteractionRule[]{new org.biopax.paxtools.io.sif.level3.ControlRule(), new org.biopax.paxtools.io.sif.level3.ParticipatesRule(), new org.biopax.paxtools.io.sif.level3.ComponentRule(), new ConsecutiveCatalysisRule(), new ControlsTogetherRule(), new ExpressionRule()});
    }
}

