/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SimpleInteractionTest {
    @Test
    public void testEquals() {
        Model model = new MockFactory(BioPAXLevel.L3).createModel();
        ProteinReference p1 = (ProteinReference)model.addNew(ProteinReference.class, "p1");
        ProteinReference p2 = (ProteinReference)model.addNew(ProteinReference.class, "p2");
        SimpleInteraction si1 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.INTERACTS_WITH);
        SimpleInteraction si2 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.INTERACTS_WITH);
        Assert.assertThat((Object)si1, (Matcher)CoreMatchers.is((Object)si2));
        si1 = new SimpleInteraction((BioPAXElement)p2, (BioPAXElement)p1, BinaryInteractionType.INTERACTS_WITH);
        si2 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.INTERACTS_WITH);
        Assert.assertThat((Object)si1, (Matcher)CoreMatchers.is((Object)si2));
        si1 = new SimpleInteraction((BioPAXElement)p2, (BioPAXElement)p1, BinaryInteractionType.STATE_CHANGE);
        si2 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.STATE_CHANGE);
        Assert.assertThat((Object)si1, (Matcher)CoreMatchers.not((Object)si2));
        si1 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.INTERACTS_WITH);
        si2 = new SimpleInteraction((BioPAXElement)p1, (BioPAXElement)p2, BinaryInteractionType.COMPONENT_OF);
        Assert.assertThat((Object)si1, (Matcher)CoreMatchers.not((Object)si2));
    }
}

