/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.sif.level3.ActivityNetworkAnalyzer;
import org.biopax.paxtools.model.Model;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ActivityNetworkAnalyzerTest {
    static BioPAXIOHandler handler = new SimpleIOHandler();
    static final String outFile = ActivityNetworkAnalyzer.class.getResource("/").getPath() + "PSNAnalyzer.out" + ".txt";
    PrintStream out = null;

    @Before
    public void setupTest() throws IOException {
        FileOutputStream out1 = new FileOutputStream(outFile, true);
        FileDescriptor fd = out1.getFD();
        System.out.println(outFile);
        this.out = new PrintStream(out1);
    }

    @After
    public void finishTest() throws IOException {
        this.out.flush();
        this.out.close();
    }

    @Test
    public void testProteinStateAnalysis() throws Exception {
        File testDir = new File(this.getClass().getResource("/L3").getFile());
        for (String s : testDir.list(this.getFilter())) {
            InputStream in = this.getClass().getResourceAsStream("/L3/" + s);
            Model model = handler.convertFromOWL(in);
            ActivityNetworkAnalyzer analyzer = new ActivityNetworkAnalyzer();
            analyzer.analyzeStates(model);
            analyzer.writeStateNetworkAnalysis((OutputStream)this.out);
            in.close();
        }
    }

    private FilenameFilter getFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".owl");
            }
        };
    }
}

