/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.io.sif.level3.ComponentRule;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ComponentRuleTest {
    @Test
    public void testComponentRule() {
        MockFactory mock = new MockFactory(BioPAXLevel.L3);
        Model model = mock.createModel();
        Protein[] p = (Protein[])mock.create(model, Protein.class, 3);
        ProteinReference[] pr = (ProteinReference[])mock.create(model, ProteinReference.class, 3);
        mock.bindArrays("entityReference", (BioPAXElement[])p, (BioPAXElement[])pr);
        Complex[] cp = (Complex[])mock.create(model, Complex.class, 3);
        mock.bindInPairs("component", new BioPAXElement[]{cp[1], cp[2], cp[1], p[1], cp[1], p[2]});
        HashMap<BinaryInteractionType, Boolean> options = new HashMap<BinaryInteractionType, Boolean>();
        options.put(BinaryInteractionType.IN_SAME_COMPONENT, true);
        options.put(BinaryInteractionType.COMPONENT_OF, true);
        ComponentRule rule = new ComponentRule();
        SimpleInteractionConverter sic = new SimpleInteractionConverter(options, new InteractionRule[]{rule});
        InteractionSetL3 interactions = (InteractionSetL3)sic.inferInteractions(model);
        Map e2g = interactions.getGroupMap().getMap();
        List<SimpleInteraction> expected = Arrays.asList(new SimpleInteraction((BioPAXElement)e2g.get(cp[2]), (BioPAXElement)e2g.get(cp[1]), BinaryInteractionType.COMPONENT_OF), new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)e2g.get(cp[1]), BinaryInteractionType.COMPONENT_OF), new SimpleInteraction((BioPAXElement)pr[2], (BioPAXElement)e2g.get(cp[1]), BinaryInteractionType.COMPONENT_OF), new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)pr[2], BinaryInteractionType.IN_SAME_COMPONENT), new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)e2g.get(cp[2]), BinaryInteractionType.IN_SAME_COMPONENT), new SimpleInteraction((BioPAXElement)pr[2], (BioPAXElement)e2g.get(cp[2]), BinaryInteractionType.IN_SAME_COMPONENT));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)interactions.containsAll(expected)));
    }
}

