/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.io.sif.level3.ConsecutiveCatalysisRule;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.junit.Assert;
import org.junit.Test;

public class ConsecutiveCatalysisRuleTest {
    @Test
    public void testCompzzonentRule() {
        MockFactory mock = new MockFactory(BioPAXLevel.L3);
        Model model = mock.createModel();
        Protein[] p = (Protein[])mock.create(model, Protein.class, 4);
        ProteinReference[] pr = (ProteinReference[])mock.create(model, ProteinReference.class, 4);
        mock.bindArrays(mock.editor("entityReference", Protein.class), (BioPAXElement[])p, (BioPAXElement[])pr);
        SmallMolecule[] sm = (SmallMolecule[])mock.create(model, SmallMolecule.class, 8);
        BiochemicalReaction[] br = (BiochemicalReaction[])mock.create(model, BiochemicalReaction.class, 4);
        br[0].setConversionDirection(ConversionDirectionType.LEFT_TO_RIGHT);
        br[1].setConversionDirection(ConversionDirectionType.LEFT_TO_RIGHT);
        br[2].setConversionDirection(ConversionDirectionType.RIGHT_TO_LEFT);
        br[3].setConversionDirection(ConversionDirectionType.REVERSIBLE);
        mock.bindInPairs(mock.editor("left", BiochemicalReaction.class), new BioPAXElement[]{br[0], sm[0], br[0], sm[1], br[1], sm[3], br[2], sm[4], br[3], sm[6]});
        mock.bindInPairs(mock.editor("right", BiochemicalReaction.class), new BioPAXElement[]{br[0], sm[2], br[0], sm[3], br[1], sm[4], br[1], sm[6], br[2], sm[5], br[3], sm[7]});
        Catalysis[] x = (Catalysis[])mock.create(model, Catalysis.class, 4);
        mock.bindArrays(mock.editor("controlled", Catalysis.class), (BioPAXElement[])x, (BioPAXElement[])br);
        mock.bindArrays(mock.editor("controller", Catalysis.class), (BioPAXElement[])x, (BioPAXElement[])p);
        HashMap options = new HashMap();
        ConsecutiveCatalysisRule rule = new ConsecutiveCatalysisRule();
        SimpleInteractionConverter sic = new SimpleInteractionConverter(options, new InteractionRule[]{rule});
        InteractionSetL3 interactions = (InteractionSetL3)sic.inferInteractions(model);
        List<SimpleInteraction> expected = Arrays.asList(new SimpleInteraction((BioPAXElement)pr[0], (BioPAXElement)pr[1], BinaryInteractionType.SEQUENTIAL_CATALYSIS), new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)pr[3], BinaryInteractionType.SEQUENTIAL_CATALYSIS));
        Assert.assertTrue((boolean)interactions.containsAll(expected));
        Assert.assertEquals((long)2L, (long)interactions.size());
    }
}

