/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.io.sif.level3.ControlRule;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.junit.Test;

public class ControlRuleTest {
    @Test
    public void testControlRule() {
        MockFactory mock = new MockFactory(BioPAXLevel.L3);
        Model model = mock.createModel();
        Protein[] p = (Protein[])mock.create(model, Protein.class, 8);
        ProteinReference[] pr = (ProteinReference[])mock.create(model, ProteinReference.class, 5);
        mock.bindArrays("entityReference", (BioPAXElement[])Arrays.copyOfRange(p, 0, 5), (BioPAXElement[])pr);
        mock.bindInPairs("entityReference", new BioPAXElement[]{p[7], pr[0], p[5], pr[2], p[6], pr[3]});
        SmallMolecule[] sm = (SmallMolecule[])mock.create(model, SmallMolecule.class, 2);
        SmallMoleculeReference[] smr = (SmallMoleculeReference[])mock.create(model, SmallMoleculeReference.class, 2);
        mock.bindArrays("entityReference", (BioPAXElement[])sm, (BioPAXElement[])smr);
        Complex[] c = (Complex[])mock.create(model, Complex.class, 1);
        mock.bindInPairs("component", new BioPAXElement[]{c[0], p[5], c[0], p[6]});
        BiochemicalReaction[] br = (BiochemicalReaction[])mock.create(model, BiochemicalReaction.class, 1);
        ComplexAssembly[] ca = (ComplexAssembly[])mock.create(model, ComplexAssembly.class, 1);
        mock.bindInPairs(mock.editor("left", Conversion.class), new BioPAXElement[]{br[0], p[0], br[0], sm[0], ca[0], p[2], ca[0], p[3]});
        mock.bindInPairs(mock.editor("right", Conversion.class), new BioPAXElement[]{br[0], p[7], br[0], sm[1], ca[0], c[0]});
        Catalysis[] cx = (Catalysis[])mock.create(model, Catalysis.class, 2);
        mock.bindInPairs("controller", new BioPAXElement[]{cx[0], p[1], cx[1], p[4]});
        mock.bindInPairs("controlled", new BioPAXElement[]{cx[0], br[0], cx[1], ca[0]});
        HashMap<BinaryInteractionType, Boolean> options = new HashMap<BinaryInteractionType, Boolean>();
        options.put(BinaryInteractionType.METABOLIC_CATALYSIS, true);
        options.put(BinaryInteractionType.STATE_CHANGE, true);
        ControlRule rule = new ControlRule();
        SimpleInteractionConverter sic = new SimpleInteractionConverter(options, new InteractionRule[]{rule});
        InteractionSetL3 interactions = (InteractionSetL3)sic.inferInteractions(model);
        List<SimpleInteraction> expected = Arrays.asList(new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)pr[0], BinaryInteractionType.STATE_CHANGE), new SimpleInteraction((BioPAXElement)pr[4], (BioPAXElement)pr[2], BinaryInteractionType.STATE_CHANGE), new SimpleInteraction((BioPAXElement)pr[4], (BioPAXElement)pr[3], BinaryInteractionType.STATE_CHANGE), new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)smr[0], BinaryInteractionType.METABOLIC_CATALYSIS), new SimpleInteraction((BioPAXElement)pr[1], (BioPAXElement)smr[1], BinaryInteractionType.METABOLIC_CATALYSIS));
        Assert.assertTrue((boolean)interactions.containsAll(expected));
    }
}

