/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.biopax.paxtools.impl.MockFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.io.sif.level3.ExpressionRule;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;
import org.junit.Test;

public class ExpressionRuleTest {
    @Test
    public void testExpressionRule() {
        MockFactory mock = new MockFactory(BioPAXLevel.L3);
        Model model = mock.createModel();
        Protein[] p = (Protein[])mock.create(model, Protein.class, 4);
        ProteinReference[] pr = (ProteinReference[])mock.create(model, ProteinReference.class, 4);
        mock.bindArrays("entityReference", (BioPAXElement[])p, (BioPAXElement[])pr);
        TemplateReaction[] tr = (TemplateReaction[])mock.create(model, TemplateReaction.class, 2);
        mock.bindInPairs("product", new BioPAXElement[]{tr[0], p[1], tr[1], p[3]});
        TemplateReactionRegulation[] trr = (TemplateReactionRegulation[])mock.create(model, TemplateReactionRegulation.class, 2);
        mock.bindInPairs("controller", new BioPAXElement[]{trr[0], p[0], trr[1], p[2]});
        mock.bindArrays("controlled", (BioPAXElement[])trr, (BioPAXElement[])tr);
        trr[0].setControlType(ControlType.ACTIVATION);
        trr[1].setControlType(ControlType.INHIBITION);
        HashMap<BinaryInteractionType, Boolean> options = new HashMap<BinaryInteractionType, Boolean>();
        options.put(BinaryInteractionType.UPREGULATE_EXPRESSION, true);
        options.put(BinaryInteractionType.DOWNREGULATE_EXPRESSION, true);
        ExpressionRule rule = new ExpressionRule();
        SimpleInteractionConverter sic = new SimpleInteractionConverter(options, new InteractionRule[]{rule});
        InteractionSetL3 interactions = (InteractionSetL3)sic.inferInteractions(model);
        List<SimpleInteraction> expected = Arrays.asList(new SimpleInteraction((BioPAXElement)pr[0], (BioPAXElement)pr[1], BinaryInteractionType.UPREGULATE_EXPRESSION), new SimpleInteraction((BioPAXElement)pr[2], (BioPAXElement)pr[3], BinaryInteractionType.DOWNREGULATE_EXPRESSION));
        Assert.assertTrue((boolean)interactions.containsAll(expected));
    }
}

