/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.ws;

import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.validator.api.Rule;
import org.biopax.validator.api.Validator;
import org.biopax.validator.api.ValidatorUtils;
import org.biopax.validator.api.beans.Behavior;
import org.biopax.validator.api.beans.Category;
import org.biopax.validator.ws.ConfigController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ConfigController {
    static final Log log = LogFactory.getLog(ConfigController.class);
    private Validator validator;
    private ValidatorUtils utils;
    private Properties errorTypes;
    private Set extraDbSynonyms;

    public ConfigController() {
    }

    public ConfigController(Validator validator, ValidatorUtils utils, Properties errorTypes, Set extraDbSynonyms) {
        this.validator = validator;
        this.utils = utils;
        this.errorTypes = errorTypes;
        this.extraDbSynonyms = extraDbSynonyms;
    }

    @ModelAttribute(value="behaviors")
    public Behavior[] ruleBehaviors() {
        return Behavior.values();
    }

    @RequestMapping(value={"/rules"})
    @ModelAttribute(value="rules")
    public Collection<AboutRule> rules() {
        TreeSet<AboutRule> rules = new TreeSet<AboutRule>();
        for (Rule r : this.validator.getRules()) {
            String name = r.getClass().getName();
            rules.add(new AboutRule(name, this.utils.getRuleDescription(name), this.utils.getRuleBehavior(name, null), this.utils.getRuleBehavior(name, "notstrict")));
        }
        return rules;
    }

    @ModelAttribute(value="categories")
    public Category[] errorCategories() {
        return Category.values();
    }

    @RequestMapping(value={"/errorTypes"})
    @ModelAttribute(value="errorTypes")
    public Collection<ErrorCfg> errorTypes() {
        HashMap<String, ErrorCfg> map = new HashMap<String, ErrorCfg>();
        for (Object key : this.errorTypes.keySet()) {
            String code = key.toString();
            if (code.endsWith(".default") || code.endsWith(".category")) continue;
            map.put(code, new ErrorCfg(code));
        }
        for (ErrorCfg cfg : map.values()) {
            cfg.category = this.errorTypes.getProperty(cfg.code + ".category", "N/A (default: information)");
            cfg.defaultMsg = this.errorTypes.getProperty(cfg.code + ".default", "N/A");
            cfg.caseMsgTemplate = this.errorTypes.getProperty(cfg.code, "N/A");
        }
        return new TreeSet<ErrorCfg>(map.values());
    }

    @ModelAttribute(value="extraDbSynonyms")
    public Set extraDbSynonyms() {
        return this.extraDbSynonyms;
    }

    @RequestMapping(value={"/extraCfg"})
    public void extraCfg() {
    }
}

