/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.GraphicalUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.ProgressableInputStream;
import org.bbop.io.SafeFileOutputStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.annotation.datamodel.impl.AnnotationImpl;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NamespacedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.impl.InstancePropertyValue;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.datamodel.impl.SynonymImpl;
import org.obo.util.IDUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOStyleAnnotationFileAdapter
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(GOStyleAnnotationFileAdapter.class);
    protected String path;
    protected AdapterConfiguration config;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected List listeners = new Vector();
    protected OBOFileAdapter.OBOAdapterConfiguration ioprofile;
    protected List streams = new LinkedList();
    protected OBOSession session;
    protected String lastSubjectID;
    protected static int nextEvidenceID = 0;
    protected GraphicalUI advancedUI;
    protected Map<Namespace, String> NamespaceCodeMap = new HashMap<Namespace, String>();
    protected String lastObjectID;

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE doOperation(IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, AdapterConfiguration configuration, INPUT_TYPE o) throws DataAdapterException {
        if (!(configuration instanceof OBOFileAdapter.OBOAdapterConfiguration)) {
            throw new DataAdapterException("Invalid configuration; this adapter requires an OBOAdapterConfiguration object.");
        }
        this.cancelled = false;
        this.ioprofile = (OBOFileAdapter.OBOAdapterConfiguration)configuration;
        if (op.equals(OBOAdapter.READ_ONTOLOGY)) {
            try {
                this.session = new OBOSessionImpl();
                for (String fp : this.ioprofile.getReadPaths()) {
                    LineNumberReader lnr = new LineNumberReader(new FileReader(fp));
                    String line = lnr.readLine();
                    while (line != null) {
                        if (!line.startsWith("!")) {
                            logger.info((Object)("line= " + line));
                            String[] colvals1 = line.split("\t");
                            String[] colvals = new String[16];
                            for (int i = 0; i < colvals1.length; ++i) {
                                colvals[i] = colvals1[i];
                            }
                            this.parseAnnotation(colvals);
                            logger.info((Object)("parsed: " + line));
                        }
                        line = lnr.readLine();
                    }
                    lnr.close();
                }
            }
            catch (Exception e) {
                logger.info((Object)e);
                throw new DataAdapterException((Throwable)e, "read error");
            }
            return (OUTPUT_TYPE)this.session;
        }
        if (op.equals(OBOAdapter.WRITE_ONTOLOGY)) {
            this.session = (OBOSession)o;
            LinkedList<OBOSerializationEngine.FilteredPath> filteredPaths = new LinkedList<OBOSerializationEngine.FilteredPath>();
            if (this.ioprofile.getBasicSave()) {
                filteredPaths.add(new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath()));
            } else {
                logger.info((Object)("gsr=" + this.ioprofile.getSaveRecords()));
                filteredPaths.addAll(this.ioprofile.getSaveRecords());
            }
            this.streams.clear();
            Iterator it = filteredPaths.iterator();
            if (it.hasNext()) {
                OBOSerializationEngine.FilteredPath filteredPath = (OBOSerializationEngine.FilteredPath)it.next();
                try {
                    logger.info((Object)("fp=" + filteredPath));
                    logger.info((Object)("fpp=" + filteredPath.getPath()));
                    SafeFileOutputStream sfos = new SafeFileOutputStream(filteredPath.getPath());
                    this.streams.add(sfos);
                    PrintStream stream = new PrintStream(new BufferedOutputStream((OutputStream)sfos));
                    this.write((OBOSession)o, stream, filteredPath);
                    return (OUTPUT_TYPE)o;
                }
                catch (IOException ex) {
                    throw new DataAdapterException("Bad configuration");
                }
            }
        }
        return null;
    }

    public OBOProperty getEntityToTaxonProperty() {
        LinkedObject lo = this.getSessionLinkedObject("has_taxon", OBOClass.OBO_PROPERTY);
        return TermUtil.castToProperty(lo);
    }

    protected Annotation parseAnnotation(String[] colvals) {
        LinkedObject obj;
        AnnotationImpl ann = new AnnotationImpl(IDUtil.fetchTemporaryID(this.session));
        String dbspace = colvals[0];
        String localID = colvals[1];
        String name = colvals[2];
        String subjectID = dbspace + ":" + localID;
        String qual = colvals[3];
        String objectID = colvals[4];
        String refVal = colvals[5];
        String evCode = colvals[6];
        String ref = colvals[7];
        String aspect = colvals[8];
        String fullName = colvals[9];
        String synVal = colvals[10];
        String type = colvals[11];
        String taxID = colvals[12];
        String date = colvals[13];
        String assignedBy = colvals[14];
        this.session.addObject(ann);
        logger.info((Object)("new ann:" + ann));
        this.parseReferenceField(ann, refVal);
        logger.info((Object)"  parsing ev");
        this.parseEvidence(ann, evCode, ref);
        logger.info((Object)"  parsed ev");
        Namespace subjectNS = this.session.getNamespace(dbspace);
        if (subjectNS == null) {
            subjectNS = this.session.getObjectFactory().createNamespace(dbspace, "");
        }
        ann.setNamespace(subjectNS);
        LinkedObject subj = this.getSessionLinkedObject(subjectID);
        if (subj.getNamespace() == null) {
            subj.setNamespace(subjectNS);
        }
        OBOProperty rel = TermUtil.castToProperty(this.getSessionLinkedObject("OBO_REL:has_role", OBOClass.OBO_PROPERTY));
        ann.setRelationship(rel);
        logger.info((Object)("  setting subj to " + subj));
        ann.setSubject(subj);
        if (subjectID != this.lastSubjectID) {
            this.lastSubjectID = subjectID;
            subj.setName(name);
            this.parseSynonymField(ann, fullName, subj);
            this.parseSynonymField(ann, synVal, subj);
        }
        if ((obj = (LinkedObject)this.session.getObject(objectID)) == null) {
            obj = this.session.getObjectFactory().createDanglingObject(objectID, false);
            this.session.addObject(obj);
        }
        ann.setObject(obj);
        this.parseAspect(ann, aspect);
        if (objectID != this.lastObjectID) {
            this.lastObjectID = objectID;
        }
        this.parseQualifierField(ann, qual);
        this.parseTaxonField(ann, taxID);
        this.parseDateField(ann, date);
        this.parseAssignedByField(ann, assignedBy);
        logger.info((Object)"  done ann");
        return ann;
    }

    protected void parseQualifierField(Annotation ann, String qualField) {
        for (String q : this.splitOn(qualField, "\\|")) {
            if (q.equals("NOT")) {
                ann.setIsNegated(true);
                continue;
            }
            logger.info((Object)("Cannot handle qual:" + q));
        }
    }

    protected void parseAspect(Annotation ann, String aspect) {
        LinkedObject obj = ann.getObject();
        if (obj.getNamespace() != null) {
            return;
        }
        if (aspect == null || aspect.equals("")) {
            return;
        }
        String ns = aspect.equals("C") ? "cellular_component" : (aspect.equals("P") ? "biological_process" : (aspect.equals("F") ? "molecular_function" : aspect));
        Namespace nsObj = this.session.getNamespace(ns);
        if (nsObj == null) {
            nsObj = this.session.getObjectFactory().createNamespace(ns, "");
        }
        if (obj instanceof NamespacedObject) {
            obj.setNamespace(nsObj);
        }
    }

    protected void parseSynonymField(Annotation ann, String synField, LinkedObject ae) {
        for (String s : this.splitOn(synField, "\\|")) {
            SynonymImpl longname = new SynonymImpl(s);
            ((SynonymedObject)((Object)ae)).addSynonym(longname);
        }
    }

    protected void parseReferenceField(Annotation ann, String refField) {
        for (String s : refField.split("\\|")) {
            ann.addSource(s);
        }
    }

    protected void parseDateField(Annotation ann, String dateField) {
    }

    protected void parseAssignedByField(Annotation ann, String abField) {
        ann.setAssignedBy(abField);
    }

    protected void parseEvidence(Annotation ann, String evCode, String withExpr) {
        Pattern p = Pattern.compile("|");
        String[] withVals = p.split(withExpr);
        String evidenceID = "_:ev" + nextEvidenceID;
        ++nextEvidenceID;
        Instance ev = (Instance)this.session.getObjectFactory().createObject(evidenceID, OBOClass.OBO_INSTANCE, true);
        this.session.addObject(ev);
        OBOClass evCodeClass = TermUtil.castToClass(this.getSessionLinkedObject(evCode));
        ev.setType(evCodeClass);
        for (String s : withVals) {
            LinkedObject withObj = (LinkedObject)this.session.getObjectFactory().createObject(s, OBOClass.OBO_INSTANCE, true);
            Object ev2withRel = null;
            this.session.getObjectFactory().createPropertyValue("with", s);
            InstancePropertyValue ev2with = new InstancePropertyValue(ev);
            ev2with.setParent(withObj);
            ev2with.setChild(ev);
        }
        ann.addEvidence(ev);
    }

    protected void parseTaxonField(Annotation ann, String taxVal) {
        Pattern p = Pattern.compile("\\|");
        String[] taxIDs = p.split(taxVal);
        for (int i = 0; i < taxIDs.length; ++i) {
            String taxID = taxIDs[i];
            LinkedObject taxObj = this.getSessionLinkedObject(taxID);
            if (i != 0) continue;
            LinkedObject ae = ann.getSubject();
            OBOProperty subj2taxRel = this.getEntityToTaxonProperty();
            OBORestriction subj2tax = this.session.getObjectFactory().createOBORestriction(ae, subj2taxRel, taxObj, false);
            ae.addParent(subj2tax);
        }
    }

    public LinkedObject getSessionLinkedObject(String id) {
        return this.getSessionLinkedObject(id, OBOClass.OBO_CLASS);
    }

    public LinkedObject getSessionLinkedObject(String id, OBOClass metaclass) {
        logger.info((Object)(this.session + " getting/adding obj:" + id));
        LinkedObject obj = (LinkedObject)this.session.getObject(id);
        if (obj == null) {
            obj = (LinkedObject)this.session.getObjectFactory().createObject(id, metaclass, true);
            logger.info((Object)("  got obj:" + obj));
            this.session.addObject(obj);
        }
        return obj;
    }

    public String getID() {
        return "OBO:GOStyleAnnotation";
    }

    public String getName() {
        return "GO Association File Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{OBOAdapter.READ_ONTOLOGY, OBOAdapter.WRITE_ONTOLOGY};
        return supported;
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI(){
            private static final long serialVersionUID = 8709597443707849569L;

            public AdapterConfiguration createEmptyConfig() {
                return new OBOFileAdapter.OBOAdapterConfiguration();
            }

            public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
                super.acceptComponentConfig(storeonly);
                ((OBOFileAdapter.OBOAdapterConfiguration)this.config).setBasicSave(true);
            }
        };
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        GraphicalUI advancedUI = this.getAdvancedUI();
        if (advancedUI != null) {
            advancedUI.setSimpleUI((GraphicalUI)ui);
            ui.setAdvancedUI(advancedUI);
        }
        return ui;
    }

    public GraphicalUI getAdvancedUI() {
        return this.advancedUI;
    }

    public void setAdvancedUI(GraphicalUI advancedUI) {
        this.advancedUI = advancedUI;
    }

    public OBOSession write(OBOSession session, PrintStream stream, OBOSerializationEngine.FilteredPath filteredPath) throws DataAdapterException {
        try {
            logger.info((Object)("writing to" + stream));
            LinkDatabase ldb = session.getLinkDatabase();
            logger.info((Object)("ldb= " + ldb));
            for (IdentifiedObject io : ldb.getObjects()) {
                if (!(io instanceof Annotation)) continue;
                this.writeAnnotation(stream, (Annotation)io);
            }
            stream.close();
            return session;
        }
        catch (Exception e) {
            throw new DataAdapterException((Throwable)e, "Write error");
        }
    }

    protected void writeAnnotation(PrintStream stream, Annotation annot) throws Exception {
        String[] colvals = new String[16];
        logger.info((Object)("writing annot= " + annot));
        LinkedObject su = annot.getSubject();
        String[] idPartArray = this.splitOn(su.getID(), ":");
        colvals[0] = idPartArray[0];
        StringBuffer sb = new StringBuffer(idPartArray[1]);
        for (int i = 2; i < idPartArray.length; ++i) {
            sb.append(":" + idPartArray[i]);
        }
        colvals[1] = sb.toString();
        LinkedObject ob = annot.getObject();
        colvals[2] = su.getName();
        colvals[3] = "";
        if (annot.getIsNegated()) {
            colvals[3] = "NOT";
        }
        colvals[4] = ob.getID();
        Collection<LinkedObject> sources = annot.getSources();
        colvals[5] = this.flattenSet(sources);
        Collection<LinkedObject> evs = annot.getEvidence();
        if (evs.size() > 1) {
            throw new Exception("can't deal with >1 evidence per annotation yet!");
        }
        colvals[6] = "";
        colvals[7] = "";
        for (LinkedObject ev : evs) {
            colvals[6] = ((Instance)ev).getType().getID();
            colvals[7] = this.flattenSet(ev.getPropertyValues());
            for (PropertyValue pv : ev.getPropertyValues()) {
                colvals[7] = "x";
            }
        }
        colvals[8] = this.getAspect(ob);
        colvals[9] = "";
        colvals[10] = "";
        if (su instanceof SynonymedObject) {
            Set<Synonym> syns = ((SynonymedObject)((Object)su)).getSynonyms();
            LinkedList<String> strs = new LinkedList<String>();
            for (Synonym syn : syns) {
                strs.add(syn.getText());
            }
            colvals[10] = this.flattenSet(strs);
        }
        colvals[11] = "";
        if (su instanceof Instance) {
            colvals[11] = ((Instance)su).getType().getID();
        }
        colvals[12] = "";
        OBOProperty taxRel = this.getEntityToTaxonProperty();
        for (Link link : su.getParents()) {
            if (!link.getType().equals(taxRel)) continue;
            colvals[12] = link.getParent().getID();
        }
        colvals[13] = annot.getModificationDate() == null ? "" : annot.getModificationDate().toString();
        colvals[14] = annot.getAssignedBy() != null ? annot.getAssignedBy().getID() : "";
        colvals[15] = "";
        stream.print(colvals[0]);
        for (int i = 1; i < 16; ++i) {
            stream.print("\t");
            stream.print(colvals[i]);
        }
        stream.print("\n");
        logger.info((Object)(" su+ob " + su + " " + ob));
    }

    protected String flattenSet(Collection set) {
        StringBuffer s = new StringBuffer();
        for (Object o : set) {
            String token = o instanceof IdentifiedObject ? ((IdentifiedObject)o).getID() : (String)o;
            if (s.length() == 0) {
                s.append(token);
                continue;
            }
            s.append("|");
            s.append(token);
        }
        return s.toString();
    }

    protected String getAspect(IdentifiedObject io) {
        Namespace ns = io.getNamespace();
        if (ns == null) {
            return "";
        }
        String nsId = ns.getID();
        if (nsId.equals("cellular_component")) {
            return "C";
        }
        if (nsId.equals("molecular_function")) {
            return "F";
        }
        if (nsId.equals("biological_process")) {
            return "P";
        }
        return nsId;
    }

    public String getTermText(IdentifiedObject term) throws DataAdapterException {
        final StringBuffer buffer = new StringBuffer();
        OutputStream os = new OutputStream(){

            public void write(int b) {
                buffer.append((char)b);
            }
        };
        try {
            ObjectOutputStream stream = new ObjectOutputStream(os);
            stream.writeObject(os);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return buffer.toString();
    }

    public String[] splitOn(String s, String delim) {
        Pattern p = Pattern.compile(delim);
        return p.split(s);
    }

    public String getProgressString() {
        return null;
    }

    public Number getProgressValue() {
        return null;
    }
}

