/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.obo.dataadapter.HistoryDumper;
import org.obo.datamodel.OBOSession;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.StringRelationship;
import org.obo.history.TermMacroHistoryItem;
import org.obo.history.TermMoveHistoryItem;

public class HTMLHistoryDumper
implements HistoryDumper {
    protected static final Logger logger = Logger.getLogger(HTMLHistoryDumper.class);
    private static final int SPACEPADDING = 2;
    protected HistoryList history;
    protected boolean generateLink = true;

    public void setGenerateLink(boolean generateLink) {
        this.generateLink = generateLink;
    }

    public void dumpHistory(PrintStream stream, HistoryList history) throws IOException {
        this.history = history;
        stream.println("<html><body>");
        this.dumpHistory(stream, history.getHistoryItems(), 0);
        stream.println("</body></html>");
    }

    protected void dumpHistory(PrintStream stream, Iterator iterator, int indentLevel) {
        stream.println("<ul>");
        while (iterator.hasNext()) {
            HistoryItem item = (HistoryItem)iterator.next();
            for (int j = 0; j < 2 * indentLevel; ++j) {
                stream.print(" ");
            }
            if (item instanceof TermMacroHistoryItem) {
                stream.println("<ul>");
                this.dumpHistory(stream, (TermMacroHistoryItem)item, indentLevel + 1);
                stream.println("</ul>");
                continue;
            }
            stream.println("<li>" + this.getItemDesc(item, null));
        }
        stream.println("<ul>");
    }

    protected void dumpHistory(PrintStream stream, TermMacroHistoryItem mitem, int indentLevel) {
        for (int i = 0; i < mitem.size(); ++i) {
            HistoryItem item = mitem.getItemAt(i);
            for (int j = 0; j < 2 * indentLevel; ++j) {
                stream.print(" ");
            }
            if (item instanceof TermMacroHistoryItem) {
                stream.println("<ul>");
                this.dumpHistory(stream, (TermMacroHistoryItem)item, indentLevel + 1);
                stream.println("</ul>");
                continue;
            }
            stream.println("<li>" + this.getItemDesc(item, null));
        }
    }

    public String getLinkFromID(OBOSession history, String id) {
        if (this.generateLink) {
            return "<a href='file:" + id + "'>" + id + " (" + id + ")" + "</a>";
        }
        return id;
    }

    public String getItemDesc(HistoryItem item, OBOSession history) {
        if (item instanceof CreateObjectHistoryItem) {
            return "Created object " + this.getLinkFromID(history, ((CreateObjectHistoryItem)item).getObjectID()) + " of type " + ((CreateObjectHistoryItem)item).getObjectType() + ".";
        }
        if (item instanceof CreateLinkHistoryItem) {
            CreateLinkHistoryItem citem = (CreateLinkHistoryItem)item;
            StringBuffer out = new StringBuffer("");
            out.append("Copied ");
            out.append(this.getLinkFromID(history, citem.getTarget()) + " (as " + citem.getTypeID() + "), ");
            out.append(" to ");
            out.append(this.getLinkFromID(history, citem.getParentID()));
            return out.toString();
        }
        if (item instanceof TermMoveHistoryItem) {
            StringBuffer out = new StringBuffer("");
            out.append("Moved ");
            StringRelationship tr = ((TermMoveHistoryItem)item).getRelationship();
            out.append(this.getLinkFromID(history, tr.getChild()) + " (as " + tr.getType() + "), ");
            out.append(" to ");
            out.append(this.getLinkFromID(history, item.getTarget()));
            out.append(" from ");
            out.append(this.getLinkFromID(history, tr.getParent()));
            out.append("</body></html>");
            return out.toString();
        }
        if (item instanceof DeleteLinkHistoryItem) {
            StringBuffer out = new StringBuffer("");
            StringRelationship tr = ((DeleteLinkHistoryItem)item).getRel();
            out.append("Deleted " + this.getLinkFromID(history, tr.getChild()) + " from " + this.getLinkFromID(history, tr.getParent()) + " with " + tr.getType());
            return out.toString();
        }
        return item.toString();
    }
}

