/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.dataadapter.JDBCAdapterConfiguration;
import org.bbop.io.ProgressableInputStream;
import org.bbop.rdbms.WhereClause;
import org.bbop.rdbms.impl.SqlQueryImpl;
import org.bbop.rdbms.impl.SqlWhereClauseImpl;
import org.bbop.util.AbstractProgressValued;
import org.obo.annotation.datamodel.Annotation;
import org.obo.annotation.datamodel.AnnotationOntology;
import org.obo.annotation.datamodel.impl.AnnotationImpl;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.DatatypeValue;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NamespacedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Value;
import org.obo.datamodel.ValueLink;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.datamodel.impl.InstanceImpl;
import org.obo.datamodel.impl.InstancePropertyValue;
import org.obo.datamodel.impl.LinkedAnnotatedObjectImpl;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.datamodel.impl.OBOPropertyImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.util.AnnotationUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBDSQLDatabaseAdapter
extends AbstractProgressValued
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(OBDSQLDatabaseAdapter.class);
    protected String path;
    protected AdapterConfiguration config;
    protected List streams = new LinkedList();
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected OBDSQLDatabaseAdapterConfiguration ioprofile;
    protected ObjectFactory objectFactory = new DefaultObjectFactory();
    protected Map<Connection, HashMap<Integer, IdentifiedObject>> conn2objmap = new HashMap<Connection, HashMap<Integer, IdentifiedObject>>();
    protected Map<Integer, IdentifiedObject> iid2obj = new HashMap<Integer, IdentifiedObject>();
    protected Map<IdentifiedObject, Integer> obj2iid = new HashMap<IdentifiedObject, Integer>();
    Collection<IdentifiedObject> savedObjects = new LinkedList<IdentifiedObject>();
    Map<Link, Integer> link2iid = new HashMap<Link, Integer>();
    LinkDatabase linkDatabase;
    protected Connection connection;
    protected ReasonedLinkDatabase reasoner;

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setReadOperation(WRITE_ONTOLOGY);
        return ui;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE doOperation(IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, AdapterConfiguration configuration, INPUT_TYPE input) throws DataAdapterException {
        if (!(configuration instanceof OBDSQLDatabaseAdapterConfiguration)) {
            throw new DataAdapterException("Invalid configuration; this adapter requires an OBOAdapterConfiguration object.");
        }
        this.cancelled = false;
        this.ioprofile = (OBDSQLDatabaseAdapterConfiguration)configuration;
        if (op.equals((Object)READ_ONTOLOGY)) {
            OBOSession session = this.objectFactory.createSession();
            session.setDefaultNamespace(this.objectFactory.createNamespace("test", "test"));
            try {
                this.connect();
                this.fetchAll(session);
                return (OUTPUT_TYPE)session;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DataAdapterException("SQL error");
            }
        }
        if (op.equals((Object)WRITE_ONTOLOGY)) {
            LinkedList<OBOSerializationEngine.FilteredPath> filteredPaths = new LinkedList<OBOSerializationEngine.FilteredPath>();
            if (this.ioprofile.getBasicSave()) {
                filteredPaths.add(new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath()));
            } else {
                logger.info((Object)("gsr=" + this.ioprofile.getSaveRecords()));
                filteredPaths.addAll(this.ioprofile.getSaveRecords());
            }
            this.streams.clear();
            Iterator it = filteredPaths.iterator();
            OBOSession session = (OBOSession)input;
            if (it.hasNext()) {
                OBOSerializationEngine.FilteredPath filteredPath = (OBOSerializationEngine.FilteredPath)it.next();
                LinkDatabase ldb = session.getLinkDatabase();
                if (filteredPath.saveImplied) {
                    if (this.reasoner == null) {
                        this.reasoner = new ForwardChainingReasoner();
                        this.reasoner.setLinkDatabase(new DefaultLinkDatabase(session));
                        this.reasoner.recache();
                    }
                    ldb = this.reasoner;
                    logger.info((Object)"will save implied");
                }
                logger.info((Object)("ldb=" + ldb));
                try {
                    logger.info((Object)("fp=" + filteredPath));
                    this.ioprofile.setReadPath(filteredPath.getPath());
                    this.connect();
                    logger.info((Object)("conn=" + this.connection));
                    this.storeAll(session, ldb);
                    return (OUTPUT_TYPE)input;
                }
                catch (Exception ex) {
                    logger.info((Object)ex);
                    ex.printStackTrace();
                    throw new DataAdapterException("Bad configuration", (Throwable)ex);
                }
            }
        }
        return null;
    }

    public String getID() {
        return "OBO:OBDSQLDatabaseAdapter";
    }

    public void disconnect() throws SQLException {
        this.connection.close();
    }

    public void connect() throws SQLException, ClassNotFoundException {
        this.connection = this.ioprofile.getConnection();
    }

    public String getName() {
        return "OBD-compliant SQL Database adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{READ_ONTOLOGY, WRITE_ONTOLOGY};
        return supported;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    public void fetchAll(OBOSession session) throws SQLException {
        Statement stmt = this.connection.createStatement();
        SqlQueryImpl nodeQuery = new SqlQueryImpl();
        nodeQuery.addTable("node_with_source");
        WhereClause whereClause = nodeQuery.getWhereClause();
        if (this.ioprofile.getNamespaces().size() > 0) {
            whereClause.addInConstraint("source_uid", this.ioprofile.getNamespaces());
        }
        ResultSet rs = stmt.executeQuery(nodeQuery.toSQL());
        LinkedList<IdentifiedObject> ios = new LinkedList<IdentifiedObject>();
        while (rs.next()) {
            IdentifiedObject io = this.fetchObject(session, rs);
            session.addObject(io);
            ios.add(io);
        }
        for (IdentifiedObject io : ios) {
            this.fetchObjectInfo(session, io);
            this.fetchObjectLinks(session, io);
        }
    }

    public Collection<Annotation> fetchAnnotationsByObject(OBOSession session, LinkedObject obj) throws SQLException {
        SqlQueryImpl q = new SqlQueryImpl();
        q.addTable("node_link_node_with_pred_and_source");
        WhereClause whereClause = q.getWhereClause();
        whereClause.addConstraint("reiflink_node_id IS NOT NULL");
        whereClause.addConstraint("object_id IN (SELECT DISTINCT node_id FROM link_to_node WHERE object_uid ='" + obj.getID() + "')");
        ResultSet rs = q.execute(this.connection);
        OBOSessionImpl tempSession = new OBOSessionImpl();
        while (rs.next()) {
            this.includeLinkResultSetInSession(tempSession, rs);
        }
        return AnnotationUtil.getAnnotations(tempSession);
    }

    public Collection<Link> fetchLinksByObject(String id, String ns) throws SQLException {
        SqlWhereClauseImpl whereClause = new SqlWhereClauseImpl();
        if (ns != null) {
            whereClause.addEqualityConstraint("source_uid", (Object)ns);
        }
        whereClause.addEqualityConstraint("object_uid", (Object)id);
        return this.fetchLinks((WhereClause)whereClause);
    }

    public Collection<Link> fetchLinks(WhereClause whereClause) throws SQLException {
        SqlQueryImpl q = new SqlQueryImpl();
        q.addTable("node_link_node_with_pred_and_source");
        q.setWhereClause(whereClause);
        q.getSelectClause().setDistinct(true);
        ResultSet rs = q.execute(this.connection);
        OBOSessionImpl tempSession = new OBOSessionImpl();
        while (rs.next()) {
            this.includeLinkResultSetInSession(tempSession, rs);
        }
        HashSet<Link> links = new HashSet<Link>();
        for (IdentifiedObject io : tempSession.getObjects()) {
            if (!(io instanceof LinkedObject) || io.isBuiltIn()) continue;
            links.addAll(((LinkedObject)io).getParents());
        }
        return links;
    }

    public Collection<Link> fetchLinksByObject(String id) throws SQLException {
        return this.fetchLinksByObject(id, null);
    }

    public int fetchAnnotationCountByObject(OBOSession session, LinkedObject obj) throws SQLException {
        SqlQueryImpl q = new SqlQueryImpl();
        q.addTable("annotation_count_by_class INNER JOIN node USING (node_id)");
        WhereClause whereClause = q.getWhereClause();
        whereClause.addEqualityConstraint("uid", (Object)obj.getID());
        q.getSelectClause().addColumn("annotation_count");
        ResultSet rs = q.execute(this.connection);
        if (rs.next()) {
            return rs.getInt("annotation_count");
        }
        return 0;
    }

    public float fetchAnnotationInformationContentByObject(OBOSession session, LinkedObject obj) throws SQLException {
        SqlQueryImpl q = new SqlQueryImpl();
        q.addTable("class_node_entropy_by_evidence INNER JOIN node USING (node_id)");
        WhereClause whereClause = q.getWhereClause();
        whereClause.addEqualityConstraint("uid", (Object)obj.getID());
        ResultSet rs = q.execute(this.connection);
        if (rs.next()) {
            return rs.getFloat("shannon_information");
        }
        return 0.0f;
    }

    public Collection<Annotation> retrieveAllAnnotations(OBOSession session) throws SQLException, ClassNotFoundException {
        this.connect();
        SqlQueryImpl q = new SqlQueryImpl();
        q.addTable("obd_prejoins_view.node_link_node_with_pred_and_source");
        WhereClause whereClause = q.getWhereClause();
        whereClause.addConstraint("reiflink_node_id IS NOT NULL");
        PreparedStatement stmt = this.connection.prepareStatement(q.toSQL());
        ResultSet rs = stmt.executeQuery();
        OBOSessionImpl tempSession = new OBOSessionImpl();
        while (rs.next()) {
            this.includeLinkResultSetInSession(tempSession, rs);
        }
        return AnnotationUtil.getAnnotations(tempSession);
    }

    public IdentifiedObject fetchObjectByInternalID(OBOSession session, int iid) throws SQLException {
        SqlQueryImpl nodeQuery = new SqlQueryImpl();
        nodeQuery.addTable("node_with_source");
        WhereClause whereClause = nodeQuery.getWhereClause();
        whereClause.addEqualityConstraint("node_id", (Object)iid);
        ResultSet rs = nodeQuery.execute(this.connection);
        if (rs.next()) {
            return this.fetchObject(session, rs);
        }
        return null;
    }

    public IdentifiedObject fetchObject(OBOSession session, ResultSet rs) throws SQLException {
        String metatype = rs.getString("metatype");
        if (metatype == null) {
            metatype = "";
        }
        Integer iid = rs.getInt("node_id");
        String id = rs.getString("uid");
        LinkedAnnotatedObjectImpl io = metatype.equals("C") ? new OBOClassImpl(id) : (metatype.equals("R") ? new OBOPropertyImpl(id) : new InstanceImpl(id));
        io.setName(rs.getString("label"));
        String nsId = rs.getString("source_uid");
        if (!rs.wasNull()) {
            Namespace ns = session.getNamespace(nsId);
            if (ns == null) {
                ns = this.objectFactory.createNamespace(nsId, nsId);
                session.addNamespace(ns);
            }
            io.setNamespace(ns);
        }
        this.iid2obj.put(iid, io);
        this.obj2iid.put(io, iid);
        return io;
    }

    public void fetchObjectInfo(OBOSession session, IdentifiedObject obj) throws SQLException {
        this.fetchObjectDescription(session, obj);
        this.fetchObjectAliases(session, obj);
    }

    public void fetchObjectDescription(OBOSession session, IdentifiedObject obj) throws SQLException {
        SqlQueryImpl descriptionQuery = new SqlQueryImpl();
        descriptionQuery.addTable("description_d");
        WhereClause whereClause = descriptionQuery.getWhereClause();
        whereClause.addEqualityConstraint("node_uid", (Object)obj.getID());
        PreparedStatement stmt = this.connection.prepareStatement(descriptionQuery.toSQL());
        int i = 1;
        for (Object v : descriptionQuery.getPlaceHolderVals()) {
            stmt.setString(i, (String)v);
            ++i;
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            this.attachDescription(session, rs);
        }
    }

    public void fetchObjectAliases(OBOSession session, IdentifiedObject obj) throws SQLException {
        SqlQueryImpl aliasQuery = new SqlQueryImpl();
        aliasQuery.addTable("alias_d");
        WhereClause whereClause = aliasQuery.getWhereClause();
        whereClause.addEqualityConstraint("node_uid", (Object)obj.getID());
        PreparedStatement stmt = this.connection.prepareStatement(aliasQuery.toSQL());
        int i = 1;
        for (Object v : aliasQuery.getPlaceHolderVals()) {
            stmt.setString(i, (String)v);
            ++i;
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            this.attachAlias(session, rs);
        }
    }

    public void fetchObjectLinks(OBOSession session, IdentifiedObject obj) throws SQLException {
        SqlQueryImpl q = new SqlQueryImpl();
        q.addTable("node_link_node_with_pred_and_source");
        WhereClause whereClause = q.getWhereClause();
        whereClause.addEqualityConstraint("is_inferred", (Object)false);
        whereClause.addEqualityConstraint("node_uid", (Object)obj.getID());
        PreparedStatement stmt = this.connection.prepareStatement(q.toSQL());
        int i = 1;
        for (Object v : q.getPlaceHolderVals()) {
            if (v instanceof String) {
                stmt.setString(i, (String)v);
            } else if (v instanceof Boolean) {
                stmt.setBoolean(i, (Boolean)v);
            } else {
                throw new SQLException("dunno what to do with " + v);
            }
            ++i;
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            this.includeLinkResultSetInSession(session, rs);
        }
    }

    public void includeLinkResultSetInSession(OBOSession session, ResultSet rs) throws SQLException {
        this.includeLinkResultSetInSession(session, rs, new HashMap<String, Link>());
    }

    public void includeLinkResultSetInSession(OBOSession session, ResultSet rs, HashMap<String, Link> positsMap) throws SQLException {
        Link link;
        LinkedObject node = (LinkedObject)this.lookupObject(session, rs.getString("node_uid"));
        OBOProperty pred = this.lookupProperty(session, rs.getString("pred_uid"));
        LinkedObject obj = (LinkedObject)this.lookupObject(session, rs.getString("object_uid"));
        Namespace source = this.lookupNamespace(session, rs.getString("source_uid"));
        boolean isImplied = rs.getBoolean("is_inferred");
        String metatype = rs.getString("node_metatype");
        if (metatype != null && metatype.equals("C")) {
            link = new OBORestrictionImpl(node, pred, obj, isImplied);
            String combinator = rs.getString("combinator");
            if (combinator.equals("I")) {
                ((OBORestriction)link).setCompletes(true);
            }
        } else {
            link = new InstancePropertyValue(node, pred, obj);
        }
        Integer annotId = rs.getInt("reiflink_node_id");
        if (!rs.wasNull()) {
            IdentifiedObject o = this.iid2obj.get(annotId);
            if (o == null) {
                o = this.fetchObjectByInternalID(session, annotId);
                this.iid2obj.put(annotId, o);
            }
            Instance inst = TermUtil.castToInstance((LinkedObject)o);
            AnnotationImpl annot = new AnnotationImpl(inst, link);
            positsMap.put(inst.getID(), link);
            session.addObject(annot);
        }
        link.setNamespace(source);
        this.includeLinkInSession(session, link);
    }

    public void includeLinkInSession(OBOSession session, Link link) {
        if (link.getType() == null) {
            return;
        }
        String pid = link.getType().getID();
        LinkedObject lo = link.getChild();
        LinkedObject p = link.getParent();
        if (pid.equals("oboMetaModel:inSubset")) {
            TermUtil.castToClass(lo);
            TermSubset category = session.getCategory(p.getID());
            if (category == null) {
                category = this.objectFactory.createSubset(p.getID(), "");
                session.addSubset(category);
            }
            TermUtil.castToClass(lo).addCategory(category);
        } else if (pid.equals("oboMetaModel:xref")) {
            OBOClass oboClass = TermUtil.castToClass(lo);
            if (oboClass == null) {
                logger.info((Object)("cannot cast " + lo));
            } else {
                oboClass.addDbxref(this.getDbxref(p.getID()));
            }
        } else if (pid.equals("OBO_REL:instance_of")) {
            if (p.getID().equals("subsetdef")) {
                TermSubset cat = this.objectFactory.createSubset(lo.getID(), lo.getName());
                session.addSubset(cat);
            } else if (!p.getID().equals("oban:Annotation")) {
                TermUtil.castToInstance(lo).setType(TermUtil.castToClass(p));
            }
        } else {
            lo.addParent(link);
        }
    }

    protected Dbxref getDbxref(String dbx) {
        String id;
        String db;
        int index = dbx.indexOf(58);
        if (index < 0) {
            db = "";
            id = dbx;
        } else {
            db = dbx.substring(0, index);
            id = dbx.substring(index + 1, dbx.length());
        }
        Dbxref ref = this.objectFactory.createDbxref(db, id, "", 1, null);
        return ref;
    }

    public void storeAll(OBOSession session, LinkDatabase ldb) throws DataAdapterException {
        try {
            this.setProgressString("Saving to db...");
            this.linkDatabase = ldb;
            this.savedObjects = new LinkedList<IdentifiedObject>();
            for (TermSubset cat : session.getSubsets()) {
                this.saveCategory(cat);
            }
            for (IdentifiedObject io : session.getObjects()) {
                if (io.isBuiltIn() || !(io instanceof Annotation) && this.ioprofile.getAnnotationMode().equals((Object)OBDSQLDatabaseAdapterConfiguration.AnnotationMode.ANNOTATIONS_ONLY)) continue;
                this.saveObject(io);
            }
            for (IdentifiedObject io : this.savedObjects) {
                if (!(io instanceof LinkedObject)) continue;
                if (io instanceof Annotation) {
                    // empty if block
                }
                for (Link link : ldb.getParents((LinkedObject)io)) {
                    if (link.getType().equals(AnnotationOntology.POSITS_REL())) continue;
                    this.saveLink(link);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new DataAdapterException((Throwable)e, "Write error");
        }
    }

    protected int saveObject(IdentifiedObject lo) throws SQLException {
        String cmt;
        String def;
        int iid;
        String ns = "";
        if (this.ioprofile.replaceLinks) {
            this.callSqlFunc("remove_links_for_node", lo.getID());
        }
        if (lo instanceof NamespacedObject && lo.getNamespace() != null) {
            ns = lo.getNamespace().getID();
        }
        if (lo instanceof Annotation) {
            Annotation annot = (Annotation)lo;
            LinkedObject linkedObject = annot.getObject();
            if (linkedObject == null) {
                logger.info((Object)("no object for: " + annot));
                return 0;
            }
            if (linkedObject.isAnonymous()) {
                this.saveObject(linkedObject);
                for (Link link : linkedObject.getParents()) {
                    this.saveLink(link);
                }
            }
            iid = this.callSqlFunc("store_annotation", annot.getSubject(), annot.getRelationship(), annot.getObject(), annot.getNamespace() == null ? "_" : annot.getNamespace().getID());
            this.link2iid.put(annot.getPositedLink(), iid);
        } else if ((lo instanceof DanglingObject || lo.getName() == null) && lo instanceof OBOClass) {
            iid = this.callSqlFunc("store_class_node", lo.getID());
        } else if (lo instanceof OBOClass) {
            iid = this.callSqlFunc("store_node", lo.getID(), lo.getName(), ns, "C");
        } else if (lo instanceof Instance) {
            iid = lo.getType() == null ? this.callSqlFunc("store_instance_node", lo.getID(), lo.getName(), ns) : this.callSqlFunc("store_instance_node", lo.getID(), lo.getName(), ns, lo.getType().getID());
        } else if (lo instanceof OBOProperty) {
            iid = this.callSqlFunc("store_node", lo.getID(), lo.getName(), ns, "R");
            OBOProperty prop = (OBOProperty)lo;
            if (prop.isTransitive()) {
                this.callSqlFunc("set_node_is_transitive_i", iid, true);
            }
            if (prop.isSymmetric()) {
                this.callSqlFunc("set_node_is_symmetric_i", iid, true);
            }
            if (prop.isNonInheritable()) {
                this.callSqlFunc("set_node_is_metadata_i", iid, true);
            }
        } else {
            iid = this.callSqlFunc("store_node", lo.getID());
        }
        if (lo instanceof ObsoletableObject) {
            ObsoletableObject olo = (ObsoletableObject)lo;
            this.callSqlFunc("set_node_is_obsolete_i", iid, olo.isObsolete());
            for (ObsoletableObject x : olo.getConsiderReplacements()) {
                this.callSqlFunc("store_link_si", iid, "oboMetaModel:consider", x.getID(), "", false);
            }
            for (ObsoletableObject x : olo.getReplacedBy()) {
                this.callSqlFunc("store_link_si", iid, "oboMetaModel:replaced_by", x.getID(), "", false);
            }
        }
        if (lo instanceof DbxrefedObject) {
            for (Dbxref dbxref : ((DbxrefedObject)((Object)lo)).getDbxrefs()) {
                this.callSqlFunc("store_node_dbxref_i", iid, dbxref.toString());
            }
        }
        if (lo instanceof SubsetObject) {
            for (TermSubset termSubset : ((SubsetObject)((Object)lo)).getSubsets()) {
                this.callSqlFunc("store_node_subset_link_i", iid, termSubset.getName());
            }
        }
        if (lo instanceof MultiIDObject) {
            for (String string : ((MultiIDObject)lo).getSecondaryIDs()) {
                this.callSqlFunc("store_node_alt_id_i", iid, string);
            }
        }
        if (lo instanceof SynonymedObject) {
            for (Synonym synonym : ((SynonymedObject)lo).getSynonyms()) {
                this.callSqlFunc("store_node_synonym_i", iid, TermUtil.getScopeLabel(synonym.getScope()), synonym.getSynonymType(), synonym.getText());
            }
        }
        if (lo instanceof DefinedObject && (def = ((DefinedObject)lo).getDefinition()) != null && def != "") {
            this.callSqlFunc("store_textdef_i", iid, def);
        }
        if (lo instanceof CommentedObject && (cmt = ((CommentedObject)lo).getComment()) != null && cmt != "") {
            this.callSqlFunc("store_comment_i", iid, cmt);
        }
        this.savedObjects.add(lo);
        this.obj2iid.put(lo, iid);
        return iid;
    }

    protected int saveCategory(TermSubset cat) throws SQLException {
        return this.callSqlFunc("store_subset", cat.getName(), cat.getDesc());
    }

    protected int saveLink(Link link) throws SQLException {
        int iid;
        if (this.link2iid.containsKey(link)) {
            return this.link2iid.get(link);
        }
        LinkedObject child = link.getChild();
        Integer childDbId = this.obj2iid.get(child);
        if (link instanceof ValueLink) {
            ValueLink pv = (ValueLink)link;
            Value v = pv.getValue();
            if (v instanceof DatatypeValue) {
                DatatypeValue dv = (DatatypeValue)v;
                iid = this.callSqlFunc("store_tagval", link.getChild().getID(), link.getType().getID(), dv.getValue(), dv.getType(), link.getNamespace());
            } else {
                iid = v instanceof IdentifiedObject ? this.callSqlFunc("store_link_si", childDbId, link.getType().getID(), link.getParent().getID(), TermUtil.isIntersection(link) ? "I" : "", TermUtil.isImplied(link), link.getNamespace()) : 0;
            }
        } else {
            iid = this.callSqlFunc("store_link_si", childDbId, link.getType().getID(), link.getParent().getID(), TermUtil.isIntersection(link) ? "I" : "", TermUtil.isImplied(link), link.getNamespace());
        }
        this.link2iid.put(link, iid);
        return iid;
    }

    public IdentifiedObject attachDescription(OBOSession session, ResultSet rs) throws SQLException {
        String id = rs.getString("node_uid");
        IdentifiedObject io = this.lookupObject(session, id);
        String type = rs.getString("type_uid");
        if (!rs.wasNull()) {
            String label = rs.getString("label");
            if (type.equals("definition") && io instanceof DefinedObject) {
                ((DefinedObject)io).setDefinition(label);
            }
        }
        return io;
    }

    public IdentifiedObject attachAlias(OBOSession session, ResultSet rs) throws SQLException {
        String id = rs.getString("node_uid");
        IdentifiedObject io = this.lookupObject(session, id);
        if (io instanceof SynonymedObject) {
            String scope = rs.getString("scope");
            String category = rs.getString("type_uid");
            String label = rs.getString("label");
            int scopeEnum = TermUtil.getScopeEnum(scope);
            Synonym syn = this.objectFactory.createSynonym(label, scopeEnum);
            if (category != null) {
                SynonymType categoryObj = this.objectFactory.createSynonymType(category, "", 0);
                syn.setSynonymType(categoryObj);
            }
            ((SynonymedObject)io).addSynonym(syn);
        }
        return io;
    }

    public IdentifiedObject lookupObject(OBOSession session, String id) {
        IdentifiedObject io = session.getObject(id);
        if (io == null) {
            io = this.objectFactory.createDanglingObject(id, false);
            session.addObject(io);
        }
        return io;
    }

    public OBOProperty lookupProperty(OBOSession session, String id) {
        IdentifiedObject io = session.getObject(id);
        if (io == null) {
            io = this.objectFactory.createDanglingObject(id, true);
        }
        return TermUtil.castToProperty(io);
    }

    public Namespace lookupNamespace(OBOSession session, String id) {
        Namespace io = session.getNamespace(id);
        return io;
    }

    protected int callSqlFunc(String func, Object ... args) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("{?= call " + func + "(");
        boolean isFirst = true;
        for (Object arg : args) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")}");
        logger.debug((Object)("sql=" + sql));
        for (Object ob : args) {
            logger.debug((Object)("  arg:" + ob));
        }
        CallableStatement stmt = this.connection.prepareCall(sql.toString());
        stmt.registerOutParameter(1, 4);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof Integer) {
                stmt.setInt(i + 2, (int)((Integer)arg));
                continue;
            }
            if (arg instanceof Boolean) {
                stmt.setBoolean(i + 2, (boolean)((Boolean)arg));
                continue;
            }
            if (arg instanceof IdentifiedObject) {
                stmt.setString(i + 2, ((IdentifiedObject)arg).getID());
                continue;
            }
            if (arg instanceof SynonymType) {
                stmt.setString(i + 2, ((SynonymType)arg).getID());
                continue;
            }
            stmt.setString(i + 2, (String)arg);
        }
        boolean rs = stmt.execute();
        return stmt.getInt(1);
    }

    protected String join(String sep, Collection<String> tokens) {
        StringBuffer s = new StringBuffer();
        for (String t : tokens) {
            if (s.length() == 0) {
                s.append(t);
                continue;
            }
            s.append(sep);
            s.append(t);
        }
        return s.toString();
    }

    public AdapterConfiguration getConfiguration() {
        return this.ioprofile;
    }

    public void setConfiguration(OBDSQLDatabaseAdapterConfiguration conf) {
        this.ioprofile = conf;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OBDSQLDatabaseAdapterConfiguration
    extends JDBCAdapterConfiguration {
        protected boolean allowDangling = false;
        protected boolean failFast = true;
        protected boolean saveImplied;
        protected boolean replaceLinks = false;
        protected List saveRecords = new ArrayList();
        protected boolean basicSave = true;
        protected Collection<Namespace> namespaces = new LinkedList<Namespace>();
        protected AnnotationMode annotationMode = AnnotationMode.BOTH;
        protected String serializer = "OBDSQL";
        protected String impliedType = "Save for presentation";

        public void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public boolean getFailFast() {
            return this.failFast;
        }

        public String getSerializer() {
            return this.serializer;
        }

        public boolean getBasicSave() {
            return this.basicSave;
        }

        public void setBasicSave(boolean basicSave) {
            this.basicSave = basicSave;
        }

        public List getSaveRecords() {
            return this.saveRecords;
        }

        public void setSaveRecords(List saveRecords) {
            if (saveRecords.contains(null)) {
                new Exception("Null save record added to profile").printStackTrace();
            }
            this.saveRecords = saveRecords;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean isSaveImplied() {
            return this.saveImplied;
        }

        public void setSaveImplied(boolean saveImplied) {
            this.saveImplied = saveImplied;
        }

        public AnnotationMode getAnnotationMode() {
            return this.annotationMode;
        }

        public void setAnnotationMode(AnnotationMode annotationMode) {
            this.annotationMode = annotationMode;
        }

        public Collection<Namespace> getNamespaces() {
            return this.namespaces;
        }

        public void setNamespaces(Collection<Namespace> namespaces) {
            this.namespaces = namespaces;
        }

        public void addNamespace(String namespace) {
            this.namespaces.add(new Namespace(namespace));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum AnnotationMode {
            BOTH,
            ANNOTATIONS_ONLY,
            ONTOLOGY_ONLY;

        }
    }
}

