/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Type;
import org.obo.datamodel.ValueLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OBOSerializer {
    public void setEngine(OBOSerializationEngine var1);

    public void setOutputStream(PrintStream var1) throws IOException;

    public void startSerialize() throws IOException;

    public void endSerialize() throws IOException;

    public String mapID(IdentifiedObject var1, String var2);

    public List getHeaderTagOrdering();

    public List getStanzaOrdering();

    public List getTagOrdering();

    public Comparator getObjectComparator();

    public Comparator getIDComparator();

    public Comparator getDbxrefComparator();

    public Comparator getSynonymComparator();

    public Comparator getSynonymCategoryComparator();

    public Comparator getCategoryComparator();

    public Comparator getXrefComparator();

    public Comparator getObsoleteComparator();

    public Comparator getLinkComparator();

    public void startHeader() throws IOException;

    public void endHeader() throws IOException;

    public void writeFormatVersionHeaderTag() throws IOException;

    public void writeDataVersionHeaderTag(String var1) throws IOException;

    public void writeDateHeaderTag(Date var1) throws IOException;

    public void writeSavedByHeaderTag(String var1) throws IOException;

    public void writeAutoGeneratedByHeaderTag(String var1) throws IOException;

    public void writeSubsetDefHeaderTag(TermSubset var1) throws IOException;

    public void writeSynonymTypeDefHeaderTag(SynonymType var1) throws IOException;

    public void writeIDSpaceHeaderTag(String var1, String var2) throws IOException;

    public void writeDefaultNamespaceHeaderTag(Namespace var1) throws IOException;

    public void writeRemarkHeaderTag(String var1) throws IOException;

    public void writeNamespaceIDRuleHeaderTag(String var1, String var2) throws IOException;

    public void startStanza(IdentifiedObject var1) throws IOException;

    public void endStanza(IdentifiedObject var1) throws IOException;

    public void writeIDTag(String var1, NestedValue var2) throws IOException;

    public void writeIsAnonymousTag(boolean var1, NestedValue var2) throws IOException;

    public void writeIsMetadataTag(boolean var1, NestedValue var2) throws IOException;

    public void writeNameTag(String var1, NestedValue var2) throws IOException;

    public void writeNamespaceTag(Namespace var1, NestedValue var2) throws IOException;

    public void writeAltIDTag(String var1, NestedValue var2) throws IOException;

    public void writeDefTag(String var1, Collection var2, NestedValue var3) throws IOException;

    public void writeCommentTag(String var1, NestedValue var2) throws IOException;

    public void writeSubsetTag(TermSubset var1, NestedValue var2) throws IOException;

    public void writeSynonymTag(Synonym var1, NestedValue var2) throws IOException;

    public void writeXrefTag(Dbxref var1) throws IOException;

    public void writeInstanceOfTag(Type var1, NestedValue var2) throws IOException;

    public void writePropertyValueTag(PropertyValue var1, NestedValue var2, int var3) throws IOException;

    public void writeDomainTag(IdentifiedObject var1, NestedValue var2) throws IOException;

    public void writeRangeTag(Type var1, NestedValue var2) throws IOException;

    public void writeIsCyclicTag(boolean var1, NestedValue var2) throws IOException;

    public void writeAlwaysImpliesInverseTag(boolean var1, NestedValue var2) throws IOException;

    public void writeIsReflexiveTag(boolean var1, NestedValue var2) throws IOException;

    public void writeIsSymmetricTag(boolean var1, NestedValue var2) throws IOException;

    public void writeIsTransitiveTag(boolean var1, NestedValue var2) throws IOException;

    public void writeValueLinkTag(ValueLink var1, NestedValue var2) throws IOException;

    public void writeLinkTag(Link var1, NestedValue var2) throws IOException;

    public void writeIsObsoleteTag(boolean var1, NestedValue var2) throws IOException;

    public void writeReplacedByTag(ObsoletableObject var1, NestedValue var2) throws IOException;

    public void writeConsiderTag(ObsoletableObject var1, NestedValue var2) throws IOException;

    public void writeUnrecognizedTag(PropertyValue var1) throws IOException;

    public String getID();

    public void writeCreatedByTag(String var1, NestedValue var2) throws IOException;

    public void writeModifiedByTag(String var1, NestedValue var2) throws IOException;

    public void writeCreationDateTag(Date var1, NestedValue var2) throws IOException;

    public void writeModificationDateTag(Date var1, NestedValue var2) throws IOException;

    public void writeHoldsOverChainTag(List<OBOProperty> var1) throws IOException;

    public void writeGenericHeaderTag(String var1, String var2) throws IOException;
}

