/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.ProgressableInputStream;
import org.bbop.io.SafeFileOutputStream;
import org.bbop.util.AbstractProgressValued;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.TrimmedLinkDatabase;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

public class SimpleLinkFileAdapter
extends AbstractProgressValued
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(SimpleLinkFileAdapter.class);
    String[] cols = new String[]{"subject", "relation", "object", "provenance", "xp", "redundancy"};
    protected String path;
    protected AdapterConfiguration config;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected OBOFileAdapter.OBOAdapterConfiguration ioprofile;
    protected List streams = new LinkedList();
    protected ReasonedLinkDatabase reasoner;

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        return ui;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration configuration, Object o) throws DataAdapterException {
        if (!(configuration instanceof OBOFileAdapter.OBOAdapterConfiguration)) {
            throw new DataAdapterException("Invalid configuration; this adapter requires an OBOAdapterConfiguration object.");
        }
        this.cancelled = false;
        this.ioprofile = (OBOFileAdapter.OBOAdapterConfiguration)configuration;
        if (op.equals(READ_ONTOLOGY)) {
            return null;
        }
        if (op.equals(WRITE_ONTOLOGY)) {
            LinkedList<OBOSerializationEngine.FilteredPath> filteredPaths = new LinkedList<OBOSerializationEngine.FilteredPath>();
            if (this.ioprofile.getBasicSave()) {
                filteredPaths.add(new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath()));
            } else {
                logger.info((Object)("gsr=" + this.ioprofile.getSaveRecords()));
                filteredPaths.addAll(this.ioprofile.getSaveRecords());
            }
            this.streams.clear();
            Iterator it = filteredPaths.iterator();
            if (it.hasNext()) {
                OBOSerializationEngine.FilteredPath filteredPath = (OBOSerializationEngine.FilteredPath)it.next();
                try {
                    logger.info((Object)("fp=" + filteredPath));
                    logger.info((Object)("fpp=" + filteredPath.getPath()));
                    SafeFileOutputStream sfos = new SafeFileOutputStream(filteredPath.getPath());
                    this.streams.add(sfos);
                    PrintStream stream = new PrintStream(new BufferedOutputStream((OutputStream)sfos));
                    this.write((OBOSession)o, stream, filteredPath);
                    return o;
                }
                catch (IOException ex) {
                    throw new DataAdapterException("Bad configuration");
                }
            }
        }
        return null;
    }

    public String getID() {
        return "OBO:SimpleLinkAdapter";
    }

    public String getName() {
        return "OBO Simple Link Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{WRITE_ONTOLOGY};
        return supported;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    public OBOSession write(OBOSession session, PrintStream stream, OBOSerializationEngine.FilteredPath filteredPath) throws DataAdapterException {
        try {
            ReasonedLinkDatabase fullReasoner;
            this.setProgressString("Writing file...");
            if (filteredPath.getUseSessionReasoner() && this.getReasoner() != null) {
                fullReasoner = this.reasoner;
            } else {
                logger.info((Object)"new reasoner...");
                fullReasoner = filteredPath.getReasonerFactory().createReasoner();
                fullReasoner.setLinkDatabase(new DefaultLinkDatabase(session));
                fullReasoner.recache();
            }
            for (int i = 0; i < this.cols.length; ++i) {
                String col = this.cols[i];
                if (i > 0) {
                    stream.print("\t");
                }
                stream.print(col);
            }
            LinkDatabase ldb = fullReasoner;
            if (filteredPath.getImpliedType() == "Save for presentation") {
                logger.info((Object)"using trimmed link db");
                ldb = new TrimmedLinkDatabase(fullReasoner);
            }
            stream.print("\n");
            for (IdentifiedObject io : ldb.getObjects()) {
                if (!(io instanceof LinkedObject)) continue;
                LinkedObject lo = (LinkedObject)io;
                for (Link link : ldb.getParents(lo)) {
                    stream.print(link.getChild().getID());
                    if (this.ioprofile.isIncludeNames()) {
                        stream.print(" " + link.getChild().getName());
                    }
                    stream.print("\t");
                    stream.print(link.getType().getID());
                    stream.print("\t");
                    stream.print(link.getParent().getID());
                    if (this.ioprofile.isIncludeNames()) {
                        stream.print(" " + link.getParent().getName());
                    }
                    stream.print("\t");
                    boolean isImplied = TermUtil.isImplied(link);
                    stream.print(isImplied ? "implied" : "asserted");
                    stream.print("\t");
                    stream.print(TermUtil.isIntersection(link) ? "intersection" : "link");
                    stream.print("\t");
                    stream.print(ReasonerUtil.isRedundant(fullReasoner, link, true) ? "redundant" : "");
                    if (this.ioprofile.isIncludeExplanations()) {
                        stream.print("\t");
                        stream.print(fullReasoner.getExplanations(link));
                    }
                    stream.print("\n");
                }
            }
            stream.close();
            return session;
        }
        catch (Exception e) {
            throw new DataAdapterException((Throwable)e, "Write error");
        }
    }

    public String getTermText(IdentifiedObject term) throws DataAdapterException {
        final StringBuffer buffer = new StringBuffer();
        OutputStream os = new OutputStream(){

            public void write(int b) {
                buffer.append((char)b);
            }
        };
        try {
            ObjectOutputStream stream = new ObjectOutputStream(os);
            stream.writeObject(os);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return buffer.toString();
    }
}

