/*
 * Decompiled with CFR 0.152.
 */
package org.obo.dataadapter;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.ProgressableInputStream;
import org.obo.dataadapter.OBOAdapter;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.history.AddConsiderHistoryItem;
import org.obo.history.AddDbxrefHistoryItem;
import org.obo.history.AddReplacementHistoryItem;
import org.obo.history.AddSynonymHistoryItem;
import org.obo.history.CardinalityHistoryItem;
import org.obo.history.ChangeSynScopeHistoryItem;
import org.obo.history.ChangeSynTypeHistoryItem;
import org.obo.history.CommentChangeHistoryItem;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.CyclicHistoryItem;
import org.obo.history.DefaultHistoryList;
import org.obo.history.DefinitionChangeHistoryItem;
import org.obo.history.DelDbxrefHistoryItem;
import org.obo.history.DelSynonymHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.DestroyObjectHistoryItem;
import org.obo.history.DomainHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.InverseNecHistoryItem;
import org.obo.history.LinkTypeHistoryItem;
import org.obo.history.MaxCardinalityHistoryItem;
import org.obo.history.MinCardinalityHistoryItem;
import org.obo.history.NameChangeHistoryItem;
import org.obo.history.NamespaceHistoryItem;
import org.obo.history.NecessarilyTrueHistoryItem;
import org.obo.history.ObsoleteObjectHistoryItem;
import org.obo.history.RangeHistoryItem;
import org.obo.history.RemoveConsiderHistoryItem;
import org.obo.history.RemoveReplacementHistoryItem;
import org.obo.history.SecondaryIDHistoryItem;
import org.obo.history.SessionHistoryList;
import org.obo.history.StringRelationship;
import org.obo.history.SubsetChangeHistoryItem;
import org.obo.history.SymmetricHistoryItem;
import org.obo.history.SynonymTypeHistoryItem;
import org.obo.history.TRNamespaceHistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.history.TermMergeHistoryItem;
import org.obo.history.TermMoveHistoryItem;
import org.obo.history.TermNamespaceHistoryItem;
import org.obo.history.TermSplitHistoryItem;
import org.obo.history.TermSubsetHistoryItem;
import org.obo.history.TransitiveHistoryItem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.XMLReader;

public class XMLHistoryAdapter
implements OBOAdapter {
    protected static final Logger logger = Logger.getLogger(XMLHistoryAdapter.class);
    protected String path;
    protected AdapterConfiguration config;
    protected ProgressableInputStream pfis;
    protected boolean cancelled = false;
    protected List listeners = new Vector();

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI();
        ui.setReadOperation(OBOAdapter.READ_HISTORY);
        ui.setWriteOperation(OBOAdapter.WRITE_HISTORY);
        ui.setMultiSelectEnabled(true);
        return ui;
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.pfis != null) {
                this.pfis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AdapterConfiguration getConfiguration() {
        return this.config;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration config, Object o) throws DataAdapterException {
        FileAdapterConfiguration fac = (FileAdapterConfiguration)config;
        if (op.equals(OBOAdapter.WRITE_HISTORY)) {
            try {
                this.config = config;
                this.cancelled = false;
                PrintStream stream = new PrintStream(new BufferedOutputStream(new FileOutputStream(fac.getWritePath())));
                if (o instanceof HistoryList) {
                    this.dumpHistory(stream, (HistoryList)o);
                }
                stream.close();
                return null;
            }
            catch (IOException ex) {
                throw new DataAdapterException("Couldn't write file", (Throwable)ex);
            }
        }
        if (op.equals(OBOAdapter.READ_HISTORY)) {
            try {
                SAXParserFactory spfactory = SAXParserFactory.newInstance();
                spfactory.setValidating(false);
                XMLReader reader = spfactory.newSAXParser().getXMLReader();
                HistoryContentHandler handler = new HistoryContentHandler();
                reader.setContentHandler(handler);
                String path = (String)fac.getReadPaths().iterator().next();
                reader.parse(new InputSource(new FileInputStream(path)));
                return handler.getHistories();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
                return null;
            }
        }
        throw new DataAdapterException("Operation " + op + " not supported");
    }

    public String getID() {
        return "OBO:XMLHistory";
    }

    public String getName() {
        return "OBO XML History Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{OBOAdapter.WRITE_HISTORY, OBOAdapter.READ_HISTORY};
        return supported;
    }

    public void dumpHistory(PrintStream stream, HistoryList historyList) {
        this.dumpHistory(stream, historyList, 0);
    }

    public void dumpHistories(PrintStream stream, List list, int indentLevel) {
        this.printLine(stream, indentLevel, "<histories>");
        for (HistoryList hl : list) {
            this.dumpHistory(stream, hl, indentLevel + 2);
        }
        this.printLine(stream, indentLevel, "</histories>");
    }

    protected String escapeText(String text) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '>') {
                out.append("&gt;");
                continue;
            }
            if (text.charAt(i) == '<') {
                out.append("&lt;");
                continue;
            }
            if (text.charAt(i) == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(text.charAt(i));
        }
        return out.toString();
    }

    protected void dumpHistory(PrintStream stream, HistoryList l, int indentLevel) {
        this.printLine(stream, indentLevel, "<edithistory>");
        if (l instanceof SessionHistoryList) {
            SessionHistoryList list = (SessionHistoryList)l;
            String user = list.getUser();
            if (user != null) {
                this.printLine(stream, indentLevel + 2, "<user>" + this.escapeText(user) + "</user>");
            }
            this.printLine(stream, indentLevel + 2, "<date>" + this.escapeText(list.getDate().toString()) + "</date>");
            if (list.getVersion() != null) {
                this.printLine(stream, indentLevel + 2, "<version>" + this.escapeText(list.getVersion()) + "</version>");
            }
            if (list.getComment() != null) {
                this.printLine(stream, indentLevel + 2, "<comment>" + this.escapeText(list.getComment()) + "</comment>");
            }
        }
        this.printLine(stream, indentLevel + 2, "<historyList>");
        this.dumpHistoryItems(stream, l, indentLevel + 4);
        this.printLine(stream, indentLevel + 2, "</historyList>");
        this.printLine(stream, indentLevel, "</edithistory>");
    }

    protected void dumpHistoryItems(PrintStream stream, HistoryList historyList, int indentLevel) {
        if (historyList.size() == 0) {
            return;
        }
        Iterator it = historyList.getHistoryItems();
        this.printLine(stream, indentLevel, "<list>");
        this.printLine(stream, indentLevel + 2, "<head>");
        for (int i = 0; i < historyList.size(); ++i) {
            HistoryItem item = historyList.getItemAt(i);
            this.dumpItem(stream, item, indentLevel + 4);
            if (i < historyList.size() - 1) {
                this.printLine(stream, indentLevel + 2, "</head> <tail> <list> <head>");
                continue;
            }
            if (historyList.size() == 1) {
                this.printLine(stream, indentLevel + 2, "</head>");
                continue;
            }
            this.printLine(stream, indentLevel + 2, "</head> </list>");
        }
        StringBuffer closer = new StringBuffer();
        for (int i = 0; i < historyList.size() - 1; ++i) {
            if (i != 0) {
                closer.append(" ");
            }
            if (i < historyList.size() - 2) {
                closer.append("</tail> </list>");
                continue;
            }
            closer.append("</tail>");
        }
        if (closer.length() > 0) {
            this.printLine(stream, indentLevel + 2, closer.toString());
        }
        this.printLine(stream, indentLevel, "</list>");
    }

    protected void dumpCategory(PrintStream stream, TermSubset cat, int indentLevel) {
        this.printLine(stream, indentLevel, "<TermCategory>");
        this.printLine(stream, indentLevel, "  <catname>" + this.escapeText(cat.getName()) + "</catname>");
        this.printLine(stream, indentLevel, "  <catdesc>" + this.escapeText(cat.getDesc()) + "</catdesc>");
        this.printLine(stream, indentLevel, "</TermCategory>");
    }

    protected void dumpSynonymCategory(PrintStream stream, SynonymType cat, int indentLevel) {
        this.printLine(stream, indentLevel, "<SynonymCategory>");
        this.printLine(stream, indentLevel + 2, "<syncatid>" + this.escapeText(cat.getID()) + "</syncatid>");
        this.printLine(stream, indentLevel + 2, "<syncatname>" + this.escapeText(cat.getName()) + "</syncatname>");
        this.printLine(stream, indentLevel + 2, "<syncatscope>" + cat.getScope() + "</syncatscope>");
        this.printLine(stream, indentLevel, "</SynonymCategory>");
    }

    protected void dumpDbxref(PrintStream stream, Dbxref dbx, int indentLevel) {
        this.printLine(stream, indentLevel, "<dbxref>");
        this.printLine(stream, indentLevel + 2, "<database>" + this.escapeText(dbx.getDatabase()) + "</database>");
        this.printLine(stream, indentLevel + 2, "<dbxrefid>" + this.escapeText(dbx.getDatabaseID()) + "</dbxrefid>");
        if (dbx.getDesc() != null) {
            this.printLine(stream, indentLevel + 2, "<dbxrefdesc>" + this.escapeText(dbx.getDesc()) + "</dbxrefdesc>");
        }
        String typeStr = "";
        typeStr = dbx.getType() == 0 ? "anatomical" : (dbx.getType() == 1 ? "synonym" : (dbx.getType() == 2 ? "definition" : (dbx.getType() == 3 ? "analog" : "unknown")));
        this.printLine(stream, indentLevel + 2, "<dbxreftype>" + this.escapeText(typeStr) + "</dbxreftype>");
        this.printLine(stream, indentLevel, "</dbxref>");
    }

    protected void dumpRelationship(PrintStream stream, StringRelationship tr, int indentLevel) {
        this.printLine(stream, indentLevel, "<Link>");
        this.printLine(stream, indentLevel + 2, "<child>" + tr.getChild() + "</child>");
        if (tr.getParent() != null) {
            this.printLine(stream, indentLevel + 2, "<parent>" + this.escapeText(tr.getParent()) + "</parent>");
        }
        if (tr.getType() != null) {
            this.printLine(stream, indentLevel + 2, "<type>" + this.escapeText(tr.getType()) + "</type>");
        }
        this.printLine(stream, indentLevel, "</Link>");
    }

    protected void dumpSynonym(PrintStream stream, Synonym s, int indentLevel) {
        this.printLine(stream, indentLevel, "<synonym>");
        this.printLine(stream, indentLevel + 2, "<syntext>" + this.escapeText(s.getText()) + "</syntext>");
        String typeStr = "";
        if (s.getScope() == 0) {
            typeStr = "Synonym";
        } else if (s.getScope() == 1) {
            typeStr = "Exact";
        } else if (s.getScope() == 2) {
            typeStr = "Narrow";
        } else if (s.getScope() == 3) {
            typeStr = "Broad";
        }
        this.printLine(stream, indentLevel + 2, "<syntype>" + this.escapeText(typeStr) + "</syntype>");
        this.printLine(stream, indentLevel, "</synonym>");
    }

    protected void dumpItem(PrintStream stream, HistoryItem hitem, int indentLevel) {
        if (hitem instanceof CardinalityHistoryItem) {
            CardinalityHistoryItem item = (CardinalityHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<CardinalityHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            if (item.getOldValue() != null) {
                this.printLine(stream, indentLevel + 2, "<oldCardinality>");
                this.printLine(stream, indentLevel + 4, item.getOldValue() + "");
                this.printLine(stream, indentLevel + 2, "</oldCardinality>");
            }
            if (item.getNewValue() != null) {
                this.printLine(stream, indentLevel + 2, "<newCardinality>");
                this.printLine(stream, indentLevel + 4, item.getNewValue() + "");
                this.printLine(stream, indentLevel + 2, "</newCardinality>");
            }
            this.printLine(stream, indentLevel, "</CardinalityHistoryItem>");
        } else if (hitem instanceof MinCardinalityHistoryItem) {
            MinCardinalityHistoryItem item = (MinCardinalityHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<MinCardinalityHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel + 2, "<oldMinCardinality>");
            this.printLine(stream, indentLevel + 4, item.getOldValue() + "");
            this.printLine(stream, indentLevel + 2, "</oldMinCardinality>");
            this.printLine(stream, indentLevel + 2, "<newMinCardinality>");
            this.printLine(stream, indentLevel + 4, item.getNewValue() + "");
            this.printLine(stream, indentLevel + 2, "</newMinCardinality>");
            this.printLine(stream, indentLevel, "</MinCardinalityHistoryItem>");
        } else if (hitem instanceof MaxCardinalityHistoryItem) {
            MaxCardinalityHistoryItem item = (MaxCardinalityHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<MaxCardinalityHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel + 2, "<oldMaxCardinality>");
            this.printLine(stream, indentLevel + 4, item.getOldValue() + "");
            this.printLine(stream, indentLevel + 2, "</oldMaxCardinality>");
            this.printLine(stream, indentLevel + 2, "<newMaxCardinality>");
            this.printLine(stream, indentLevel + 4, item.getNewValue() + "");
            this.printLine(stream, indentLevel + 2, "</newMaxCardinality>");
            this.printLine(stream, indentLevel, "</MaxCardinalityHistoryItem>");
        } else if (hitem instanceof NecessarilyTrueHistoryItem) {
            NecessarilyTrueHistoryItem item = (NecessarilyTrueHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<NecessarilyTrueHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel + 2, "<oldNecessary>");
            this.printLine(stream, indentLevel + 4, item.getOldNecessary() + "");
            this.printLine(stream, indentLevel + 2, "</oldNecessary>");
            this.printLine(stream, indentLevel, "</NecessarilyTrueHistoryItem>");
        } else if (hitem instanceof TermSubsetHistoryItem) {
            TermSubsetHistoryItem item = (TermSubsetHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermCategoryHistoryItem>");
            if (item.getTarget() != null) {
                this.printLine(stream, indentLevel + 2, "<target>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
                this.printLine(stream, indentLevel + 2, "</target>");
            }
            if (!item.isDel()) {
                this.printLine(stream, indentLevel + 2, "<newcat>");
                this.dumpCategory(stream, item.getNewSubset(), indentLevel + 4);
                this.printLine(stream, indentLevel + 2, "</newcat>");
            }
            if (!item.isAdd()) {
                this.printLine(stream, indentLevel + 2, "<oldcat>");
                this.dumpCategory(stream, item.getOldCategory(), indentLevel + 4);
                this.printLine(stream, indentLevel + 2, "</oldcat>");
            }
            if (item.isDel() != item.isAdd()) {
                if (item.isAdd()) {
                    this.printLine(stream, indentLevel + 2, "<iscatadd>true</iscatadd>");
                }
                if (item.isDel()) {
                    this.printLine(stream, indentLevel + 2, "<iscatdel>true</iscatdel>");
                }
            }
            this.printLine(stream, indentLevel, "</TermCategoryHistoryItem>");
        } else if (hitem instanceof CompletesHistoryItem) {
            CompletesHistoryItem item = (CompletesHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<CompletesHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel + 2, "<oldCompletes>" + item.getOldCompletes() + "</oldCompletes>");
            this.printLine(stream, indentLevel, "</CompletesHistoryItem>");
        } else if (hitem instanceof CreateLinkHistoryItem) {
            CreateLinkHistoryItem item = (CreateLinkHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermCopyHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            this.printLine(stream, indentLevel + 2, "<type>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTypeID()));
            this.printLine(stream, indentLevel + 2, "</type>");
            this.printLine(stream, indentLevel + 2, "<parent>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getParentID()));
            this.printLine(stream, indentLevel + 2, "</parent>");
            this.printLine(stream, indentLevel, "</TermCopyHistoryItem>");
        } else if (hitem instanceof CyclicHistoryItem) {
            CyclicHistoryItem item = (CyclicHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<CyclicHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            this.printLine(stream, indentLevel + 2, "<oldCyclic>" + item.getOldCyclic() + "</oldCyclic>");
            this.printLine(stream, indentLevel, "</CyclicHistoryItem>");
        } else if (hitem instanceof SymmetricHistoryItem) {
            SymmetricHistoryItem item = (SymmetricHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<SymmetricHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            this.printLine(stream, indentLevel + 2, "<oldSymmetric>" + item.getOldSymmetric() + "</oldSymmetric>");
            this.printLine(stream, indentLevel, "</SymmetricHistoryItem>");
        } else if (hitem instanceof TransitiveHistoryItem) {
            TransitiveHistoryItem item = (TransitiveHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TransitiveHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            this.printLine(stream, indentLevel + 2, "<oldTransitive>" + item.getOldTransitive() + "</oldTransitive>");
            this.printLine(stream, indentLevel, "</TransitiveHistoryItem>");
        } else if (hitem instanceof DeleteLinkHistoryItem) {
            DeleteLinkHistoryItem item = (DeleteLinkHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<DeleteLinkHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel, "</DeleteLinkHistoryItem>");
        } else if (hitem instanceof DomainHistoryItem) {
            DomainHistoryItem item = (DomainHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<DomainHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            if (item.getDomain() != null) {
                this.printLine(stream, indentLevel + 2, "<domain>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getDomain()));
                this.printLine(stream, indentLevel + 2, "</domain>");
            }
            if (item.getOldDomain() != null) {
                this.printLine(stream, indentLevel + 2, "<oldDomain>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getOldDomain()));
                this.printLine(stream, indentLevel + 2, "</oldDomain>");
            }
            this.printLine(stream, indentLevel, "</DomainHistoryItem>");
        } else if (hitem instanceof RangeHistoryItem) {
            RangeHistoryItem item = (RangeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<RangeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            if (item.getRange() != null) {
                this.printLine(stream, indentLevel + 2, "<range>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getRange()));
                this.printLine(stream, indentLevel + 2, "</range>");
            }
            if (item.getOldRange() != null) {
                this.printLine(stream, indentLevel + 2, "<oldRange>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getOldRange()));
                this.printLine(stream, indentLevel + 2, "</oldRange>");
            }
            this.printLine(stream, indentLevel, "</RangeHistoryItem>");
        } else if (hitem instanceof TermMergeHistoryItem) {
            TermMergeHistoryItem item = (TermMergeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermMergeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<slave>" + this.escapeText(item.getSlave()) + "</slave>");
            if (item.size() > 0) {
                this.printLine(stream, indentLevel + 2, "<editlist>");
                this.dumpHistory(stream, item, indentLevel + 4);
                this.printLine(stream, indentLevel + 2, "</editlist>");
            }
            this.printLine(stream, indentLevel, "</TermMergeHistoryItem>");
        } else if (hitem instanceof TermSplitHistoryItem) {
            TermSplitHistoryItem item = (TermSplitHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermSplitHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            if (item.addType()) {
                this.printLine(stream, indentLevel + 2, "<splitAddType>true</splitAddType>");
            }
            this.printLine(stream, indentLevel + 2, "<splitresult>" + this.escapeText(item.getResult()) + "</splitresult>");
            if (item.size() > 0) {
                this.printLine(stream, indentLevel + 2, "<editlist>");
                this.dumpHistory(stream, item, indentLevel + 4);
                this.printLine(stream, indentLevel + 2, "</editlist>");
            }
            this.printLine(stream, indentLevel, "</TermSplitHistoryItem>");
        } else if (hitem instanceof TermMoveHistoryItem) {
            TermMoveHistoryItem item = (TermMoveHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermMoveHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRelationship(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel, "</TermMoveHistoryItem>");
        } else if (hitem instanceof InverseNecHistoryItem) {
            InverseNecHistoryItem item = (InverseNecHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<InverseNecHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel + 2, "<oldInvNec>" + item.getOldInverseNecessary() + "</oldInvNec>");
            this.printLine(stream, indentLevel, "</InverseNecHistoryItem>");
        } else if (hitem instanceof TermNamespaceHistoryItem) {
            TermNamespaceHistoryItem item = (TermNamespaceHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermNamespaceHistoryItem>");
            if (!item.isAdd() && item.getOldID() != null) {
                this.printLine(stream, indentLevel + 2, "<oldnamespace>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getOldID()));
                this.printLine(stream, indentLevel + 2, "</oldnamespace>");
            }
            if (!item.isDel() && item.getNewID() != null) {
                this.printLine(stream, indentLevel + 2, "<newnamespace>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getNewID()));
                this.printLine(stream, indentLevel + 2, "</newnamespace>");
            }
            if (item.isDel() != item.isAdd()) {
                if (item.isAdd()) {
                    this.printLine(stream, indentLevel + 2, "<isNamespaceAdd>true</isNamespaceAdd>");
                }
                if (item.isDel()) {
                    this.printLine(stream, indentLevel + 2, "<isNamespaceDel>true</isNamespaceDel>");
                }
            }
            this.printLine(stream, indentLevel, "</TermNamespaceHistoryItem>");
        } else if (hitem instanceof LinkTypeHistoryItem) {
            LinkTypeHistoryItem item = (LinkTypeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<LinkTypeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            this.printLine(stream, indentLevel + 2, "<newType>" + this.escapeText(item.getRelationshipType()) + "</newType>");
            this.printLine(stream, indentLevel, "</LinkTypeHistoryItem>");
        } else if (hitem instanceof SecondaryIDHistoryItem) {
            SecondaryIDHistoryItem item = (SecondaryIDHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<SecondaryIDHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>");
            this.printLine(stream, indentLevel + 4, this.escapeText(item.getTarget()));
            this.printLine(stream, indentLevel + 2, "</target>");
            this.printLine(stream, indentLevel + 2, "<secondaryid>" + this.escapeText(item.getSecondaryID()) + "</secondaryid>");
            if (item.isDelete()) {
                this.printLine(stream, indentLevel + 2, "<secondarydelete>true</secondarydelete>");
            }
            this.printLine(stream, indentLevel, "</SecondaryIDHistoryItem>");
        } else if (hitem instanceof TRNamespaceHistoryItem) {
            TRNamespaceHistoryItem item = (TRNamespaceHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TRNamespaceHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<sourcerel>");
            this.dumpRelationship(stream, item.getRel(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</sourcerel>");
            if (item.getOldNamespace() != null) {
                this.printLine(stream, indentLevel + 2, "<oldtrns>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getOldNamespace()));
                this.printLine(stream, indentLevel + 2, "</oldtrns>");
            }
            if (item.getNewNamespace() != null) {
                this.printLine(stream, indentLevel + 2, "<newtrns>");
                this.printLine(stream, indentLevel + 4, this.escapeText(item.getNewNamespace()));
                this.printLine(stream, indentLevel + 2, "</newtrns>");
            }
            this.printLine(stream, indentLevel, "</TRNamespaceHistoryItem>");
        } else if (hitem instanceof TermMacroHistoryItem) {
            TermMacroHistoryItem item = (TermMacroHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<TermMacroHistoryItem>");
            if (item.getTarget() != null) {
                this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            }
            if (item.getResult() != null) {
                this.printLine(stream, indentLevel + 2, "<result>" + this.escapeText(item.getResult()) + "</result>");
            }
            this.printLine(stream, indentLevel + 2, "<desc>" + this.escapeText(item.getDescription()) + "</desc>");
            this.printLine(stream, indentLevel + 2, "<editlist>");
            this.dumpHistory(stream, item, indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</editlist>");
            this.printLine(stream, indentLevel, "</TermMacroHistoryItem>");
        } else if (hitem instanceof AddDbxrefHistoryItem) {
            AddDbxrefHistoryItem item = (AddDbxrefHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<AddDbxrefHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + item.getTarget() + "</target>");
            this.printLine(stream, indentLevel + 2, "<target_xref>");
            this.dumpDbxref(stream, item.getDbxref(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</target_xref>");
            if (item.isDef()) {
                this.printLine(stream, indentLevel + 2, "<isDef>true</isDef>");
            }
            if (item.getSynonym() != null) {
                this.printLine(stream, indentLevel + 2, "<target_synonym>" + this.escapeText(item.getSynonym()) + "</target_synonym>");
            }
            this.printLine(stream, indentLevel, "</AddDbxrefHistoryItem>");
        } else if (hitem instanceof DelDbxrefHistoryItem) {
            DelDbxrefHistoryItem item = (DelDbxrefHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<DelDbxrefHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + item.getTarget() + "</target>");
            this.printLine(stream, indentLevel + 2, "<target_xref>");
            this.dumpDbxref(stream, item.getDbxref(), indentLevel + 4);
            this.printLine(stream, indentLevel + 2, "</target_xref>");
            if (item.isDef()) {
                this.printLine(stream, indentLevel + 2, "<isDef>true</isDef>");
            }
            if (item.getSynonym() != null) {
                this.printLine(stream, indentLevel + 2, "<synonym>" + this.escapeText(item.getSynonym()) + "</synonym>");
            }
            this.printLine(stream, indentLevel, "</DelDbxrefHistoryItem>");
        } else if (hitem instanceof AddReplacementHistoryItem) {
            AddReplacementHistoryItem item = (AddReplacementHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<AddReplacementHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            if (item.getReplace() != null) {
                this.printLine(stream, indentLevel + 2, "<replacedby>" + this.escapeText(item.getReplace()) + "</replacedby>");
            }
            this.printLine(stream, indentLevel, "</AddReplacementHistoryItem>");
        } else if (hitem instanceof RemoveReplacementHistoryItem) {
            RemoveReplacementHistoryItem item = (RemoveReplacementHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<RemoveReplacementHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            if (item.getReplace() != null) {
                this.printLine(stream, indentLevel + 2, "<replacedby>" + this.escapeText(item.getReplace()) + "</replacedby>");
            }
            this.printLine(stream, indentLevel, "</RemoveReplacementHistoryItem>");
        } else if (hitem instanceof AddConsiderHistoryItem) {
            AddConsiderHistoryItem item = (AddConsiderHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<AddConsiderHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<consider>" + this.escapeText(item.getConsider()) + "</consider>");
            this.printLine(stream, indentLevel, "</AddConsiderHistoryItem>");
        } else if (hitem instanceof RemoveConsiderHistoryItem) {
            RemoveConsiderHistoryItem item = (RemoveConsiderHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<RemoveConsiderHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<consider>" + this.escapeText(item.getConsider()) + "</consider>");
            this.printLine(stream, indentLevel, "</RemoveConsiderHistoryItem>");
        } else if (hitem instanceof AddSynonymHistoryItem) {
            AddSynonymHistoryItem item = (AddSynonymHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<AddSynonymHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<synonym_edit_target>" + this.escapeText(item.getSynonym()) + "</synonym_edit_target>");
            this.printLine(stream, indentLevel, "</AddSynonymHistoryItem>");
        } else if (hitem instanceof DelSynonymHistoryItem) {
            DelSynonymHistoryItem item = (DelSynonymHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<DelSynonymHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<synonym_edit_target>" + this.escapeText(item.getSynonym()) + "</synonym_edit_target>");
            this.printLine(stream, indentLevel, "</DelSynonymHistoryItem>");
        } else if (hitem instanceof SubsetChangeHistoryItem) {
            SubsetChangeHistoryItem item = (SubsetChangeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<CategoryChangeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<category>" + this.escapeText(item.getCategory()) + "</category>");
            if (item.isDel()) {
                this.printLine(stream, indentLevel + 2, "<isTermCatDel>true</isTermCatDel>");
            }
            this.printLine(stream, indentLevel, "</CategoryChangeHistoryItem>");
        } else if (hitem instanceof ChangeSynTypeHistoryItem) {
            ChangeSynTypeHistoryItem item = (ChangeSynTypeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<ChangeSynCategoryHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<synonym_edit_target>" + this.escapeText(item.getSynonym()) + "</synonym_edit_target>");
            if (item.getOldType() != null) {
                this.printLine(stream, indentLevel + 2, "<oldSynCategory>" + this.escapeText(item.getOldType()) + "</oldSynCategory>");
            }
            if (item.getNewType() != null) {
                this.printLine(stream, indentLevel + 2, "<newSynCategory>" + this.escapeText(item.getNewType()) + "</newSynCategory>");
            }
            this.printLine(stream, indentLevel, "</ChangeSynCategoryHistoryItem>");
        } else if (hitem instanceof ChangeSynScopeHistoryItem) {
            ChangeSynScopeHistoryItem item = (ChangeSynScopeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<ChangeSynScopeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel + 2, "<synonym_edit_target>" + this.escapeText(item.getSynonym()) + "</synonym_edit_target>");
            this.printLine(stream, indentLevel + 2, "<oldScope>" + item.getOldScope() + "</oldScope>");
            this.printLine(stream, indentLevel + 2, "<newScope>" + item.getNewScope() + "</newScope>");
            this.printLine(stream, indentLevel, "</ChangeSynScopeHistoryItem>");
        } else if (hitem instanceof CommentChangeHistoryItem) {
            CommentChangeHistoryItem item = (CommentChangeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<CommentChangeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            if (item.getText() != null) {
                this.printLine(stream, indentLevel + 2, "<oldComment>" + this.escapeText(item.getText()) + "</oldComment>");
            }
            if (item.getNewText() != null) {
                this.printLine(stream, indentLevel + 2, "<newComment>" + this.escapeText(item.getNewText()) + "</newComment>");
            }
            this.printLine(stream, indentLevel, "</CommentChangeHistoryItem>");
        } else if (hitem instanceof CreateObjectHistoryItem) {
            CreateObjectHistoryItem item = (CreateObjectHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<CreateObjectHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<objectID>" + this.escapeText(item.getObjectID()) + "</objectID>");
            this.printLine(stream, indentLevel + 2, "<typeID>" + this.escapeText(item.getObjectType()) + "</typeID>");
            this.printLine(stream, indentLevel, "</CreateObjectHistoryItem>");
        } else if (hitem instanceof DefinitionChangeHistoryItem) {
            DefinitionChangeHistoryItem item = (DefinitionChangeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<DefinitionChangeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + item.getTarget() + "</target>");
            if (item.getText() != null) {
                this.printLine(stream, indentLevel + 2, "<oldDef>" + item.getText() + "</oldDef>");
            }
            if (item.getNewText() != null) {
                this.printLine(stream, indentLevel + 2, "<newDef>" + item.getNewText() + "</newDef>");
            }
            this.printLine(stream, indentLevel, "</DefinitionChangeHistoryItem>");
        } else if (hitem instanceof DestroyObjectHistoryItem) {
            DestroyObjectHistoryItem item = (DestroyObjectHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<DestroyObjectHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + item.getTarget() + "</target>");
            this.printLine(stream, indentLevel, "</DestroyObjectHistoryItem>");
        } else if (hitem instanceof NameChangeHistoryItem) {
            NameChangeHistoryItem item = (NameChangeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<NameChangeHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + item.getTarget() + "</target>");
            this.printLine(stream, indentLevel + 2, "<oldText>" + this.escapeText(item.getText()) + "</oldText>");
            this.printLine(stream, indentLevel + 2, "<newText>" + this.escapeText(item.getNewText()) + "</newText>");
            this.printLine(stream, indentLevel, "</NameChangeHistoryItem>");
        } else if (hitem instanceof NamespaceHistoryItem) {
            NamespaceHistoryItem item = (NamespaceHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<NamespaceHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            if (item.getOldNamespace() != null) {
                this.printLine(stream, indentLevel + 2, "<oldns>" + this.escapeText(item.getOldNamespace().getID()) + "</oldns>");
            }
            if (item.getNewNamespace() != null) {
                this.printLine(stream, indentLevel + 2, "<newns>" + this.escapeText(item.getNewNamespace().getID()) + "</newns>");
            }
            this.printLine(stream, indentLevel, "</NamespaceHistoryItem>");
        } else if (hitem instanceof ObsoleteObjectHistoryItem) {
            ObsoleteObjectHistoryItem item = (ObsoleteObjectHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<ObsoleteObjectHistoryItem>");
            this.printLine(stream, indentLevel + 2, "<target>" + this.escapeText(item.getTarget()) + "</target>");
            this.printLine(stream, indentLevel, "</ObsoleteObjectHistoryItem>");
        } else if (hitem instanceof SynonymTypeHistoryItem) {
            SynonymTypeHistoryItem item = (SynonymTypeHistoryItem)hitem;
            this.printLine(stream, indentLevel, "<SynonymTypeHistoryItem>");
            if (item.isAdd()) {
                this.printLine(stream, indentLevel + 2, "<isSynCatAdd>true</isSynCatAdd>");
            }
            if (item.isDel()) {
                this.printLine(stream, indentLevel + 2, "<isSynCatDel>true</isSynCatDel>");
            }
            if (item.getOldCategory() != null) {
                this.printLine(stream, indentLevel + 2, "<oldSynCat>");
                this.dumpSynonymCategory(stream, item.getOldCategory(), indentLevel + 4);
                this.printLine(stream, indentLevel + 2, "</oldSynCat>");
            }
            if (item.getNewCategory() != null) {
                this.printLine(stream, indentLevel + 2, "<newSynCat>");
                this.dumpSynonymCategory(stream, item.getNewCategory(), indentLevel + 4);
                this.printLine(stream, indentLevel + 2, "</newSynCat>");
            }
            this.printLine(stream, indentLevel, "</SynonymCategoryHistoryItem>");
        }
    }

    public void printLine(PrintStream stream, int indent, String line) {
        for (int i = 0; i < indent; ++i) {
            stream.print(" ");
        }
        stream.print(line);
        stream.print("\n");
    }

    public String getProgressString() {
        return null;
    }

    public Number getProgressValue() {
        return null;
    }

    protected class HistoryContentHandler
    implements ContentHandler {
        protected List histories;
        protected SessionHistoryList historyList;
        StringBuffer buffer;
        Stack tagStack;
        boolean errors = false;
        Stack objectStack;
        protected ObjectFactory objectFactory = new DefaultObjectFactory();
        protected Locator locator;

        public void setObjectFactory(ObjectFactory factory) {
            this.objectFactory = factory;
        }

        public List getHistories() {
            return this.histories;
        }

        public HistoryList getHistoryList() {
            return this.historyList;
        }

        public void characters(char[] ch, int start, int length) {
            this.buffer.append(ch, start, length);
        }

        public void startDocument() {
            this.buffer = new StringBuffer();
            this.tagStack = new Stack();
            this.objectStack = new Stack();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.buffer.delete(0, this.buffer.length());
            this.tagStack.push(qName);
            if (qName.equalsIgnoreCase("list")) {
                this.objectStack.push(new BasicLinkedList());
            } else if (qName.equalsIgnoreCase("histories")) {
                this.histories = new Vector();
                this.objectStack.push(this.histories);
            } else if (qName.equalsIgnoreCase("edithistory")) {
                this.historyList = new DefaultHistoryList();
                this.objectStack.push(this.historyList);
            } else if (qName.equalsIgnoreCase("TRNamespaceHistoryItem")) {
                this.objectStack.push(new TRNamespaceHistoryItem());
            } else if (qName.equalsIgnoreCase("CompletesHistoryItem")) {
                this.objectStack.push(new CompletesHistoryItem());
            } else if (qName.equalsIgnoreCase("AddDbxrefHistoryItem")) {
                this.objectStack.push(new AddDbxrefHistoryItem());
            } else if (qName.equalsIgnoreCase("AddConsiderHistoryItem")) {
                this.objectStack.push(new AddConsiderHistoryItem());
            } else if (qName.equalsIgnoreCase("RemoveConsiderHistoryItem")) {
                this.objectStack.push(new RemoveConsiderHistoryItem());
            } else if (qName.equalsIgnoreCase("AddReplacementHistoryItem")) {
                this.objectStack.push(new AddReplacementHistoryItem());
            } else if (qName.equalsIgnoreCase("RemoveReplacementHistoryItem")) {
                this.objectStack.push(new RemoveReplacementHistoryItem());
            } else if (qName.equalsIgnoreCase("DelDbxrefHistoryItem")) {
                this.objectStack.push(new DelDbxrefHistoryItem());
            } else if (qName.equalsIgnoreCase("AddSynonymHistoryItem")) {
                this.objectStack.push(new AddSynonymHistoryItem());
            } else if (qName.equalsIgnoreCase("DelSynonymHistoryItem")) {
                this.objectStack.push(new DelSynonymHistoryItem());
            } else if (qName.equalsIgnoreCase("DomainHistoryItem")) {
                this.objectStack.push(new DomainHistoryItem());
            } else if (qName.equalsIgnoreCase("RangeHistoryItem")) {
                this.objectStack.push(new RangeHistoryItem());
            } else if (qName.equalsIgnoreCase("SymmetricHistoryItem")) {
                this.objectStack.push(new SymmetricHistoryItem());
            } else if (qName.equalsIgnoreCase("TransitiveHistoryItem")) {
                this.objectStack.push(new TransitiveHistoryItem());
            } else if (qName.equalsIgnoreCase("CyclicHistoryItem")) {
                this.objectStack.push(new CyclicHistoryItem());
            } else if (qName.equalsIgnoreCase("CardinalityHistoryItem")) {
                this.objectStack.push(new CardinalityHistoryItem());
            } else if (qName.equalsIgnoreCase("MaxCardinalityHistoryItem")) {
                this.objectStack.push(new MaxCardinalityHistoryItem());
            } else if (qName.equalsIgnoreCase("MinCardinalityHistoryItem")) {
                this.objectStack.push(new MinCardinalityHistoryItem());
            } else if (qName.equalsIgnoreCase("InverseNecHistoryItem")) {
                this.objectStack.push(new InverseNecHistoryItem());
            } else if (qName.equalsIgnoreCase("SecondaryIDHistoryItem")) {
                this.objectStack.push(new SecondaryIDHistoryItem());
            } else if (qName.equalsIgnoreCase("NecessarilyTrueHistoryItem")) {
                this.objectStack.push(new NecessarilyTrueHistoryItem());
            } else if (qName.equalsIgnoreCase("CreateObjectHistoryItem")) {
                this.objectStack.push(new CreateObjectHistoryItem());
            } else if (qName.equalsIgnoreCase("DeleteLinkHistoryItem")) {
                this.objectStack.push(new DeleteLinkHistoryItem());
            } else if (qName.equalsIgnoreCase("DestroyObjectHistoryItem")) {
                this.objectStack.push(new DestroyObjectHistoryItem());
            } else if (qName.equalsIgnoreCase("ObsoleteObjectHistoryItem")) {
                this.objectStack.push(new ObsoleteObjectHistoryItem());
            } else if (qName.equalsIgnoreCase("TermCategoryHistoryItem")) {
                this.objectStack.push(new TermSubsetHistoryItem());
            } else if (qName.equalsIgnoreCase("SynonymCategoryHistoryItem")) {
                this.objectStack.push(new SynonymTypeHistoryItem());
            } else if (qName.equalsIgnoreCase("TermCopyHistoryItem")) {
                this.objectStack.push(new CreateLinkHistoryItem());
            } else if (qName.equalsIgnoreCase("TermMoveHistoryItem")) {
                try {
                    this.objectStack.push(new TermMoveHistoryItem());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else if (qName.equalsIgnoreCase("TermNamespaceHistoryItem")) {
                this.objectStack.push(new TermNamespaceHistoryItem());
            } else if (qName.equalsIgnoreCase("Link")) {
                this.objectStack.push(new StringRelationship());
            } else if (qName.equalsIgnoreCase("LinkTypeHistoryItem")) {
                this.objectStack.push(new LinkTypeHistoryItem());
            } else if (qName.equalsIgnoreCase("TermMergeHistoryItem")) {
                this.objectStack.push(new TermMergeHistoryItem());
            } else if (qName.equalsIgnoreCase("TermSplitHistoryItem")) {
                this.objectStack.push(new TermSplitHistoryItem());
            } else if (qName.equalsIgnoreCase("NameChangeHistoryItem")) {
                this.objectStack.push(new NameChangeHistoryItem());
            } else if (qName.equalsIgnoreCase("NamespaceHistoryItem")) {
                this.objectStack.push(new NamespaceHistoryItem());
            } else if (qName.equalsIgnoreCase("DefinitionChangeHistoryItem")) {
                this.objectStack.push(new DefinitionChangeHistoryItem());
            } else if (qName.equalsIgnoreCase("CommentChangeHistoryItem")) {
                this.objectStack.push(new CommentChangeHistoryItem());
            } else if (qName.equalsIgnoreCase("CategoryChangeHistoryItem")) {
                this.objectStack.push(new SubsetChangeHistoryItem());
            } else if (qName.equalsIgnoreCase("ChangeSynCategoryHistoryItem")) {
                this.objectStack.push(new ChangeSynTypeHistoryItem());
            } else if (qName.equalsIgnoreCase("ChangeSynScopeHistoryItem")) {
                this.objectStack.push(new ChangeSynScopeHistoryItem());
            } else if (qName.equalsIgnoreCase("TermMacroHistoryItem")) {
                this.objectStack.push(new TermMacroHistoryItem());
            } else if (qName.equalsIgnoreCase("Namespace")) {
                this.objectStack.push(new Namespace());
            } else if (qName.equalsIgnoreCase("Dbxref")) {
                this.objectStack.push(this.objectFactory.createDbxref("", "", "", -1, null));
            } else if (qName.equalsIgnoreCase("Synonym")) {
                this.objectStack.push(this.objectFactory.createSynonym("", 0));
            } else if (qName.equalsIgnoreCase("TermCategory")) {
                this.objectStack.push(this.objectFactory.createSubset("", ""));
            } else if (qName.equalsIgnoreCase("SynonymCategory")) {
                this.objectStack.push(this.objectFactory.createSynonymType("", "", -1));
            }
        }

        public String getString() {
            return this.buffer.toString().trim();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String namespaceURI, String localName, String qName) {
            try {
                String tagName = (String)this.tagStack.pop();
                if (!tagName.equalsIgnoreCase(qName)) {
                    logger.info((Object)("Something is very wrong, " + tagName + " does not match tag " + qName));
                }
                if (tagName.equalsIgnoreCase("user")) {
                    this.historyList.setUser(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("date")) {
                    this.historyList.setDate(new Date(this.getString()));
                    return;
                }
                if (tagName.equalsIgnoreCase("version")) {
                    this.historyList.setVersion(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("comment")) {
                    this.historyList.setComment(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("edithistory")) {
                    HistoryList hl = (HistoryList)this.objectStack.pop();
                    List parentList = null;
                    if (this.objectStack.size() > 0 && this.objectStack.peek() instanceof List) {
                        parentList = (List)this.objectStack.peek();
                    } else if (this.histories == null) {
                        this.histories = new Vector();
                        parentList = this.histories;
                    } else {
                        new Exception("Unexpected condition").printStackTrace();
                    }
                    logger.info((Object)("HISTORIES = " + this.histories));
                    parentList.add(hl);
                    return;
                }
                if (tagName.equalsIgnoreCase("head")) {
                    Object oldObj = this.objectStack.pop();
                    logger.info((Object)("peeked at object of type " + this.objectStack.peek().getClass()));
                    BasicLinkedList listNode = (BasicLinkedList)this.objectStack.peek();
                    listNode.setHead(oldObj);
                    return;
                }
                if (tagName.equalsIgnoreCase("tail")) {
                    Object oldObj = this.objectStack.pop();
                    Object peekObj = this.objectStack.peek();
                    logger.info((Object)("peekObj = " + peekObj + ", type = " + peekObj.getClass() + ", lineNum = " + (this.locator == null ? "?" : this.locator.getLineNumber() + "")));
                    BasicLinkedList listNode = (BasicLinkedList)peekObj;
                    listNode.setTail((BasicLinkedList)oldObj);
                    return;
                }
                if (tagName.equalsIgnoreCase("historyList")) {
                    Object oldObj = this.objectStack.pop();
                    Object parentObj = this.objectStack.peek();
                    HistoryList parentList = (HistoryList)parentObj;
                    for (BasicLinkedList list = (BasicLinkedList)oldObj; list != null; list = list.getTail()) {
                        logger.info((Object)("head = " + list.getHead().getClass()));
                        parentList.addItem((HistoryItem)list.getHead());
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("editlist")) {
                    Object oldObj = this.objectStack.pop();
                    Object parentObj = this.objectStack.peek();
                    TermMacroHistoryItem item = (TermMacroHistoryItem)parentObj;
                    for (BasicLinkedList list = (BasicLinkedList)oldObj; list != null; list = list.getTail()) {
                        item.addItem((HistoryItem)list.getHead());
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("desc")) {
                    Object oldObj = this.objectStack.peek();
                    TermMacroHistoryItem item = (TermMacroHistoryItem)oldObj;
                    item.setDescription(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("macroresult")) {
                    Object oldObj = this.objectStack.peek();
                    TermMacroHistoryItem item = (TermMacroHistoryItem)oldObj;
                    item.setResult(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("splitaddtype")) {
                    Object oldObj = this.objectStack.peek();
                    TermSplitHistoryItem item = (TermSplitHistoryItem)oldObj;
                    item.setAddType(this.getString().equalsIgnoreCase("true"));
                    return;
                }
                if (tagName.equalsIgnoreCase("splitresult")) {
                    Object oldObj = this.objectStack.peek();
                    TermSplitHistoryItem item = (TermSplitHistoryItem)oldObj;
                    item.setResult(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("syncatid")) {
                    SynonymType cat = (SynonymType)this.objectStack.peek();
                    cat.setID(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("syncatname")) {
                    SynonymType cat = (SynonymType)this.objectStack.peek();
                    cat.setName(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("syncatscope")) {
                    SynonymType cat = (SynonymType)this.objectStack.peek();
                    try {
                        int scope = Integer.parseInt(this.getString());
                        cat.setScope(scope);
                        return;
                    }
                    catch (NumberFormatException ex) {
                        logger.info((Object)("couldn't parse scope " + this.getString()));
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("oldSynCategory")) {
                    ChangeSynTypeHistoryItem item = (ChangeSynTypeHistoryItem)this.objectStack.peek();
                    item.setOldType(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("newSynCategory")) {
                    ChangeSynTypeHistoryItem item = (ChangeSynTypeHistoryItem)this.objectStack.peek();
                    item.setNewType(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("oldScope")) {
                    ChangeSynScopeHistoryItem item = (ChangeSynScopeHistoryItem)this.objectStack.peek();
                    try {
                        int scope = Integer.parseInt(this.getString());
                        item.setOldScope(scope);
                        return;
                    }
                    catch (Exception ex) {
                        logger.info((Object)("bad scope " + this.getString()));
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("newScope")) {
                    ChangeSynScopeHistoryItem item = (ChangeSynScopeHistoryItem)this.objectStack.peek();
                    try {
                        int scope = Integer.parseInt(this.getString());
                        item.setNewScope(scope);
                        return;
                    }
                    catch (Exception ex) {
                        logger.info((Object)("bad scope " + this.getString()));
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("oldcomment")) {
                    Object oldObj = this.objectStack.peek();
                    CommentChangeHistoryItem item = (CommentChangeHistoryItem)oldObj;
                    item.setOldText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("consider")) {
                    Object oldObj = this.objectStack.peek();
                    if (oldObj instanceof AddConsiderHistoryItem) {
                        AddConsiderHistoryItem item = (AddConsiderHistoryItem)oldObj;
                        item.setConsider(this.getString());
                        return;
                    } else {
                        if (!(oldObj instanceof RemoveConsiderHistoryItem)) return;
                        RemoveConsiderHistoryItem item = (RemoveConsiderHistoryItem)oldObj;
                        item.setConsider(this.getString());
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("replacedby")) {
                    Object oldObj = this.objectStack.peek();
                    if (oldObj instanceof AddReplacementHistoryItem) {
                        AddReplacementHistoryItem item = (AddReplacementHistoryItem)oldObj;
                        item.setReplace(this.getString());
                        return;
                    } else {
                        RemoveReplacementHistoryItem item = (RemoveReplacementHistoryItem)oldObj;
                        item.setReplace(this.getString());
                    }
                    return;
                }
                if (tagName.equalsIgnoreCase("newcomment")) {
                    Object oldObj = this.objectStack.peek();
                    CommentChangeHistoryItem item = (CommentChangeHistoryItem)oldObj;
                    item.setNewText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("oldtext")) {
                    Object oldObj = this.objectStack.peek();
                    NameChangeHistoryItem item = (NameChangeHistoryItem)oldObj;
                    item.setOldText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("newtext")) {
                    Object oldObj = this.objectStack.peek();
                    NameChangeHistoryItem item = (NameChangeHistoryItem)oldObj;
                    item.setNewText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("objectid")) {
                    CreateObjectHistoryItem item = (CreateObjectHistoryItem)this.objectStack.peek();
                    item.setObjectID(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("typeid")) {
                    CreateObjectHistoryItem item = (CreateObjectHistoryItem)this.objectStack.peek();
                    item.setTypeID(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("olddef")) {
                    Object oldObj = this.objectStack.peek();
                    DefinitionChangeHistoryItem item = (DefinitionChangeHistoryItem)oldObj;
                    item.setOldText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("newdef")) {
                    Object oldObj = this.objectStack.peek();
                    DefinitionChangeHistoryItem item = (DefinitionChangeHistoryItem)oldObj;
                    item.setNewText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("oldcat")) {
                    TermSubset cat = (TermSubset)this.objectStack.pop();
                    TermSubsetHistoryItem item = (TermSubsetHistoryItem)this.objectStack.peek();
                    item.setOldCat(cat);
                    return;
                }
                if (tagName.equalsIgnoreCase("newcat")) {
                    TermSubset cat = (TermSubset)this.objectStack.pop();
                    TermSubsetHistoryItem item = (TermSubsetHistoryItem)this.objectStack.peek();
                    item.setNewCat(cat);
                    return;
                }
                if (tagName.equalsIgnoreCase("catname")) {
                    TermSubset cat = (TermSubset)this.objectStack.peek();
                    cat.setName(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("catdesc")) {
                    TermSubset cat = (TermSubset)this.objectStack.peek();
                    cat.setDesc(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("syntext")) {
                    Synonym s = (Synonym)this.objectStack.peek();
                    s.setText(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("syntype")) {
                    Synonym s = (Synonym)this.objectStack.peek();
                    int type = 0;
                    String typeStr = this.getString();
                    if (typeStr.equals("Exact")) {
                        type = 1;
                    } else if (typeStr.equals("Narrow")) {
                        type = 2;
                    } else if (typeStr.equals("Broad")) {
                        type = 3;
                    }
                    s.setScope(type);
                    return;
                }
                if (tagName.equalsIgnoreCase("oldns")) {
                    Object oldObj = this.objectStack.peek();
                    NamespaceHistoryItem item = (NamespaceHistoryItem)oldObj;
                    item.setOldNamespace(new Namespace(this.getString(), null));
                    return;
                }
                if (tagName.equalsIgnoreCase("newns")) {
                    Object oldObj = this.objectStack.peek();
                    NamespaceHistoryItem item = (NamespaceHistoryItem)oldObj;
                    item.setNewNamespace(new Namespace(this.getString(), null));
                    return;
                }
                if (tagName.equalsIgnoreCase("category")) {
                    Object oldObj = this.objectStack.peek();
                    SubsetChangeHistoryItem item = (SubsetChangeHistoryItem)oldObj;
                    item.setCategory(this.getString());
                    return;
                }
                if (tagName.equalsIgnoreCase("oldCardinality")) {
                    Object oldObj = this.objectStack.peek();
                    CardinalityHistoryItem item = (CardinalityHistoryItem)oldObj;
                    Integer val = null;
                    try {
                        val = new Integer(this.getString());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    item.setOldValue(val);
                    return;
                }
                if (tagName.equalsIgnoreCase("newCardinality")) {
                    Object oldObj = this.objectStack.peek();
                    CardinalityHistoryItem item = (CardinalityHistoryItem)oldObj;
                    Integer val = null;
                    try {
                        val = new Integer(this.getString());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    item.setNewValue(val);
                    return;
                }
                if (tagName.equalsIgnoreCase("oldMaxCardinality")) {
                    Object oldObj = this.objectStack.peek();
                    MaxCardinalityHistoryItem item = (MaxCardinalityHistoryItem)oldObj;
                    Integer val = null;
                    try {
                        val = new Integer(this.getString());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    item.setOldValue(val);
                    return;
                }
                if (tagName.equalsIgnoreCase("newMaxCardinality")) {
                    Object oldObj = this.objectStack.peek();
                    MaxCardinalityHistoryItem item = (MaxCardinalityHistoryItem)oldObj;
                    Integer val = null;
                    try {
                        val = new Integer(this.getString());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    item.setNewValue(val);
                    return;
                }
                if (tagName.equalsIgnoreCase("oldMinCardinality")) {
                    Object oldObj = this.objectStack.peek();
                    MinCardinalityHistoryItem item = (MinCardinalityHistoryItem)oldObj;
                    Integer val = null;
                    try {
                        val = new Integer(this.getString());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    item.setOldValue(val);
                    return;
                }
                if (tagName.equalsIgnoreCase("newMinCardinality")) {
                    Object oldObj = this.objectStack.peek();
                    MinCardinalityHistoryItem item = (MinCardinalityHistoryItem)oldObj;
                    Integer val = null;
                    try {
                        val = new Integer(this.getString());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    item.setNewValue(val);
                    return;
                }
                if (tagName.equalsIgnoreCase("iscatdel")) {
                    Object oldObj = this.objectStack.peek();
                    TermSubsetHistoryItem item = (TermSubsetHistoryItem)oldObj;
                    item.setIsDel(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("iscatadd")) {
                    Object oldObj = this.objectStack.peek();
                    TermSubsetHistoryItem item = (TermSubsetHistoryItem)oldObj;
                    item.setIsAdd(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("issyncatadd")) {
                    Object oldObj = this.objectStack.peek();
                    SynonymTypeHistoryItem item = (SynonymTypeHistoryItem)oldObj;
                    item.setIsAdd(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("issyncatdel")) {
                    Object oldObj = this.objectStack.peek();
                    SynonymTypeHistoryItem item = (SynonymTypeHistoryItem)oldObj;
                    item.setIsDel(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldsyncat")) {
                    SynonymType synCat = (SynonymType)this.objectStack.pop();
                    Object oldObj = this.objectStack.peek();
                    SynonymTypeHistoryItem item = (SynonymTypeHistoryItem)oldObj;
                    item.setOldCat(synCat);
                    return;
                } else if (tagName.equalsIgnoreCase("newsyncat")) {
                    SynonymType synCat = (SynonymType)this.objectStack.pop();
                    Object oldObj = this.objectStack.peek();
                    SynonymTypeHistoryItem item = (SynonymTypeHistoryItem)oldObj;
                    item.setNewCat(synCat);
                    return;
                } else if (tagName.equalsIgnoreCase("istermcatdel")) {
                    Object oldObj = this.objectStack.peek();
                    SubsetChangeHistoryItem item = (SubsetChangeHistoryItem)oldObj;
                    item.setIsDel(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("isNamespaceAdd")) {
                    Object oldObj = this.objectStack.peek();
                    TermNamespaceHistoryItem item = (TermNamespaceHistoryItem)oldObj;
                    item.setIsAdd(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("isNamespaceDel")) {
                    Object oldObj = this.objectStack.peek();
                    TermNamespaceHistoryItem item = (TermNamespaceHistoryItem)oldObj;
                    item.setIsDel(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldnamespace")) {
                    Object oldObj = this.objectStack.peek();
                    TermNamespaceHistoryItem item = (TermNamespaceHistoryItem)oldObj;
                    item.setOldID(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("newnamespace")) {
                    Object oldObj = this.objectStack.peek();
                    TermNamespaceHistoryItem item = (TermNamespaceHistoryItem)oldObj;
                    item.setNewID(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("oldNecessary")) {
                    NecessarilyTrueHistoryItem item = (NecessarilyTrueHistoryItem)this.objectStack.peek();
                    item.setOldNecessary(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldInvNecessary")) {
                    InverseNecHistoryItem item = (InverseNecHistoryItem)this.objectStack.peek();
                    item.setOldInverseNec(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldcompletes")) {
                    CompletesHistoryItem item = (CompletesHistoryItem)this.objectStack.peek();
                    item.setOldCompletes(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldcyclic")) {
                    CyclicHistoryItem item = (CyclicHistoryItem)this.objectStack.peek();
                    item.setOldCyclic(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldtransitive")) {
                    TransitiveHistoryItem item = (TransitiveHistoryItem)this.objectStack.peek();
                    item.setOldTransitive(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("oldsymmetric")) {
                    SymmetricHistoryItem item = (SymmetricHistoryItem)this.objectStack.peek();
                    item.setOldSymmetric(this.getString().equalsIgnoreCase("true"));
                    logger.info((Object)("got set old symmetric = " + item.getOldSymmetric()));
                    return;
                } else if (tagName.equalsIgnoreCase("isDef")) {
                    boolean isDef = this.getString().equalsIgnoreCase("true");
                    HistoryItem item = (HistoryItem)this.objectStack.peek();
                    if (item instanceof AddDbxrefHistoryItem) {
                        ((AddDbxrefHistoryItem)item).setDef(isDef);
                        return;
                    } else {
                        if (!(item instanceof DelDbxrefHistoryItem)) return;
                        ((DelDbxrefHistoryItem)item).setDef(isDef);
                    }
                    return;
                } else if (tagName.equalsIgnoreCase("target_xref")) {
                    Dbxref ref = (Dbxref)this.objectStack.pop();
                    HistoryItem item = (HistoryItem)this.objectStack.peek();
                    if (item instanceof AddDbxrefHistoryItem) {
                        ((AddDbxrefHistoryItem)item).setDbxref(ref);
                        return;
                    } else {
                        if (!(item instanceof DelDbxrefHistoryItem)) return;
                        ((DelDbxrefHistoryItem)item).setDbxref(ref);
                    }
                    return;
                } else if (tagName.equalsIgnoreCase("target_synonym")) {
                    String syn = this.getString();
                    HistoryItem item = (HistoryItem)this.objectStack.peek();
                    if (item instanceof AddDbxrefHistoryItem) {
                        ((AddDbxrefHistoryItem)item).setSynonym(syn);
                        return;
                    } else {
                        if (!(item instanceof DelDbxrefHistoryItem)) return;
                        ((DelDbxrefHistoryItem)item).setSynonym(syn);
                    }
                    return;
                } else if (tagName.equalsIgnoreCase("secondarydelete")) {
                    SecondaryIDHistoryItem item = (SecondaryIDHistoryItem)this.objectStack.peek();
                    item.setDelete(this.getString().equalsIgnoreCase("true"));
                    return;
                } else if (tagName.equalsIgnoreCase("secondaryid")) {
                    SecondaryIDHistoryItem item = (SecondaryIDHistoryItem)this.objectStack.peek();
                    item.setSecondaryID(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("slave")) {
                    TermMergeHistoryItem item = (TermMergeHistoryItem)this.objectStack.peek();
                    item.setSlave(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("domain")) {
                    DomainHistoryItem item = (DomainHistoryItem)this.objectStack.peek();
                    item.setDomain(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("olddomain")) {
                    DomainHistoryItem item = (DomainHistoryItem)this.objectStack.peek();
                    item.setOldDomain(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("oldtrns")) {
                    TRNamespaceHistoryItem item = (TRNamespaceHistoryItem)this.objectStack.peek();
                    item.setOldNamespace(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("newtrns")) {
                    TRNamespaceHistoryItem item = (TRNamespaceHistoryItem)this.objectStack.peek();
                    item.setNewNamespace(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("range")) {
                    RangeHistoryItem item = (RangeHistoryItem)this.objectStack.peek();
                    item.setRange(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("oldrange")) {
                    RangeHistoryItem item = (RangeHistoryItem)this.objectStack.peek();
                    item.setOldRange(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("newtype")) {
                    LinkTypeHistoryItem item = (LinkTypeHistoryItem)this.objectStack.peek();
                    item.setRelType(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("target")) {
                    Object oldObj = this.objectStack.peek();
                    if (!(oldObj instanceof HistoryItem)) return;
                    HistoryItem item = (HistoryItem)oldObj;
                    item.setTarget(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("synonym_edit_target")) {
                    Object oldObj = this.objectStack.peek();
                    if (oldObj instanceof AddSynonymHistoryItem) {
                        ((AddSynonymHistoryItem)oldObj).setSynonym(this.getString());
                        return;
                    } else if (oldObj instanceof DelSynonymHistoryItem) {
                        ((DelSynonymHistoryItem)oldObj).setSynonym(this.getString());
                        return;
                    } else if (oldObj instanceof ChangeSynScopeHistoryItem) {
                        ((ChangeSynScopeHistoryItem)oldObj).setSynonym(this.getString());
                        return;
                    } else {
                        if (!(oldObj instanceof ChangeSynTypeHistoryItem)) throw new RuntimeException("unexpected condition encountered!");
                        ((ChangeSynTypeHistoryItem)oldObj).setSynonym(this.getString());
                    }
                    return;
                } else if (tagName.equalsIgnoreCase("sourcerel")) {
                    Object oldObj = this.objectStack.pop();
                    StringRelationship rel = (StringRelationship)oldObj;
                    if (this.objectStack.peek() instanceof TermMoveHistoryItem) {
                        TermMoveHistoryItem item = (TermMoveHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof DeleteLinkHistoryItem) {
                        DeleteLinkHistoryItem item = (DeleteLinkHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof CardinalityHistoryItem) {
                        CardinalityHistoryItem item = (CardinalityHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof MaxCardinalityHistoryItem) {
                        MaxCardinalityHistoryItem item = (MaxCardinalityHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof MinCardinalityHistoryItem) {
                        MinCardinalityHistoryItem item = (MinCardinalityHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof CompletesHistoryItem) {
                        CompletesHistoryItem item = (CompletesHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof TRNamespaceHistoryItem) {
                        TRNamespaceHistoryItem item = (TRNamespaceHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof InverseNecHistoryItem) {
                        InverseNecHistoryItem item = (InverseNecHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else if (this.objectStack.peek() instanceof NecessarilyTrueHistoryItem) {
                        NecessarilyTrueHistoryItem item = (NecessarilyTrueHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                        return;
                    } else {
                        if (!(this.objectStack.peek() instanceof LinkTypeHistoryItem)) throw new RuntimeException("found <sourcerel> tag for inappropriate history item: " + this.objectStack.peek());
                        LinkTypeHistoryItem item = (LinkTypeHistoryItem)this.objectStack.peek();
                        item.setRel(rel);
                    }
                    return;
                } else if (tagName.equalsIgnoreCase("database")) {
                    Object oldObj = this.objectStack.peek();
                    Dbxref dbx = (Dbxref)oldObj;
                    dbx.setDatabase(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("dbxrefid")) {
                    Object oldObj = this.objectStack.peek();
                    Dbxref dbx = (Dbxref)oldObj;
                    dbx.setDatabaseID(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("dbxrefdesc")) {
                    Object oldObj = this.objectStack.peek();
                    Dbxref dbx = (Dbxref)oldObj;
                    dbx.setDesc(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("dbxreftype")) {
                    Object oldObj = this.objectStack.peek();
                    Dbxref dbx = (Dbxref)oldObj;
                    String str = this.getString();
                    int type = -1;
                    if (str.equals("anatomical")) {
                        type = 0;
                    } else if (str.equals("synonym")) {
                        type = 1;
                    } else if (str.equals("definition")) {
                        type = 2;
                    } else if (str.equals("analog")) {
                        type = 3;
                    }
                    dbx.setType(type);
                    return;
                } else if (tagName.equalsIgnoreCase("child")) {
                    Object oldObj = this.objectStack.peek();
                    StringRelationship rel = (StringRelationship)oldObj;
                    rel.setChild(this.getString());
                    return;
                } else if (tagName.equalsIgnoreCase("parent")) {
                    Object oldObj = this.objectStack.peek();
                    if (oldObj instanceof StringRelationship) {
                        StringRelationship rel = (StringRelationship)oldObj;
                        rel.setParent(this.getString());
                        return;
                    } else {
                        if (!(oldObj instanceof CreateLinkHistoryItem)) return;
                        ((CreateLinkHistoryItem)oldObj).setParentID(this.getString());
                    }
                    return;
                } else {
                    if (!tagName.equalsIgnoreCase("type")) return;
                    Object oldObj = this.objectStack.peek();
                    if (oldObj instanceof StringRelationship) {
                        StringRelationship rel = (StringRelationship)oldObj;
                        rel.setType(this.getString());
                        return;
                    } else {
                        if (!(oldObj instanceof CreateLinkHistoryItem)) return;
                        ((CreateLinkHistoryItem)oldObj).setTypeID(this.getString());
                    }
                }
                return;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }

        public void endDocument() {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void processingInstruction(String target, String data) {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void skippedEntity(String name) {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }
    }

    protected static class BasicLinkedList {
        Object head;
        BasicLinkedList tail;
        static int idgen = 0;
        int id = idgen++;

        protected BasicLinkedList() {
        }

        public Object getHead() {
            return this.head;
        }

        public BasicLinkedList getTail() {
            return this.tail;
        }

        public void setHead(Object head) {
            this.head = head;
        }

        public void setTail(BasicLinkedList tail) {
            this.tail = tail;
        }

        public String toString() {
            return "BasicLinkedList id " + this.id;
        }
    }
}

