/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinkDatabase
extends AbstractLinkDatabase
implements LinkDatabase {
    protected static final Logger logger = Logger.getLogger(DefaultLinkDatabase.class);
    private static final long serialVersionUID = -7732358173697641038L;
    protected static final LinkDatabase defaultDatabase = new DefaultLinkDatabase(null);

    public static LinkDatabase getDefault() {
        return defaultDatabase;
    }

    public DefaultLinkDatabase(OBOSession session) {
        this.session = session;
        if (session != null) {
            this.properties = TermUtil.getProperties(session);
        }
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.session == null) {
            return Collections.EMPTY_SET;
        }
        return this.session.getObjects();
    }

    @Override
    public Collection<OBOProperty> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = TermUtil.getProperties(this.session);
        return this.properties;
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        return lo.getChildren();
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        return lo.getParents();
    }

    @Override
    public IdentifiedObject getObject(String id) {
        return this.session.getObject(id);
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        return !lo.getChildren().isEmpty();
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        return !lo.getParents().isEmpty();
    }
}

