/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.logging.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.IdentifiedObjectIndex;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MutableLinkDatabase;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.datamodel.impl.DefaultMutableLinkDatabase;
import org.obo.datamodel.impl.SQLBackedMutableLinkDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedCacheMutableLinkDatabase
extends AbstractLinkDatabase
implements MutableLinkDatabase {
    protected DefaultMutableLinkDatabase cacheDatabase = new DefaultMutableLinkDatabase(true, true);
    protected MutableLinkDatabase storeDatabase;
    protected int preferredSize = 1000;
    protected int flushSize = 2000;
    protected int maxSize = 3000;
    protected int parentsCached = 0;
    protected FlushThread flushThread;
    protected boolean useFlushThread;

    public FixedCacheMutableLinkDatabase(IdentifiedObjectIndex index, boolean useFlushThread) {
        this(new SQLBackedMutableLinkDatabase(index), useFlushThread);
    }

    public FixedCacheMutableLinkDatabase(MutableLinkDatabase storeDatabase, boolean useFlushThread) {
        this.storeDatabase = storeDatabase;
        this.setUseFlushThread(useFlushThread);
    }

    public void setUseFlushThread(boolean useFlushThread) {
        this.useFlushThread = useFlushThread;
    }

    @Override
    public void addObject(IdentifiedObject lo) {
        this.cacheDatabase.addObject(lo);
        this.flushIfNecessary();
    }

    protected synchronized void flushLRU() {
        LinkedObject lo = this.cacheDatabase.getLeastRecentlyAccessedLinkKey();
        Collection<Link> parents = this.cacheDatabase.getParents(lo);
        int parentsCount = parents.size();
        this.storeDatabase.setParents(lo, parents);
        this.cacheDatabase.dropLinkKey(lo);
        this.parentsCached -= parentsCount;
        Logger.getLogger("").warning("flushed " + lo + " out of memory to reduce cache size to " + this.parentsCached);
    }

    protected synchronized void flushIfNecessary() {
        if (this.parentsCached > this.maxSize) {
            if (this.flushThread != null) {
                this.flushThread.cancel();
            }
            this.flushThread = null;
            while (this.parentsCached > this.preferredSize) {
                LinkedObject lo = this.cacheDatabase.getLeastRecentlyAccessedLinkKey();
                Collection<Link> parents = this.cacheDatabase.getParents(lo);
                int parentsCount = parents.size();
                this.storeDatabase.setParents(lo, parents);
                this.cacheDatabase.dropLinkKey(lo);
                Collection<Link> newParents = this.getParents(lo);
                this.parentsCached -= parentsCount;
            }
        } else if (this.useFlushThread && this.parentsCached > this.flushSize && this.flushThread == null) {
            this.flushThread = new FlushThread();
            this.flushThread.start();
        }
    }

    @Override
    public synchronized void addParent(Link link) {
        this.cacheDatabase.addParent(link);
        ++this.parentsCached;
        this.flushIfNecessary();
    }

    @Override
    public synchronized void clear() {
        this.cacheDatabase.clear();
        this.storeDatabase.clear();
        this.parentsCached = 0;
    }

    @Override
    public synchronized void clearParents(LinkedObject lo) {
        Collection<Link> parents = this.getParents(lo);
        this.cacheDatabase.clearParents(lo);
        this.storeDatabase.clearParents(lo);
        this.parentsCached -= parents.size();
    }

    @Override
    public void removeObject(IdentifiedObject lo) {
        this.cacheDatabase.removeObject(lo);
        this.storeDatabase.removeObject(lo);
    }

    @Override
    public synchronized void removeParent(Link link) {
        this.cacheDatabase.removeParent(link);
        this.storeDatabase.removeParent(link);
        --this.parentsCached;
    }

    @Override
    public void setIdentifiedObjectIndex(IdentifiedObjectIndex index) {
        this.cacheDatabase.setIdentifiedObjectIndex(index);
        this.storeDatabase.setIdentifiedObjectIndex(index);
    }

    @Override
    public synchronized void setParents(LinkedObject lo, Collection<Link> parents) {
        Collection<Link> oldparents = this.getParents(lo);
        this.cacheDatabase.setParents(lo, parents);
        this.parentsCached += parents.size() - oldparents.size();
        this.flushIfNecessary();
    }

    @Override
    public synchronized Collection<Link> getChildren(LinkedObject lo) {
        Collection<Link> children = this.cacheDatabase.getChildren(lo);
        if (children == null) {
            children = this.storeDatabase.getChildren(lo);
            for (Link link : children) {
                this.cacheDatabase.addParent(link);
            }
            this.flushIfNecessary();
        }
        return children;
    }

    @Override
    public synchronized Collection<IdentifiedObject> getObjects() {
        return this.cacheDatabase.getObjects();
    }

    @Override
    public synchronized Collection<Link> getParents(LinkedObject lo) {
        Collection<Link> parents = this.cacheDatabase.getParents(lo);
        if (parents == null) {
            parents = this.storeDatabase.getParents(lo);
            for (Link link : parents) {
                this.cacheDatabase.addParent(link);
            }
            this.flushIfNecessary();
        }
        return parents;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        return this.cacheDatabase.getObject(id);
    }

    public int getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(int preferredSize) {
        this.preferredSize = preferredSize;
    }

    public int getFlushSize() {
        return this.flushSize;
    }

    public void setFlushSize(int flushSize) {
        this.flushSize = flushSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        return this.cacheDatabase.hasChildren(lo) || this.storeDatabase.hasChildren(lo);
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        return this.cacheDatabase.hasParents(lo) || this.storeDatabase.hasParents(lo);
    }

    protected class FlushThread
    extends Thread {
        public static final long SLEEP_TIME = 100L;
        protected boolean cancelled = false;
        protected final Logger logger = Logger.getLogger("");

        protected FlushThread() {
        }

        public void cancel() {
            this.cancelled = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FixedCacheMutableLinkDatabase.this.flushThread = null;
        }

        public void run() {
            while (FixedCacheMutableLinkDatabase.this.parentsCached > FixedCacheMutableLinkDatabase.this.preferredSize) {
                if (this.cancelled) {
                    return;
                }
                FixedCacheMutableLinkDatabase.this.flushLRU();
                if (this.cancelled) {
                    return;
                }
                try {
                    FlushThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

