/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import org.apache.log4j.Logger;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.impl.IntegerDatatype;

public class NegativeIntegerDatatype
extends IntegerDatatype {
    protected static final Logger logger = Logger.getLogger(NegativeIntegerDatatype.class);
    private static final long serialVersionUID = 6094346806278269220L;

    public String getID() {
        return "xsd:negativeInteger";
    }

    public String getName() {
        return this.getID();
    }

    public String getComment() {
        return "Represents a negative integer";
    }

    public Namespace getNamespace() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public Datatype getSupertype() {
        return Datatype.INTEGER;
    }

    public boolean isLegalValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            int val = Integer.parseInt(string);
            return val < 0;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Integer getValue(String string) {
        if (string == null) {
            return null;
        }
        try {
            Integer val = new Integer(string);
            if (val >= 0) {
                throw new IllegalArgumentException("Negative integers must be < 0");
            }
            return val;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Illegal negative integer value " + string);
        }
    }

    public String getString(Integer o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            int val = o;
            if (val >= 0) {
                throw new IllegalArgumentException("Negative integers must be < 0");
            }
            return o.toString();
        }
        throw new IllegalArgumentException("NegativeIntegerDatatype can only convert values of type java.lang.Integer java.lang.Long");
    }
}

