/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Type;
import org.obo.datamodel.impl.LinkedAnnotatedObjectImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOPropertyImpl
extends LinkedAnnotatedObjectImpl
implements OBOProperty {
    protected static final Logger logger = Logger.getLogger(OBOPropertyImpl.class);
    private static final long serialVersionUID = 1781810097216245117L;
    protected Type range;
    protected IdentifiedObject domain;
    protected NestedValue domainExtension;
    protected NestedValue rangeExtension;
    protected NestedValue cyclicExtension;
    protected NestedValue symmetricExtension;
    protected NestedValue transitiveExtension;
    protected NestedValue reflexiveExtension;
    protected NestedValue alwaysImpliesInverseExtension;
    protected boolean cyclic;
    protected boolean symmetric;
    protected boolean transitive;
    protected boolean reflexive;
    protected boolean alwaysImpliesInverse;
    protected boolean universallyQuantified;
    protected boolean isMetadataTag;
    protected OBOProperty transitiveOver;
    protected Collection<List<OBOProperty>> holdsOverChains;
    protected Set categories;
    protected HashMap categoryExtensionHash;

    @Override
    public void addCategoryExtension(TermSubset category, NestedValue nv) {
        if (this.categoryExtensionHash == null) {
            this.categoryExtensionHash = new HashMap();
        }
        this.categoryExtensionHash.put(category, nv);
    }

    @Override
    public NestedValue getCategoryExtension(TermSubset category) {
        if (this.categoryExtensionHash == null) {
            return null;
        }
        return (NestedValue)this.categoryExtensionHash.get(category);
    }

    @Override
    public void addCategory(TermSubset category) {
        this.categories.add(category);
    }

    @Override
    public void removeCategory(TermSubset category) {
        this.categories.remove(category);
    }

    @Override
    public boolean isNonInheritable() {
        return this.isMetadataTag;
    }

    @Override
    public Set getSubsets() {
        return this.categories;
    }

    public OBOPropertyImpl(String id, String name) {
        super(id);
        this.name = name;
        this.categories = new HashSet();
    }

    public OBOPropertyImpl(String id) {
        super(id);
        this.categories = new HashSet();
    }

    @Override
    public String toString() {
        if (this.id.equals(this.name)) {
            return this.id;
        }
        return super.toString();
    }

    @Override
    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    @Override
    public void setSymmetric(boolean symmetric) {
        this.symmetric = symmetric;
    }

    @Override
    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    @Override
    public void setReflexive(boolean reflexive) {
        this.reflexive = reflexive;
    }

    @Override
    public boolean isReflexive() {
        return this.reflexive;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isSymmetric() {
        return this.symmetric;
    }

    @Override
    public boolean isCyclic() {
        return this.cyclic;
    }

    public Type getType() {
        return OBOClass.OBO_PROPERTY;
    }

    @Override
    public NestedValue getCyclicExtension() {
        return this.cyclicExtension;
    }

    @Override
    public NestedValue getSymmetricExtension() {
        return this.symmetricExtension;
    }

    @Override
    public NestedValue getTransitiveExtension() {
        return this.transitiveExtension;
    }

    @Override
    public NestedValue getReflexiveExtension() {
        return this.reflexiveExtension;
    }

    @Override
    public void setReflexiveExtension(NestedValue nv) {
        this.reflexiveExtension = nv;
    }

    @Override
    public void setCyclicExtension(NestedValue nv) {
        this.cyclicExtension = nv;
    }

    @Override
    public void setSymmetricExtension(NestedValue nv) {
        this.symmetricExtension = nv;
    }

    @Override
    public void setTransitiveExtension(NestedValue nv) {
        this.transitiveExtension = nv;
    }

    @Override
    public NestedValue getDomainExtension() {
        return this.domainExtension;
    }

    @Override
    public NestedValue getRangeExtension() {
        return this.rangeExtension;
    }

    @Override
    public void setRangeExtension(NestedValue rangeExtension) {
        this.rangeExtension = rangeExtension;
    }

    @Override
    public void setDomainExtension(NestedValue domainExtension) {
        this.domainExtension = domainExtension;
    }

    @Override
    public void setRange(Type range) {
        this.range = range;
    }

    @Override
    public void setDomain(IdentifiedObject domain) {
        this.domain = domain;
    }

    @Override
    public Type getRange() {
        return this.range;
    }

    @Override
    public IdentifiedObject getDomain() {
        return this.domain;
    }

    @Override
    public NestedValue getAlwaysImpliesInverseExtension() {
        return this.alwaysImpliesInverseExtension;
    }

    @Override
    public void setAlwaysImpliesInverseExtension(NestedValue alwaysImpliesInverseExtension) {
        this.alwaysImpliesInverseExtension = alwaysImpliesInverseExtension;
    }

    @Override
    public boolean isAlwaysImpliesInverse() {
        return this.alwaysImpliesInverse;
    }

    @Override
    public void setAlwaysImpliesInverse(boolean alwaysImpliesInverse) {
        this.alwaysImpliesInverse = alwaysImpliesInverse;
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public OBOProperty getTransitiveOver() {
        for (Link link : this.getParents()) {
            if (!link.getType().getID().equals("transitive_over")) continue;
            return (OBOProperty)link.getParent();
        }
        return null;
    }

    @Override
    public void setTransitiveOver(OBOProperty transitiveOver) {
        OBORestrictionImpl link = new OBORestrictionImpl();
        link.setChild(this);
        link.setType(OBOProperty.TRANSITIVE_OVER);
        link.setParent(transitiveOver);
        this.addParent(link);
    }

    @Override
    public OBOProperty getDisjointOver() {
        for (Link link : this.getParents()) {
            if (!link.getType().getID().equals("disjoint_over")) continue;
            return (OBOProperty)link.getParent();
        }
        return null;
    }

    @Override
    public void setDisjointOver(OBOProperty disjointOver) {
        OBORestrictionImpl link = new OBORestrictionImpl();
        link.setChild(this);
        link.setType(OBOProperty.DISJOINT_OVER);
        link.setParent(disjointOver);
        this.addParent(link);
    }

    @Override
    public Collection<List<OBOProperty>> getHoldsOverChains() {
        return this.holdsOverChains;
    }

    @Override
    public void setHoldsOverChains(Collection<List<OBOProperty>> holdsOverChains) {
        this.holdsOverChains = holdsOverChains;
    }

    @Override
    public void addHoldsOverChain(List<OBOProperty> holdsOverChain) {
        if (this.holdsOverChains == null) {
            this.holdsOverChains = new HashSet<List<OBOProperty>>();
        }
        this.holdsOverChains.add(holdsOverChain);
    }

    @Override
    public boolean isUniversallyQuantified() {
        return this.universallyQuantified;
    }

    @Override
    public void setUniversallyQuantified(boolean universallyQuantified) {
        this.universallyQuantified = universallyQuantified;
    }

    @Override
    public boolean isMetadataTag() {
        return this.isMetadataTag;
    }

    @Override
    public void setMetadataTag(boolean isMetadataTag) {
        this.isMetadataTag = isMetadataTag;
    }
}

