/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.RootAlgorithm;
import org.obo.datamodel.impl.MaskedLinkDatabase;

public class RootAlgorithmModeratedLinkDatabase
extends MaskedLinkDatabase {
    protected static final Logger logger = Logger.getLogger(RootAlgorithmModeratedLinkDatabase.class);
    private static final long serialVersionUID = -3138882841659656930L;
    protected RootAlgorithm rootAlgorithm;
    protected static final Object NONE = new Object();

    public RootAlgorithmModeratedLinkDatabase() {
    }

    public RootAlgorithmModeratedLinkDatabase(LinkDatabase linkDatabase) {
        this(linkDatabase, null);
    }

    public RootAlgorithmModeratedLinkDatabase(LinkDatabase linkDatabase, RootAlgorithm rootAlgorithm) {
        super(linkDatabase);
        this.setRootAlgorithm(rootAlgorithm);
        this.recache();
    }

    public void setRootAlgorithm(RootAlgorithm rootAlgorithm) {
        this.rootAlgorithm = rootAlgorithm;
    }

    public RootAlgorithm getRootAlgorithm() {
        return this.rootAlgorithm;
    }

    public void recache() {
        super.recache();
        for (IdentifiedObject io : this.linkDatabase.getObjects()) {
            LinkedObject lo;
            if (!(io instanceof LinkedObject) || !this.rootAlgorithm.isRoot(lo = (LinkedObject)io)) continue;
            this.cacheObject(lo);
        }
    }

    protected void cacheObject(LinkedObject lo) {
        this.setVisible(lo, true);
        for (Link link : this.linkDatabase.getChildren(lo)) {
            this.cacheObject(link.getChild());
        }
    }
}

