/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;

public class SynonymImpl
implements Synonym {
    protected static final Logger logger = Logger.getLogger(SynonymImpl.class);
    private static final long serialVersionUID = 45485650012520403L;
    protected String text;
    protected Set references;
    protected int scope;
    protected SynonymType syntype;
    protected String privateid;
    private static int idgen = 0;
    protected NestedValue nestedValue;

    public SynonymImpl() {
        this(null);
    }

    public SynonymImpl(String text) {
        this(text, 0);
    }

    public SynonymImpl(String text, int scope) {
        this.setScope(scope);
        this.text = text;
        this.privateid = "" + idgen++;
        this.references = new HashSet();
    }

    public SynonymImpl(String text, int scope, SynonymType syntype) {
        this.setSynonymType(syntype);
        this.setScope(scope);
        this.text = text;
        this.privateid = "" + idgen++;
        this.references = new HashSet();
    }

    public String getID() {
        return this.privateid;
    }

    public boolean isAnonymous() {
        return true;
    }

    public SynonymType getSynonymType() {
        return this.syntype;
    }

    public void setSynonymType(SynonymType syntype) {
        this.syntype = syntype;
    }

    public void setNestedValue(NestedValue nestedValue) {
        this.nestedValue = nestedValue;
    }

    public NestedValue getNestedValue() {
        return this.nestedValue;
    }

    public int getScope() {
        if (this.syntype == null || this.syntype.getScope() == -1) {
            return this.scope;
        }
        return this.syntype.getScope();
    }

    public void setScope(int scope) {
        if (scope == -1) {
            throw new IllegalArgumentException("Cannot set synonym scope to UNKNOWN_SCOPE");
        }
        this.scope = scope;
    }

    public void addXref(Dbxref ref) {
        if (!this.references.contains(ref)) {
            this.references.add(ref);
        }
    }

    public void removeXref(Dbxref ref) {
        this.references.remove(ref);
    }

    public Set getXrefs() {
        return this.references;
    }

    public void setDbxrefs(Set references) {
        this.references = references;
    }

    public Object clone() {
        try {
            Synonym s = (Synonym)super.clone();
            ((SynonymImpl)s).references = new HashSet();
            for (Dbxref ref : this.references) {
                s.addXref((Dbxref)ref.clone());
            }
            return s;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int compareTo(Object o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (o instanceof Synonym) {
            Synonym in = (Synonym)o;
            return ObjectUtil.equals((Object)this.text, (Object)in.getText()) && ObjectUtil.equals((Object)this.syntype, (Object)in.getSynonymType()) && this.scope == in.getScope() && ((Object)in.getXrefs()).equals(this.references);
        }
        return false;
    }
}

