/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.TinySet;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.Type;
import org.obo.datamodel.UnknownStanza;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.datamodel.impl.DefaultOperationModel;
import org.obo.history.HistoryItem;
import org.obo.history.OperationModel;
import org.obo.history.SessionHistoryList;
import org.obo.identifier.IDProfile;
import org.obo.query.QueryResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteCachedOBOSession
implements OBOSession {
    protected static final Logger logger = Logger.getLogger(WriteCachedOBOSession.class);
    protected SessionHistoryList currentHistory;
    protected Collection<TermSubset> categories;
    protected Collection<SynonymType> synonymCategories;
    protected Collection<Namespace> namespaces;
    protected Namespace defaultNamespace;
    protected ObjectFactory objectFactory;
    protected OperationModel operationModel = new DefaultOperationModel(){

        protected IdentifiedObject getRealIDObject(String term) {
            return WriteCachedOBOSession.this.getCachedObject(term, true);
        }
    };
    protected LinkDatabase linkDatabase = new AbstractLinkDatabase(){

        @Override
        public Collection<Link> getChildren(LinkedObject lo) {
            lo = (LinkedObject)this.getObject(lo.getID());
            LinkedList<Link> out = new LinkedList<Link>();
            for (Link link : lo.getChildren()) {
                if (WriteCachedOBOSession.this.cachedIDHash.containsKey(link.getChild().getID()) || WriteCachedOBOSession.this.cachedIDHash.containsKey(link.getParent().getID()) || WriteCachedOBOSession.this.cachedIDHash.containsKey(link.getType())) {
                    Link olink = (Link)link.clone();
                    olink.setParent((LinkedObject)this.getObject(link.getParent().getID()));
                    olink.setChild((LinkedObject)this.getObject(link.getChild().getID()));
                    olink.setType((OBOProperty)this.getObject(link.getType().getID()));
                    out.add(olink);
                    continue;
                }
                out.add(link);
            }
            return out;
        }

        @Override
        public Collection<Link> getParents(LinkedObject lo) {
            lo = (LinkedObject)WriteCachedOBOSession.this.getUnwrappedObject(lo.getID());
            LinkedList<Link> out = new LinkedList<Link>();
            for (Link link : lo.getParents()) {
                if (WriteCachedOBOSession.this.cachedIDHash.containsKey(link.getChild().getID()) || WriteCachedOBOSession.this.cachedIDHash.containsKey(link.getParent().getID()) || WriteCachedOBOSession.this.cachedIDHash.containsKey(link.getType())) {
                    Link olink = (Link)link.clone();
                    olink.setParent((LinkedObject)WriteCachedOBOSession.this.getUnwrappedObject(link.getParent().getID()));
                    olink.setChild((LinkedObject)WriteCachedOBOSession.this.getUnwrappedObject(link.getChild().getID()));
                    olink.setType((OBOProperty)WriteCachedOBOSession.this.getUnwrappedObject(link.getType().getID()));
                    out.add(olink);
                    continue;
                }
                out.add(link);
            }
            return out;
        }

        @Override
        public Collection<IdentifiedObject> getObjects() {
            return WriteCachedOBOSession.this.getObjects();
        }

        @Override
        public IdentifiedObject getObject(String id) {
            return WriteCachedOBOSession.this.getUnwrappedObject(id);
        }
    };
    protected OBOSession session;
    protected IDProfile profile;
    protected Map<String, String> idspaceToUri = new HashMap<String, String>();
    protected String loadRemark;
    protected Map<String, IdentifiedObject> cachedIDHash;
    protected Collection<String> destroyedObjects;
    protected Collection<IdentifiedObject> objects = new AbstractCollection<IdentifiedObject>(){

        @Override
        public boolean contains(Object o) {
            if (o instanceof IdentifiedObject) {
                IdentifiedObject io = (IdentifiedObject)o;
                if (WriteCachedOBOSession.this.cachedIDHash.containsKey(io.getID())) {
                    return true;
                }
                return !WriteCachedOBOSession.this.destroyedObjects.contains(io.getID()) && WriteCachedOBOSession.this.session.getObject(io.getID()) != null;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return WriteCachedOBOSession.this.cachedIDHash.size() == 0 && WriteCachedOBOSession.this.session.getObjects().size() == 0;
        }

        @Override
        public Iterator<IdentifiedObject> iterator() {
            return new Iterator<IdentifiedObject>(){
                protected IdentifiedObject next;
                protected Iterator<IdentifiedObject> cacheIterator;
                protected Iterator<IdentifiedObject> sessionIterator;
                {
                    this.cacheIterator = WriteCachedOBOSession.this.cachedIDHash.values().iterator();
                    this.sessionIterator = WriteCachedOBOSession.this.session.getObjects().iterator();
                    this.cacheNext();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                private void cacheNext() {
                    this.next = null;
                    if (this.cacheIterator.hasNext()) {
                        this.next = this.cacheIterator.next();
                    } else if (this.sessionIterator.hasNext()) {
                        do {
                            this.next = this.sessionIterator.next();
                            if (!WriteCachedOBOSession.this.cachedIDHash.containsKey(this.next.getID()) && !WriteCachedOBOSession.this.destroyedObjects.contains(this.next.getID())) continue;
                            this.next = null;
                        } while (this.next == null && this.sessionIterator.hasNext());
                    }
                }

                @Override
                public IdentifiedObject next() {
                    IdentifiedObject out = this.next;
                    this.cacheNext();
                    return WriteCachedOBOSession.this.getObject(out.getID());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not modifiable");
                }
            };
        }

        @Override
        public int size() {
            int newObjects = 0;
            for (String id : WriteCachedOBOSession.this.cachedIDHash.keySet()) {
                if (WriteCachedOBOSession.this.session.getObject(id) != null) continue;
                ++newObjects;
            }
            return newObjects + WriteCachedOBOSession.this.session.getObjects().size() - WriteCachedOBOSession.this.destroyedObjects.size();
        }

        @Override
        public boolean add(IdentifiedObject o) {
            throw new UnsupportedOperationException("Not modifiable");
        }

        @Override
        public boolean addAll(Collection<? extends IdentifiedObject> c) {
            throw new UnsupportedOperationException("Not modifiable");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not modifiable");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not modifiable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not modifiable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not modifiable");
        }
    };

    public WriteCachedOBOSession(OBOSession session) {
        this.session = session;
        this.operationModel.setSession(this);
        this.cachedIDHash = new LinkedHashMap<String, IdentifiedObject>();
        this.destroyedObjects = new LinkedHashSet<String>();
        this.objectFactory = new DefaultObjectFactory();
        this.categories = new TinySet();
        this.synonymCategories = new TinySet();
        this.namespaces = new TinySet();
        for (TermSubset termSubset : session.getSubsets()) {
            this.categories.add((TermSubset)termSubset.clone());
        }
        for (SynonymType synonymType : session.getSynonymTypes()) {
            this.synonymCategories.add((SynonymType)synonymType.clone());
        }
        for (Namespace namespace : session.getNamespaces()) {
            this.namespaces.add((Namespace)namespace.clone());
        }
        this.defaultNamespace = session.getDefaultNamespace();
        this.currentHistory = (SessionHistoryList)session.getCurrentHistory().clone();
        this.profile = session.getIDProfile();
        this.loadRemark = session.getLoadRemark();
    }

    @Override
    public Collection<TermSubset> getSubsets() {
        return this.categories;
    }

    @Override
    public void addSubset(TermSubset cat) {
        this.categories.add(cat);
    }

    @Override
    public void removeCategory(TermSubset cat) {
        this.categories.remove(cat);
    }

    @Override
    public TermSubset getCategory(String name) {
        for (TermSubset cat : this.categories) {
            if (!cat.getName().equals(name)) continue;
            return cat;
        }
        return null;
    }

    @Override
    public void setDefaultNamespace(Namespace ns) {
        this.defaultNamespace = ns;
    }

    @Override
    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public void addNamespace(Namespace ns) {
        if (ns == null) {
            new Exception("Null namespace added").printStackTrace();
        }
        this.namespaces.add(ns);
    }

    @Override
    public Namespace getNamespace(String id) {
        if (id == null) {
            return null;
        }
        for (Namespace ns : this.namespaces) {
            if (!ns.getID().equals(id)) continue;
            return ns;
        }
        return null;
    }

    @Override
    public void removeNamespace(Namespace ns) {
        this.namespaces.remove(ns);
    }

    @Override
    public Collection<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Collection<SynonymType> getSynonymTypes() {
        return this.synonymCategories;
    }

    @Override
    public void addSynonymType(SynonymType cat) {
        this.synonymCategories.add(cat);
    }

    @Override
    public void removeSynonymCategory(SynonymType cat) {
        this.synonymCategories.remove(cat);
    }

    @Override
    public SynonymType getSynonymType(String id) {
        for (SynonymType cat : this.synonymCategories) {
            if (!cat.getID().equals(id)) continue;
            return cat;
        }
        return null;
    }

    protected IdentifiedObject getCachedObject(String id, boolean cacheLinks) {
        logger.info((Object)("caching " + id));
        IdentifiedObject out = this.cachedIDHash.get(id);
        if (out == null) {
            IdentifiedObject real = this.session.getObject(id);
            if (real == null) {
                return null;
            }
            out = (IdentifiedObject)real.clone();
            this.cachedIDHash.put(out.getID(), out);
        }
        return out;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        return this.objects;
    }

    @Override
    public void removeObject(IdentifiedObject obj) {
        this.cachedIDHash.remove(obj.getID());
        if (this.session.getObject(obj.getID()) != null) {
            this.destroyedObjects.add(obj.getID());
        }
    }

    @Override
    public void addObject(IdentifiedObject obj) {
        this.cachedIDHash.put(obj.getID(), obj);
        this.destroyedObjects.remove(obj.getID());
    }

    public IdentifiedObject getUnwrappedObject(String id) {
        if (this.destroyedObjects.contains(id)) {
            return null;
        }
        IdentifiedObject out = this.cachedIDHash.get(id);
        if (out == null) {
            out = this.session.getObject(id);
        }
        return out;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        IdentifiedObject out = this.getUnwrappedObject(id);
        if (out instanceof OBOClass) {
            return new CacheWrappedOBOClass((OBOClass)out);
        }
        return out;
    }

    @Override
    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    @Override
    public void addPropertyValue(PropertyValue pv) {
        throw new UnsupportedOperationException("Cannot add property values to a WriteCachedOBOSession - this should only happen at load time, before a WCOS should be created");
    }

    @Override
    public void addUnknownStanza(UnknownStanza us) {
        throw new UnsupportedOperationException("Cannot add unknown stanzas to a WriteCachedOBOSession - this should only happen at load time, before a WCOS should be created");
    }

    @Override
    public List<SessionHistoryList> getArchivedHistories() {
        return this.session.getArchivedHistories();
    }

    @Override
    public SessionHistoryList getCurrentHistory() {
        return this.currentHistory;
    }

    @Override
    public IDProfile getIDProfile() {
        return this.profile;
    }

    @Override
    public String getLoadRemark() {
        return this.loadRemark;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public OperationModel getOperationModel() {
        return this.operationModel;
    }

    @Override
    public Collection<PropertyValue> getPropertyValues() {
        return this.session.getPropertyValues();
    }

    @Override
    public Collection<UnknownStanza> getUnknownStanzas() {
        return this.session.getUnknownStanzas();
    }

    @Override
    public HistoryItem importSession(OBOSession session, boolean executeImmediately) {
        if (executeImmediately) {
            for (IdentifiedObject identifiedObject : session.getObjects()) {
                if (this.getObject(identifiedObject.getID()) != null) continue;
                this.addObject(identifiedObject);
            }
            for (TermSubset termSubset : session.getSubsets()) {
                if (this.categories.contains(termSubset)) continue;
                this.addSubset(termSubset);
            }
            for (SynonymType synonymType : session.getSynonymTypes()) {
                if (this.synonymCategories.contains(synonymType)) continue;
                this.addSynonymType(synonymType);
            }
            for (Namespace namespace : session.getNamespaces()) {
                if (this.namespaces.contains(namespace)) continue;
                this.addNamespace(namespace);
            }
            return null;
        }
        throw new UnsupportedOperationException("Undoable import not supported.");
    }

    @Override
    public void removeUnknownStanza(UnknownStanza us) {
        throw new UnsupportedOperationException("Cannot remove unknown stanzas from a WriteCachedOBOSession");
    }

    @Override
    public void setIDProfile(IDProfile profile) {
        this.profile = profile;
    }

    @Override
    public void setLoadRemark(String loadRemark) {
        this.loadRemark = loadRemark;
    }

    @Override
    public QueryResolver getQueryResolver() {
        return this.session.getQueryResolver();
    }

    @Override
    public String getCurrentUser() {
        return this.session.getCurrentUser();
    }

    @Override
    public void setCurrentUser(String user) {
        this.session.setCurrentUser(user);
    }

    @Override
    public void addIDSpace(String idspace, String uriPrefix) {
        this.idspaceToUri.put(idspace, uriPrefix);
    }

    @Override
    public Collection<String> getIDSpaces() {
        return this.idspaceToUri.keySet();
    }

    @Override
    public String expandIDSpace(String idspace) {
        return this.idspaceToUri.get(idspace);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CacheWrappedOBOClass
    implements OBOClass {
        protected OBOClass oboClass;

        public CacheWrappedOBOClass(OBOClass oboClass) {
            this.oboClass = oboClass;
        }

        @Override
        public void addCategory(TermSubset category) {
            this.oboClass.addCategory(category);
        }

        @Override
        public void addCategoryExtension(TermSubset category, NestedValue nv) {
            this.oboClass.addCategoryExtension(category, nv);
        }

        @Override
        public void addChild(Link tr) {
            this.oboClass.addChild(tr);
        }

        @Override
        public void addConsiderExtension(ObsoletableObject o, NestedValue v) {
            this.oboClass.addConsiderExtension(o, v);
        }

        @Override
        public void addConsiderReplacement(ObsoletableObject o) {
            this.oboClass.addConsiderReplacement(o);
        }

        @Override
        public void addDbxref(Dbxref xref) {
            this.oboClass.addDbxref(xref);
        }

        @Override
        public void addDefDbxref(Dbxref dbxref) {
            this.oboClass.addDefDbxref(dbxref);
        }

        @Override
        public void addParent(Link tr) {
            this.oboClass.addParent(tr);
        }

        @Override
        public void addPropertyValue(PropertyValue pv) {
            this.oboClass.addPropertyValue(pv);
        }

        @Override
        public void addReplacedBy(ObsoletableObject o) {
            this.oboClass.addReplacedBy(o);
        }

        @Override
        public void addReplacedByExtension(ObsoletableObject o, NestedValue v) {
            this.oboClass.addReplacedByExtension(o, v);
        }

        @Override
        public void addSecondaryID(String secondaryID) {
            this.oboClass.addSecondaryID(secondaryID);
        }

        @Override
        public void addSecondaryIDExtension(String id, NestedValue nv) {
            this.oboClass.addSecondaryIDExtension(id, nv);
        }

        @Override
        public void addSynonym(Synonym s) {
            this.oboClass.addSynonym(s);
        }

        @Override
        public void atomicAddChild(Link tr) {
            this.oboClass.atomicAddChild(tr);
        }

        @Override
        public void atomicAddParent(Link tr) {
            this.oboClass.atomicAddParent(tr);
        }

        @Override
        public void atomicRemoveChild(Link tr) {
            this.oboClass.atomicRemoveChild(tr);
        }

        @Override
        public void atomicRemoveParent(Link tr) {
            this.oboClass.atomicRemoveParent(tr);
        }

        @Override
        public Object clone() {
            return this.oboClass.clone();
        }

        public int compareTo(Object o) {
            return this.oboClass.compareTo(o);
        }

        @Override
        public NestedValue getAnonymousExtension() {
            return this.oboClass.getAnonymousExtension();
        }

        public Set getSubsets() {
            return this.oboClass.getSubsets();
        }

        @Override
        public NestedValue getCategoryExtension(TermSubset category) {
            return this.oboClass.getCategoryExtension(category);
        }

        @Override
        public Collection<Link> getChildren() {
            return WriteCachedOBOSession.this.linkDatabase.getChildren(this);
        }

        @Override
        public String getComment() {
            return this.oboClass.getComment();
        }

        @Override
        public NestedValue getCommentExtension() {
            return this.oboClass.getCommentExtension();
        }

        @Override
        public NestedValue getConsiderExtension(ObsoletableObject o) {
            return this.oboClass.getConsiderExtension(o);
        }

        @Override
        public Set<ObsoletableObject> getConsiderReplacements() {
            return this.oboClass.getConsiderReplacements();
        }

        @Override
        public Set<Dbxref> getDbxrefs() {
            return this.oboClass.getDbxrefs();
        }

        @Override
        public Set<Dbxref> getDefDbxrefs() {
            return this.oboClass.getDefDbxrefs();
        }

        @Override
        public String getDefinition() {
            return this.oboClass.getDefinition();
        }

        @Override
        public NestedValue getDefinitionExtension() {
            return this.oboClass.getDefinitionExtension();
        }

        @Override
        public String getID() {
            return this.oboClass.getID();
        }

        @Override
        public NestedValue getIDExtension() {
            return this.oboClass.getIDExtension();
        }

        @Override
        public String getName() {
            return this.oboClass.getName();
        }

        @Override
        public NestedValue getNameExtension() {
            return this.oboClass.getNameExtension();
        }

        @Override
        public Namespace getNamespace() {
            return this.oboClass.getNamespace();
        }

        @Override
        public NestedValue getNamespaceExtension() {
            return this.oboClass.getNamespaceExtension();
        }

        @Override
        public NestedValue getObsoleteExtension() {
            return this.oboClass.getObsoleteExtension();
        }

        @Override
        public Collection<Link> getParents() {
            return WriteCachedOBOSession.this.linkDatabase.getParents(this);
        }

        @Override
        public Set<PropertyValue> getPropertyValues() {
            return this.oboClass.getPropertyValues();
        }

        @Override
        public Set<ObsoletableObject> getReplacedBy() {
            return this.oboClass.getReplacedBy();
        }

        @Override
        public NestedValue getReplacedByExtension(ObsoletableObject o) {
            return this.oboClass.getReplacedByExtension(o);
        }

        @Override
        public NestedValue getSecondaryIDExtension(String id) {
            return this.oboClass.getSecondaryIDExtension(id);
        }

        public Set getSecondaryIDs() {
            return this.oboClass.getSecondaryIDs();
        }

        @Override
        public Set<Synonym> getSynonyms() {
            return this.oboClass.getSynonyms();
        }

        @Override
        public Type<OBOClass> getType() {
            return this.oboClass.getType();
        }

        @Override
        public NestedValue getTypeExtension() {
            return this.oboClass.getTypeExtension();
        }

        @Override
        public boolean isAnonymous() {
            return this.oboClass.isAnonymous();
        }

        @Override
        public boolean isBuiltIn() {
            return this.oboClass.isBuiltIn();
        }

        @Override
        public boolean isObsolete() {
            return this.oboClass.isObsolete();
        }

        @Override
        public void removeCategory(TermSubset category) {
            this.oboClass.removeCategory(category);
        }

        @Override
        public void removeChild(Link tr) {
            this.oboClass.removeChild(tr);
        }

        @Override
        public void removeConsiderReplacement(ObsoletableObject o) {
            this.oboClass.removeConsiderReplacement(o);
        }

        @Override
        public void removeDbxref(Dbxref xref) {
            this.oboClass.removeDbxref(xref);
        }

        @Override
        public void removeDefDbxref(Dbxref dbxref) {
            this.oboClass.removeDefDbxref(dbxref);
        }

        @Override
        public void removeParent(Link tr) {
            this.oboClass.removeParent(tr);
        }

        @Override
        public void removePropertyValue(PropertyValue pv) {
            this.oboClass.removePropertyValue(pv);
        }

        @Override
        public void removeReplacedBy(ObsoletableObject o) {
            this.oboClass.removeReplacedBy(o);
        }

        @Override
        public void removeSecondaryID(String secondaryID) {
            this.oboClass.removeSecondaryID(secondaryID);
        }

        @Override
        public void removeSynonym(Synonym s) {
            this.oboClass.removeSynonym(s);
        }

        @Override
        public void setAnonymousExtension(NestedValue nv) {
            this.oboClass.setAnonymousExtension(nv);
        }

        @Override
        public void setComment(String comment) {
            this.oboClass.setComment(comment);
        }

        @Override
        public void setCommentExtension(NestedValue nv) {
            this.oboClass.setCommentExtension(nv);
        }

        @Override
        public void setDefinition(String definition) {
            this.oboClass.setDefinition(definition);
        }

        @Override
        public void setDefinitionExtension(NestedValue nv) {
            this.oboClass.setDefinitionExtension(nv);
        }

        @Override
        public void setIDExtension(NestedValue nv) {
            this.oboClass.setIDExtension(nv);
        }

        @Override
        public void setIsAnonymous(boolean isAnonymous) {
            this.oboClass.setIsAnonymous(isAnonymous);
        }

        @Override
        public void setName(String name) {
            this.oboClass.setName(name);
        }

        @Override
        public void setNameExtension(NestedValue nv) {
            this.oboClass.setNameExtension(nv);
        }

        @Override
        public void setNamespace(Namespace namespace) {
            this.oboClass.setNamespace(namespace);
        }

        @Override
        public void setNamespaceExtension(NestedValue nv) {
            this.oboClass.setNamespaceExtension(nv);
        }

        @Override
        public void setObsolete(boolean isObsolete) {
            this.oboClass.setObsolete(isObsolete);
        }

        @Override
        public void setObsoleteExtension(NestedValue nv) {
            this.oboClass.setObsoleteExtension(nv);
        }

        @Override
        public void setTypeExtension(NestedValue value) {
            this.oboClass.setTypeExtension(value);
        }

        public boolean equals(Object obj) {
            return this.oboClass.equals(obj);
        }

        public int hashCode() {
            return this.oboClass.hashCode();
        }

        @Override
        public String getCreatedBy() {
            return this.oboClass.getCreatedBy();
        }

        @Override
        public Date getCreationDate() {
            return this.oboClass.getCreationDate();
        }

        @Override
        public void setCreatedBy(String username) {
            this.oboClass.setCreatedBy(username);
        }

        @Override
        public void setCreationDate(Date date) {
            this.oboClass.setCreationDate(date);
        }

        @Override
        public Date getModificationDate() {
            return this.oboClass.getModificationDate();
        }

        @Override
        public String getModifiedBy() {
            return this.oboClass.getModifiedBy();
        }

        @Override
        public void setModificationDate(Date date) {
            this.oboClass.setModificationDate(date);
        }

        @Override
        public void setModifiedBy(String username) {
            this.oboClass.setModifiedBy(username);
        }

        @Override
        public NestedValue getCreatedByExtension() {
            return this.oboClass.getCreatedByExtension();
        }

        @Override
        public NestedValue getCreationDateExtension() {
            return this.oboClass.getCreationDateExtension();
        }

        @Override
        public NestedValue getModificationDateExtension() {
            return this.oboClass.getModificationDateExtension();
        }

        @Override
        public NestedValue getModifiedByExtension() {
            return this.oboClass.getModifiedByExtension();
        }

        @Override
        public void setCreatedByExtension(NestedValue nv) {
            this.oboClass.setCreatedByExtension(nv);
        }

        @Override
        public void setCreationDateExtension(NestedValue nv) {
            this.oboClass.setCreationDateExtension(nv);
        }

        @Override
        public void setModificationDateExtension(NestedValue nv) {
            this.oboClass.setModificationDateExtension(nv);
        }

        @Override
        public void setModifiedByExtension(NestedValue nv) {
            this.oboClass.setModifiedByExtension(nv);
        }
    }
}

