/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.DefinedObject;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;

public class DefinitionChangeHistoryItem
extends HistoryItem {
    protected static final Logger logger = Logger.getLogger(DefinitionChangeHistoryItem.class);
    private static final long serialVersionUID = 2073554942274780836L;
    protected String oldText;
    protected String newText;
    protected String target;

    public DefinitionChangeHistoryItem() {
        this(null, null, null);
    }

    public DefinitionChangeHistoryItem(DefinedObject defob, String def) {
        this(defob.getDefinition(), def, defob.getID());
    }

    public DefinitionChangeHistoryItem(String oldText, String newText, String target) {
        this.target = target;
        this.oldText = oldText;
        this.newText = newText;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefinitionChangeHistoryItem)) {
            return false;
        }
        DefinitionChangeHistoryItem edit = (DefinitionChangeHistoryItem)o;
        boolean out = ObjectUtil.equals((Object)this.target, (Object)edit.getTarget()) && ObjectUtil.equals((Object)this.oldText, (Object)edit.getText()) && ObjectUtil.equals((Object)this.newText, (Object)edit.getNewText());
        return out;
    }

    public int hashCode() {
        int code = DefinitionChangeHistoryItem.getHash(this.target) ^ DefinitionChangeHistoryItem.getHash(this.oldText) ^ DefinitionChangeHistoryItem.getHash(this.newText);
        return code;
    }

    public void setOldText(String oldText) {
        this.oldText = oldText;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getText() {
        return this.oldText;
    }

    public String getNewText() {
        return this.newText;
    }

    public boolean isAdd() {
        return this.oldText == null || this.oldText.length() == 0;
    }

    public boolean isDel() {
        return this.newText == null || this.newText.length() == 0;
    }

    public boolean isEdit() {
        return !this.isAdd() && !this.isDel();
    }

    public String getShortName() {
        return "Changed definition";
    }

    public String toString() {
        if (this.oldText == null || this.oldText.length() < 1) {
            return "Set definition of " + this.target + " to \"" + this.newText + "\"";
        }
        if (this.newText == null || this.newText.length() < 1) {
            return "Removed definition of " + this.target;
        }
        return "Changed definition of " + this.target + " from \"" + this.oldText + "\" to \"" + this.newText + "\"";
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

