/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.CollectionChanges;
import org.bbop.util.CollectionUtil;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.history.AddConsiderHistoryItem;
import org.obo.history.AddDbxrefHistoryItem;
import org.obo.history.AddReplacementHistoryItem;
import org.obo.history.AddSynonymHistoryItem;
import org.obo.history.CardinalityHistoryItem;
import org.obo.history.ChangeSynScopeHistoryItem;
import org.obo.history.ChangeSynTypeHistoryItem;
import org.obo.history.CommentChangeHistoryItem;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.CyclicHistoryItem;
import org.obo.history.DefaultHistoryList;
import org.obo.history.DefinitionChangeHistoryItem;
import org.obo.history.DelDbxrefHistoryItem;
import org.obo.history.DelSynonymHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.DestroyObjectHistoryItem;
import org.obo.history.DomainHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.InverseNecHistoryItem;
import org.obo.history.MaxCardinalityHistoryItem;
import org.obo.history.MinCardinalityHistoryItem;
import org.obo.history.NameChangeHistoryItem;
import org.obo.history.NamespaceHistoryItem;
import org.obo.history.NecessarilyTrueHistoryItem;
import org.obo.history.ObsoleteObjectHistoryItem;
import org.obo.history.RangeHistoryItem;
import org.obo.history.RemoveConsiderHistoryItem;
import org.obo.history.RemoveReplacementHistoryItem;
import org.obo.history.SecondaryIDHistoryItem;
import org.obo.history.SessionHistoryList;
import org.obo.history.StringRelationship;
import org.obo.history.SubsetChangeHistoryItem;
import org.obo.history.SymmetricHistoryItem;
import org.obo.history.SynonymTypeHistoryItem;
import org.obo.history.TRNamespaceHistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.history.TermNamespaceHistoryItem;
import org.obo.history.TermSubsetHistoryItem;
import org.obo.history.TransitiveHistoryItem;
import org.obo.util.HistoryUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryGenerator
implements Serializable {
    protected static final Logger logger = Logger.getLogger(HistoryGenerator.class);
    private static final long serialVersionUID = 1L;

    protected static boolean checkInterface(IdentifiedObject io, HistoryList history, Class checkme, Collection<String> warnings) {
        if (!checkme.isInstance(io)) {
            if (warnings != null) {
                warnings.add(io + " should be an instance of " + checkme + ", but it is not.");
            }
            return false;
        }
        return true;
    }

    public static SessionHistoryList getHistory(OBOSession oldHistory, OBOSession newHistory) {
        return HistoryGenerator.getHistory(oldHistory, newHistory, null);
    }

    public static SessionHistoryList getHistory(OBOSession oldSession, OBOSession newSession, Collection<String> warnings) {
        IdentifiedObject oldSessionIdentifiedObject;
        HistoryItem item;
        HistoryItem item2;
        DefaultHistoryList history = new DefaultHistoryList();
        for (Namespace n : oldSession.getNamespaces()) {
            Namespace newn = HistoryUtil.findNamespace(n, newSession);
            if (newn != null) continue;
            item2 = new TermNamespaceHistoryItem(n.getID(), null, false, true);
            history.addItem(item2);
        }
        for (Namespace namespace : newSession.getNamespaces()) {
            Namespace oldNamespace = HistoryUtil.findNamespace(namespace, oldSession);
            if (oldNamespace != null) continue;
            item2 = new TermNamespaceHistoryItem(null, namespace.getID(), true, false);
            history.addItem(item2);
        }
        for (TermSubset oldTermSubset : oldSession.getSubsets()) {
            if (!newSession.getSubsets().contains(oldTermSubset)) {
                item = new TermSubsetHistoryItem(oldTermSubset, null, false, true);
                history.addItem(item);
                continue;
            }
            TermSubset newTermSubset = HistoryUtil.findCategory(oldTermSubset, newSession);
            if (oldTermSubset.getDesc().equals(newTermSubset.getDesc())) continue;
            item2 = new TermSubsetHistoryItem(oldTermSubset, newTermSubset, false, false);
            history.addItem(item2);
        }
        for (TermSubset newTermSubset : newSession.getSubsets()) {
            if (oldSession.getSubsets().contains(newTermSubset)) continue;
            item = new TermSubsetHistoryItem(null, newTermSubset, true, false);
            history.addItem(item);
        }
        for (SynonymType oldTermSynonymType : oldSession.getSynonymTypes()) {
            if (!newSession.getSynonymTypes().contains(oldTermSynonymType)) {
                item = new SynonymTypeHistoryItem(oldTermSynonymType, null, false, true);
                history.addItem(item);
                continue;
            }
            SynonymType newTermSynonymType = HistoryUtil.findSynonymCategory(oldTermSynonymType, newSession);
            if (oldTermSynonymType.getName().equals(newTermSynonymType.getName()) && oldTermSynonymType.getScope() == newTermSynonymType.getScope()) continue;
            item2 = new SynonymTypeHistoryItem(oldTermSynonymType, newTermSynonymType, false, false);
            history.addItem(item2);
        }
        for (SynonymType newTermSynonymType : newSession.getSynonymTypes()) {
            if (oldSession.getSynonymTypes().contains(newTermSynonymType)) continue;
            item = new SynonymTypeHistoryItem(null, newTermSynonymType, true, false);
            history.addItem(item);
        }
        LinkedList<IdentifiedObject> newObjects = new LinkedList<IdentifiedObject>();
        for (IdentifiedObject newSessionIdentifiedObject : newSession.getObjects()) {
            if (newSessionIdentifiedObject.getClass().getName() == "obo:TERM") {
                // empty if block
            }
            if ((oldSessionIdentifiedObject = oldSession.getObject(newSessionIdentifiedObject.getID())).getClass().getName() == "obo:TERM") {
                // empty if block
            }
            if (oldSessionIdentifiedObject != null) continue;
            history.addItem(new CreateObjectHistoryItem(newSessionIdentifiedObject.getID(), newSessionIdentifiedObject.getType().getID()));
            newObjects.add(newSessionIdentifiedObject);
        }
        for (IdentifiedObject newSessionIdentifiedObject : newObjects) {
            oldSessionIdentifiedObject = oldSession.getObject(newSessionIdentifiedObject.getID());
            DefaultHistoryList creationList = new DefaultHistoryList();
            if (newSessionIdentifiedObject.getType() instanceof OBOClass) {
                IdentifiedObject blankTerm = oldSession.getObjectFactory().createObject(newSessionIdentifiedObject.getID(), (OBOClass)newSessionIdentifiedObject.getType(), newSessionIdentifiedObject.isAnonymous());
                HistoryGenerator.getTermTextChanges(blankTerm, newSessionIdentifiedObject, creationList, warnings);
                HistoryGenerator.getParentageChanges(blankTerm, newSessionIdentifiedObject, creationList, warnings);
                HistoryGenerator.getObsoleteChanges(blankTerm, newSessionIdentifiedObject, creationList, warnings);
                HistoryGenerator.getNamespaceChanges(blankTerm, newSessionIdentifiedObject, creationList, warnings);
            }
            if (creationList.size() > 1) {
                TermMacroHistoryItem item3 = new TermMacroHistoryItem("Populated new object " + newSessionIdentifiedObject.getID());
                item3.setHistoryList(creationList);
                history.addItem(item3);
                continue;
            }
            history.addItem(creationList.getItemAt(0));
        }
        for (IdentifiedObject io : oldSession.getObjects()) {
            IdentifiedObject newio = newSession.getObject(io.getID());
            if (newio == null) {
                if (io instanceof LinkedObject) {
                    LinkedObject lo = (LinkedObject)io;
                    for (Link link : lo.getParents()) {
                        history.addItem(new DeleteLinkHistoryItem(link));
                    }
                }
                history.addItem(new DestroyObjectHistoryItem(io));
                continue;
            }
            if (!io.getType().equals(newio.getType()) && warnings != null) {
                warnings.add(io + " changed type between versions of this file!");
            }
            HistoryGenerator.getTermTextChanges(io, newio, history, warnings);
            HistoryGenerator.getParentageChanges(io, newio, history, warnings);
            HistoryGenerator.getObsoleteChanges(io, newio, history, warnings);
        }
        return history;
    }

    public static void getChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList changes) {
        HistoryGenerator.getChanges(io, newio, changes);
    }

    public static void getChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList changes, Collection<String> warnings) {
        HistoryGenerator.getParentageChanges(io, newio, changes, warnings);
        HistoryGenerator.getObsoleteChanges(io, newio, changes, warnings);
        HistoryGenerator.getTermTextChanges(io, newio, changes, warnings);
        HistoryGenerator.getNamespaceChanges(io, newio, changes, warnings);
    }

    public static HistoryList getChanges(IdentifiedObject io, IdentifiedObject newio) {
        return HistoryGenerator.getChanges(io, newio, (Collection<String>)null);
    }

    public static HistoryList getChanges(IdentifiedObject io, IdentifiedObject newio, Collection<String> warnings) {
        DefaultHistoryList changes = new DefaultHistoryList();
        HistoryGenerator.getChanges(io, newio, changes, warnings);
        return changes;
    }

    public static void getParentageChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history, Collection<String> warnings) {
        if (HistoryGenerator.checkInterface(io, history, LinkedObject.class, warnings) && HistoryGenerator.checkInterface(newio, history, LinkedObject.class, warnings)) {
            Link foundLink;
            LinkedObject lio = (LinkedObject)io;
            LinkedObject lnewio = (LinkedObject)newio;
            for (Link link : lio.getParents()) {
                foundLink = HistoryUtil.findParentRel(link, lnewio);
                if (foundLink == null) {
                    history.addItem(new DeleteLinkHistoryItem(link));
                    continue;
                }
                if (!ObjectUtil.equals((Object)link.getNamespace(), (Object)foundLink.getNamespace())) {
                    history.addItem(new TRNamespaceHistoryItem(link, foundLink.getNamespace()));
                }
                if (link instanceof OBORestriction != foundLink instanceof OBORestriction && warnings != null) {
                    warnings.add(link + " changed interface types!");
                }
                if (!(link instanceof OBORestriction)) continue;
                OBORestriction rlink = (OBORestriction)link;
                OBORestriction rfoundLink = (OBORestriction)foundLink;
                if (!ObjectUtil.equals((Object)rlink.getCardinality(), (Object)rfoundLink.getCardinality())) {
                    history.addItem(new CardinalityHistoryItem(rlink, rfoundLink.getCardinality()));
                }
                if (!ObjectUtil.equals((Object)rlink.getMaxCardinality(), (Object)rfoundLink.getMaxCardinality())) {
                    history.addItem(new MaxCardinalityHistoryItem(rlink, rfoundLink.getMaxCardinality()));
                }
                if (!ObjectUtil.equals((Object)rlink.getMinCardinality(), (Object)rfoundLink.getMinCardinality())) {
                    history.addItem(new MinCardinalityHistoryItem(rlink, rfoundLink.getMinCardinality()));
                }
                if (rlink.isNecessarilyTrue() != rfoundLink.isNecessarilyTrue()) {
                    history.addItem(new NecessarilyTrueHistoryItem(rlink));
                }
                if (rlink.isInverseNecessarilyTrue() != rfoundLink.isInverseNecessarilyTrue()) {
                    history.addItem(new InverseNecHistoryItem(rlink));
                }
                if (rlink.completes() == rfoundLink.completes()) continue;
                history.addItem(new CompletesHistoryItem(rlink));
            }
            for (Link link : lnewio.getParents()) {
                foundLink = HistoryUtil.findParentRelNoIntersection(link, lio);
                if (foundLink != null) continue;
                history.addItem(new CreateLinkHistoryItem(link.getChild(), link.getType(), link.getParent()));
                OBORestrictionImpl newLink = new OBORestrictionImpl(link.getChild(), link.getType(), link.getParent());
                if (link.getNamespace() != null) {
                    history.addItem(new TRNamespaceHistoryItem(new StringRelationship(link), null, link.getNamespace().getID()));
                }
                if (!(link instanceof OBORestriction)) continue;
                OBORestriction rlink = (OBORestriction)link;
                if (rlink.getCardinality() != null) {
                    history.addItem(new CardinalityHistoryItem(newLink, rlink.getCardinality()));
                }
                if (rlink.getMaxCardinality() != null) {
                    history.addItem(new MaxCardinalityHistoryItem(newLink, rlink.getMaxCardinality()));
                }
                if (rlink.getMinCardinality() != null) {
                    history.addItem(new MinCardinalityHistoryItem(newLink, rlink.getMinCardinality()));
                }
                if (!rlink.isNecessarilyTrue()) {
                    history.addItem(new NecessarilyTrueHistoryItem(new StringRelationship(newLink), true));
                }
                if (rlink.isInverseNecessarilyTrue()) {
                    history.addItem(new InverseNecHistoryItem(new StringRelationship(newLink), false));
                }
                if (!rlink.completes()) continue;
                history.addItem(new CompletesHistoryItem(new StringRelationship(newLink), false));
            }
        }
    }

    public static void getObsoleteChanges(IdentifiedObject oldIO, IdentifiedObject newIO, HistoryList history, Collection<String> warnings) {
        block11: {
            block12: {
                block10: {
                    if (!TermUtil.isObsolete(newIO) || TermUtil.isObsolete(oldIO)) break block10;
                    if (!(newIO instanceof ObsoletableObject) && warnings != null) {
                        warnings.add(newIO + " is not an ObsoletableObject");
                    } else {
                        history.addItem(new ObsoleteObjectHistoryItem(oldIO));
                    }
                    ObsoletableObject obsoletableOldIO = (ObsoletableObject)oldIO;
                    ObsoletableObject obsoletableNewIO = (ObsoletableObject)newIO;
                    CollectionChanges considerchanges = CollectionUtil.getChanges(obsoletableOldIO.getConsiderReplacements(), obsoletableNewIO.getConsiderReplacements());
                    for (ObsoletableObject oo : considerchanges.getAddedItems()) {
                        history.addItem(new AddConsiderHistoryItem(obsoletableOldIO, oo));
                    }
                    for (ObsoletableObject oo : considerchanges.getDeletedItems()) {
                        history.addItem(new RemoveConsiderHistoryItem(obsoletableOldIO, oo));
                    }
                    Set<ObsoletableObject> obsoletableOldIOReplacedBy = obsoletableOldIO.getReplacedBy();
                    Set<ObsoletableObject> obsoletableNewIOReplacedBy = obsoletableNewIO.getReplacedBy();
                    CollectionChanges replacementchanges = CollectionUtil.getChanges(obsoletableOldIOReplacedBy, obsoletableNewIOReplacedBy);
                    for (ObsoletableObject oo : replacementchanges.getAddedItems()) {
                        history.addItem(new AddReplacementHistoryItem(obsoletableOldIO, oo));
                    }
                    for (ObsoletableObject oo : replacementchanges.getDeletedItems()) {
                        history.addItem(new RemoveReplacementHistoryItem(obsoletableOldIO, oo));
                    }
                    break block11;
                }
                if (TermUtil.isObsolete(newIO) || !TermUtil.isObsolete(oldIO) || warnings == null) break block12;
                warnings.add(newIO + " was somehow unobsoleted!");
                break block11;
            }
            if (!(newIO instanceof ObsoletableObject) || !(oldIO instanceof ObsoletableObject)) break block11;
            ObsoletableObject obsoletableOldIO = (ObsoletableObject)oldIO;
            ObsoletableObject obsoletableNewIO = (ObsoletableObject)newIO;
            CollectionChanges considerchanges = CollectionUtil.getChanges(obsoletableOldIO.getConsiderReplacements(), obsoletableNewIO.getConsiderReplacements());
            for (ObsoletableObject oo : considerchanges.getAddedItems()) {
                history.addItem(new AddConsiderHistoryItem(obsoletableOldIO, oo));
            }
            for (ObsoletableObject oo : considerchanges.getDeletedItems()) {
                history.addItem(new RemoveConsiderHistoryItem(obsoletableOldIO, oo));
            }
            Set<ObsoletableObject> obsoletableOldIOReplacedBy = obsoletableOldIO.getReplacedBy();
            Set<ObsoletableObject> obsoletableNewIOReplacedBy = obsoletableNewIO.getReplacedBy();
            CollectionChanges replacementchanges = CollectionUtil.getChanges(obsoletableOldIOReplacedBy, obsoletableNewIOReplacedBy);
            for (ObsoletableObject oo : replacementchanges.getAddedItems()) {
                history.addItem(new AddReplacementHistoryItem(obsoletableOldIO, oo));
            }
            for (ObsoletableObject oo : replacementchanges.getDeletedItems()) {
                history.addItem(new RemoveReplacementHistoryItem(obsoletableOldIO, oo));
            }
        }
    }

    public static void getNamespaceChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history, Collection<String> warnings) {
        if (!ObjectUtil.equals((Object)io.getNamespace(), (Object)newio.getNamespace())) {
            history.addItem(new NamespaceHistoryItem(io, newio.getNamespace()));
        }
    }

    public static void getTermTextChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history, Collection<String> warnings) {
        HistoryGenerator.getTermTextChanges(io, newio, history, false, warnings);
    }

    public static void getTermTextChanges(IdentifiedObject io, IdentifiedObject newio, HistoryList history, boolean ignoreSecondaryIDs, Collection<String> warnings) {
        Object dnewio;
        Object dio;
        Object cnewio;
        Object cio;
        if (io.getName() == null || newio.getName() == null || !io.getName().equals(newio.getName())) {
            history.addItem(new NameChangeHistoryItem(io, newio.getName()));
        }
        if (HistoryGenerator.checkInterface(io, history, CommentedObject.class, warnings) != HistoryGenerator.checkInterface(newio, history, CommentedObject.class, warnings) && warnings != null) {
            warnings.add(io + " changed whether it is " + "a CommentedObject!");
            return;
        }
        if (HistoryGenerator.checkInterface(io, history, CommentedObject.class, warnings)) {
            cio = (CommentedObject)io;
            cnewio = (CommentedObject)newio;
            if (!ObjectUtil.equals((Object)cio.getComment(), (Object)cnewio.getComment())) {
                history.addItem(new CommentChangeHistoryItem((CommentedObject)cio, cnewio.getComment()));
            }
        }
        if (!ignoreSecondaryIDs) {
            if (HistoryGenerator.checkInterface(io, history, MultiIDObject.class, warnings) != HistoryGenerator.checkInterface(newio, history, MultiIDObject.class, warnings) && warnings != null) {
                warnings.add(io + " changed whether it is " + "a MultiIDObject!");
                return;
            }
            if (HistoryGenerator.checkInterface(io, history, MultiIDObject.class, warnings)) {
                MultiIDObject mio = (MultiIDObject)io;
                MultiIDObject cmio = (MultiIDObject)newio;
                for (String id : mio.getSecondaryIDs()) {
                    if (cmio.getSecondaryIDs().contains(id)) continue;
                    history.addItem(new SecondaryIDHistoryItem(mio, id, true));
                }
                for (String id : cmio.getSecondaryIDs()) {
                    if (mio.getSecondaryIDs().contains(id)) continue;
                    history.addItem(new SecondaryIDHistoryItem(mio, id, false));
                }
            }
        }
        if (HistoryGenerator.checkInterface(io, history, DefinedObject.class, warnings) != HistoryGenerator.checkInterface(newio, history, DefinedObject.class, warnings) && warnings != null) {
            warnings.add(io + " changed whether it is " + "a DefinedObject!");
            return;
        }
        if (HistoryGenerator.checkInterface(io, history, DefinedObject.class, warnings)) {
            dio = (DefinedObject)io;
            dnewio = (DefinedObject)newio;
            if (!ObjectUtil.equals((Object)dio.getDefinition(), (Object)dnewio.getDefinition())) {
                history.addItem(new DefinitionChangeHistoryItem((DefinedObject)dio, dnewio.getDefinition()));
            }
            for (Dbxref ref : dio.getDefDbxrefs()) {
                if (dnewio.getDefDbxrefs().contains(ref)) continue;
                history.addItem(new DelDbxrefHistoryItem(io.getID(), ref, true, null));
            }
            for (Dbxref ref : dnewio.getDefDbxrefs()) {
                if (dio.getDefDbxrefs().contains(ref)) continue;
                history.addItem(new AddDbxrefHistoryItem(io.getID(), ref, true, null));
            }
        }
        if (HistoryGenerator.checkInterface(io, history, DbxrefedObject.class, warnings) != HistoryGenerator.checkInterface(newio, history, DbxrefedObject.class, warnings) && warnings != null) {
            warnings.add(io + " changed whether it is a " + "DbxrefedObject");
        } else if (HistoryGenerator.checkInterface(io, history, DbxrefedObject.class, warnings)) {
            dio = (DbxrefedObject)((Object)io);
            dnewio = (DbxrefedObject)((Object)newio);
            for (Dbxref ref : dio.getDbxrefs()) {
                if (dnewio.getDbxrefs().contains(ref)) continue;
                history.addItem(new DelDbxrefHistoryItem(io.getID(), ref, false, null));
            }
            for (Dbxref ref : dnewio.getDbxrefs()) {
                if (dio.getDbxrefs().contains(ref)) continue;
                history.addItem(new AddDbxrefHistoryItem(io.getID(), ref, false, null));
            }
        }
        if (HistoryGenerator.checkInterface(io, history, SubsetObject.class, warnings) != HistoryGenerator.checkInterface(newio, history, SubsetObject.class, warnings) && warnings != null) {
            warnings.add(io + " changed whether it is a " + "CategorizedObject");
        } else if (HistoryGenerator.checkInterface(io, history, SubsetObject.class, warnings)) {
            SubsetChangeHistoryItem item;
            cio = (SubsetObject)((Object)io);
            cnewio = (SubsetObject)((Object)newio);
            for (TermSubset termCategory : cio.getSubsets()) {
                if (cnewio.getSubsets().contains(termCategory)) continue;
                item = new SubsetChangeHistoryItem(termCategory.getName(), true, io.getID());
                history.addItem(item);
            }
            for (TermSubset termCategory : cnewio.getSubsets()) {
                if (cio.getSubsets().contains(termCategory)) continue;
                item = new SubsetChangeHistoryItem(termCategory.getName(), false, io.getID());
                history.addItem(item);
            }
        }
        if (HistoryGenerator.checkInterface(io, history, SynonymedObject.class, warnings) != HistoryGenerator.checkInterface(newio, history, SynonymedObject.class, warnings) && warnings != null) {
            warnings.add(io + " changed whether it is a " + "SynonymedObject");
        } else if (HistoryGenerator.checkInterface(io, history, SynonymedObject.class, warnings)) {
            SynonymedObject sio = (SynonymedObject)io;
            SynonymedObject snewio = (SynonymedObject)newio;
            for (Synonym s : sio.getSynonyms()) {
                boolean found = false;
                for (Synonym news : snewio.getSynonyms()) {
                    if (!news.getText().equals(s.getText())) continue;
                    found = true;
                    for (Dbxref oldref : s.getXrefs()) {
                        if (news.getXrefs().contains(oldref)) continue;
                        history.addItem(new DelDbxrefHistoryItem(sio.getID(), oldref, false, s.getText()));
                    }
                    for (Dbxref newref : news.getXrefs()) {
                        if (s.getXrefs().contains(newref)) continue;
                        history.addItem(new AddDbxrefHistoryItem(sio.getID(), newref, false, s.getText()));
                    }
                    if (!ObjectUtil.equals((Object)news.getSynonymType(), (Object)s.getSynonymType())) {
                        history.addItem(new ChangeSynTypeHistoryItem(sio, s, news.getSynonymType()));
                    }
                    if (news.getScope() == s.getScope()) break;
                    history.addItem(new ChangeSynScopeHistoryItem(io.getID(), s.getText(), s.getScope(), news.getScope()));
                    break;
                }
                if (found) continue;
                history.addItem(new DelSynonymHistoryItem(io.getID(), s.getText()));
            }
            for (Synonym s : snewio.getSynonyms()) {
                boolean found = false;
                for (Synonym olds : sio.getSynonyms()) {
                    if (!olds.getText().equals(s.getText())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                history.addItem(new AddSynonymHistoryItem(io.getID(), s.getText()));
                for (Dbxref ref : s.getXrefs()) {
                    history.addItem(new AddDbxrefHistoryItem(sio.getID(), ref, false, s.getText()));
                }
                if (s.getSynonymType() != null) {
                    history.addItem(new ChangeSynTypeHistoryItem(sio.getID(), s.getText(), null, s.getSynonymType().getID()));
                }
                if (s.getScope() == 0) continue;
                history.addItem(new ChangeSynScopeHistoryItem(io.getID(), s.getText(), 0, s.getScope()));
            }
        }
        if (HistoryGenerator.checkInterface(io, history, OBOProperty.class, warnings) != HistoryGenerator.checkInterface(newio, history, OBOProperty.class, warnings)) {
            warnings.add(io + " changed whether it is " + "a OBOProperty!");
            return;
        }
        if (HistoryGenerator.checkInterface(io, history, OBOProperty.class, warnings)) {
            OBOProperty prop = (OBOProperty)io;
            OBOProperty newprop = (OBOProperty)newio;
            if (!ObjectUtil.equals((Object)prop.getDomain(), (Object)newprop.getDomain())) {
                history.addItem(new DomainHistoryItem(prop, newprop.getDomain()));
            }
            if (!ObjectUtil.equals((Object)prop.getRange(), (Object)newprop.getRange())) {
                history.addItem(new RangeHistoryItem(prop, newprop.getRange()));
            }
            if (prop.isTransitive() != newprop.isTransitive()) {
                history.addItem(new TransitiveHistoryItem(prop));
            }
            if (prop.isSymmetric() != newprop.isSymmetric()) {
                history.addItem(new SymmetricHistoryItem(prop));
            }
            if (prop.isCyclic() != newprop.isCyclic()) {
                history.addItem(new CyclicHistoryItem(prop));
            }
        }
    }
}

