/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Namespace;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;

public class NamespaceHistoryItem
extends HistoryItem {
    protected static final Logger logger = Logger.getLogger(NamespaceHistoryItem.class);
    private static final long serialVersionUID = -5475209155866979138L;
    protected Namespace oldns;
    protected Namespace newns;
    protected String target;

    public NamespaceHistoryItem(IdentifiedObject io, Namespace newns) {
        this(io.getNamespace(), newns, io.getID());
    }

    public NamespaceHistoryItem(Namespace oldns, Namespace newns, String target) {
        this.target = target;
        this.oldns = oldns;
        this.newns = newns;
    }

    public NamespaceHistoryItem() {
        this(null, null, null);
    }

    public void complete() {
    }

    public boolean equals(Object o) {
        if (!(o instanceof NamespaceHistoryItem)) {
            return false;
        }
        NamespaceHistoryItem edit = (NamespaceHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)edit.getTarget()) && ObjectUtil.equals((Object)this.oldns, (Object)edit.getOldNamespace()) && ObjectUtil.equals((Object)this.newns, (Object)edit.getNewNamespace());
    }

    public int hashCode() {
        return NamespaceHistoryItem.getHash(this.target) ^ NamespaceHistoryItem.getHash(this.oldns) ^ NamespaceHistoryItem.getHash(this.newns);
    }

    public void setOldNamespace(Namespace oldns) {
        this.oldns = oldns;
    }

    public void setNewNamespace(Namespace newns) {
        this.newns = newns;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Namespace getNewNamespace() {
        return this.newns;
    }

    public Namespace getOldNamespace() {
        return this.oldns;
    }

    public String getShortName() {
        return "Namespace change";
    }

    public String toString() {
        if (this.oldns == null) {
            return "Assigned namespace \"" + this.newns + "\" to " + this.target;
        }
        if (this.newns == null) {
            return "Removed namespace \"" + this.oldns + "\" from " + this.target;
        }
        return "Changed namespace of " + this.target + " from \"" + this.oldns + "\" to \"" + this.newns + "\"";
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

