/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Vector;
import org.apache.log4j.Logger;

public class OperationWarning {
    protected static final Logger logger = Logger.getLogger(OperationWarning.class);
    protected String message;
    protected int level;
    protected Vector subwarnings = new Vector();
    public static int DANGEROUS = 0;
    public static int FAILED = 1;

    public OperationWarning(String message) {
        this(message, FAILED);
    }

    public OperationWarning(String message, int level) {
        this.message = message;
        this.level = level;
    }

    public void addWarning(OperationWarning warning) {
        if (warning.failed()) {
            this.level = FAILED;
        }
        this.subwarnings.add(warning);
    }

    public boolean failed() {
        return this.level == FAILED;
    }

    public String getMessage() {
        return this.getMessage(0);
    }

    protected String getMessage(int indentLevel) {
        int i;
        StringBuffer out = new StringBuffer();
        if (indentLevel > 0) {
            out.append("\n");
        }
        for (i = 0; i < indentLevel * 2; ++i) {
            out.append(" ");
        }
        out.append(this.message);
        for (i = 0; i < this.subwarnings.size(); ++i) {
            OperationWarning ow = (OperationWarning)this.subwarnings.get(i);
            out.append(ow.getMessage(indentLevel + 1));
        }
        return out.toString();
    }

    public String toString() {
        return "[Operation Warning] " + this.getMessage();
    }
}

