/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOSession;
import org.obo.history.DefaultHistoryList;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.OperationWarning;
import org.obo.history.StringRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermMacroHistoryItem
extends HistoryItem
implements HistoryList {
    protected static final Logger logger = Logger.getLogger(TermMacroHistoryItem.class);
    private static final long serialVersionUID = -9191451800260864200L;
    protected List<HistoryItem> historyItems = new LinkedList<HistoryItem>();
    protected String description;
    protected Vector rels;
    protected String result;
    protected boolean locked = false;

    public TermMacroHistoryItem() {
        this((String)null);
    }

    public TermMacroHistoryItem(String description) {
        this.description = description;
        this.rels = new Vector();
    }

    public TermMacroHistoryItem(List<HistoryItem> changes) {
        this(null, changes);
    }

    public TermMacroHistoryItem(String description, List<HistoryItem> changes) {
        this((String)null);
        for (HistoryItem item : changes) {
            this.addItem(item);
        }
    }

    public TermMacroHistoryItem(String description, HistoryList historyList) {
        this((String)null);
        Iterator it = historyList.getHistoryItems();
        while (it.hasNext()) {
            this.addItem((HistoryItem)it.next());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermMacroHistoryItem)) {
            return false;
        }
        TermMacroHistoryItem item = (TermMacroHistoryItem)o;
        if (this.size() != item.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            HistoryItem item2 = this.getItemAt(i);
            HistoryItem item3 = item.getItemAt(i);
            if (ObjectUtil.equals((Object)item3, (Object)item2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int out = 0;
        for (int i = 0; i < this.size(); ++i) {
            HistoryItem item = this.getItemAt(i);
            out ^= item.hashCode();
        }
        return out;
    }

    @Override
    public String getShortName() {
        return this.description;
    }

    public void setTarget(OBOClass target) {
        this.setTarget(target.getID());
    }

    @Override
    public void setTarget(String target) {
        this.target = target;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setResult(OBOClass term) {
        this.result = term.getID();
    }

    public String getResult() {
        return this.result;
    }

    public Vector getSources() {
        return this.rels;
    }

    public void setSources(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            Link tr = (Link)paths[i].getLastPathComponent();
            this.rels.add(HistoryItem.createStringRelationship(tr));
        }
    }

    public void setSource(Link tr) {
        Vector<Link> rels = new Vector<Link>();
        rels.add(tr);
        this.setSources(rels);
    }

    public void setSources(Vector rels) {
        Vector<StringRelationship> out = new Vector<StringRelationship>();
        for (int i = 0; i < rels.size(); ++i) {
            Link tr = (Link)rels.get(i);
            out.add(HistoryItem.createStringRelationship(tr));
        }
        this.rels = out;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int size() {
        return this.historyItems.size();
    }

    @Override
    public HistoryItem getItemAt(int index) {
        return this.historyItems.get(index);
    }

    public void setHistoryItems(Vector items) {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked macro history item");
        }
        this.historyItems = items;
    }

    public OperationWarning lock(OBOSession history) {
        boolean failure = false;
        OperationWarning warning = new OperationWarning("Couldn't lock macro history item " + this.toString());
        for (int i = 0; i < this.historyItems.size(); ++i) {
            OperationWarning ow;
            HistoryItem item = this.historyItems.get(i);
            if (!(item instanceof TermMacroHistoryItem) || (ow = ((TermMacroHistoryItem)item).lock(history)) == null) continue;
            failure = true;
            warning.addWarning(ow);
        }
        if (failure) {
            return warning;
        }
        this.locked = true;
        return null;
    }

    @Override
    public Set getEditedNodes() {
        int i;
        this.edited = new HashSet();
        if (this.target != null) {
            this.edited.add(this.target);
        }
        if (this.result != null) {
            this.edited.add(this.result);
        }
        for (i = 0; i < this.rels.size(); ++i) {
            StringRelationship sr = (StringRelationship)this.rels.get(i);
            this.edited.add(sr.getChild());
            this.edited.add(sr.getParent());
        }
        for (i = 0; i < this.historyItems.size(); ++i) {
            this.edited.addAll(this.historyItems.get(i).getEditedNodes());
        }
        return this.edited;
    }

    public void setHistoryList(HistoryList list) {
        Iterator it = list.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            this.addItem(item);
        }
    }

    @Override
    public void addItem(HistoryItem item) {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked macro history item");
        }
        this.historyItems.add(item);
    }

    @Override
    public void removeItem(HistoryItem item) {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked macro history item");
        }
        this.historyItems.remove(item);
    }

    public String toString() {
        return this.historyItems.toString();
    }

    @Override
    public HistoryList forwardID(String oldID, Collection newIDs) {
        HistoryList out = null;
        Iterator<HistoryItem> it = this.historyItems.iterator();
        int i = 0;
        while (it.hasNext()) {
            HistoryItem item = it.next();
            HistoryList itemList = item.forwardID(oldID, newIDs);
            if (itemList == null) {
                if (out != null) {
                    out.addItem(item);
                }
            } else {
                if (out == null) {
                    out = new DefaultHistoryList();
                    for (int j = 0; j < i; ++j) {
                        out.addItem(this.historyItems.get(j));
                    }
                }
                Iterator it2 = itemList.getHistoryItems();
                while (it2.hasNext()) {
                    out.addItem((HistoryItem)it2.next());
                }
            }
            ++i;
        }
        return out;
    }

    public String getComment() {
        throw new UnsupportedOperationException("getComment() not supported for TermMacroHistoryItem");
    }

    public Date getDate() {
        throw new UnsupportedOperationException("getDate() not supported for TermMacroHistoryItem");
    }

    @Override
    public Iterator getHistoryItems() {
        return this.historyItems.iterator();
    }

    @Override
    public int getIndex(HistoryItem item) {
        return this.historyItems.indexOf(item);
    }

    public String getTitle() {
        throw new UnsupportedOperationException("getDate() not supported for TermMacroHistoryItem");
    }

    public String getUser() {
        throw new UnsupportedOperationException("getDate() not supported for TermMacroHistoryItem");
    }

    public String getVersion() {
        throw new UnsupportedOperationException("getDate() not supported for TermMacroHistoryItem");
    }

    public List getWarnings() {
        throw new UnsupportedOperationException("getWarnings() not supported for TermMacroHistoryItem");
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException("setComment() not supported for TermMacroHistoryItem");
    }

    public void setDate(Date date) {
        throw new UnsupportedOperationException("setDate() not supported for TermMacroHistoryItem");
    }

    public void setTitle(String title) {
        throw new UnsupportedOperationException("setTitle() not supported for TermMacroHistoryItem");
    }

    public void setUser(String user) {
        throw new UnsupportedOperationException("setUser() not supported for TermMacroHistoryItem");
    }

    public void setVersion(String version) {
        throw new UnsupportedOperationException("setVersion() not supported for TermMacroHistoryItem");
    }

    @Override
    public Set getEditedTerms() {
        return (Set)this.editedTerms.clone();
    }
}

