/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.Synonym;
import org.obo.history.AddDbxrefHistoryItem;
import org.obo.history.AddSynonymHistoryItem;
import org.obo.history.ChangeSynScopeHistoryItem;
import org.obo.history.ChangeSynTypeHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.CreateObjectHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.NameChangeHistoryItem;
import org.obo.history.OperationWarning;
import org.obo.history.SubclassedMacroHistoryItem;

public class TermSplitHistoryItem
extends SubclassedMacroHistoryItem {
    protected static final Logger logger = Logger.getLogger(TermSplitHistoryItem.class);
    private static final long serialVersionUID = -3983637863915469299L;
    protected String result;
    protected boolean addType;

    public TermSplitHistoryItem() {
        this((String)null, null, false);
    }

    public TermSplitHistoryItem(OBOClass target, String result, boolean addType) {
        this(target.getID(), result, addType);
    }

    public TermSplitHistoryItem(String target, String result, boolean addType) {
        super("split");
        this.setTarget(target);
        this.result = result;
        this.addType = addType;
    }

    public int hashCode() {
        return TermSplitHistoryItem.getHash(this.target) ^ TermSplitHistoryItem.getHash(this.result) ^ TermSplitHistoryItem.getHash(this.addType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermSplitHistoryItem)) {
            return false;
        }
        TermSplitHistoryItem item = (TermSplitHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.result, (Object)item.getResult()) && this.addType == item.addType();
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setAddType(boolean addType) {
        this.addType = addType;
    }

    public boolean addType() {
        return this.addType;
    }

    public void addItem(HistoryItem item) {
    }

    public void removeItem(HistoryItem item) {
    }

    public void setHistoryItems(Vector v) {
    }

    public OperationWarning lock(OBOSession history) {
        this.historyItems = new Vector();
        OperationWarning ow = this.getItems(history, this.historyItems);
        OperationWarning ow2 = super.lock(history);
        if (ow == null) {
            return ow2;
        }
        if (ow2 != null) {
            ow.addWarning(ow2);
        }
        return ow;
    }

    protected OperationWarning getItems(OBOSession history, List out) {
        OBOClass targetClass = (OBOClass)history.getObject(this.target);
        if (targetClass == null) {
            return new OperationWarning("Could not split with unrecognized target " + targetClass);
        }
        out.add(new CreateObjectHistoryItem(this.result, this.addType ? OBOClass.OBO_PROPERTY.getID() : OBOClass.OBO_CLASS.getID()));
        for (Link tr : targetClass.getParents()) {
            LinkedObject parent = tr.getParent();
            out.add(new CreateLinkHistoryItem(this.result, tr.getType().getID(), parent.getID()));
        }
        for (Link tr : targetClass.getChildren()) {
            LinkedObject child = tr.getChild();
            out.add(new CreateLinkHistoryItem(child.getID(), tr.getType().getID(), this.result));
        }
        out.add(new NameChangeHistoryItem("", targetClass.getName(), this.result));
        for (Dbxref ref : targetClass.getDbxrefs()) {
            out.add(new AddDbxrefHistoryItem(this.result, ref, false, null));
        }
        for (Synonym syn : targetClass.getSynonyms()) {
            out.add(new AddSynonymHistoryItem(this.result, syn.getText()));
            if (syn.getSynonymType() != null) {
                out.add(new ChangeSynTypeHistoryItem(this.result, syn.getText(), null, syn.getSynonymType().getID()));
            }
            if (syn.getScope() == 0) {
                out.add(new ChangeSynScopeHistoryItem(this.result, syn.getText(), 0, syn.getScope()));
            }
            for (Dbxref ref : syn.getXrefs()) {
                out.add(new AddDbxrefHistoryItem(this.result, ref, false, syn.getText()));
            }
        }
        return null;
    }

    public String getShortName() {
        return "split";
    }

    public String getResult() {
        return this.result;
    }

    public String toString() {
        return "Split " + this.target + " to create " + this.result;
    }

    public Set getEditedTerms() {
        this.editedTerms.add(this.target);
        return super.getEditedTerms();
    }
}

