/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.nlp.Namer;
import org.obo.nlp.impl.AbstractNamer;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalDefinitionNamer
extends AbstractNamer
implements Namer {
    protected static final Logger logger = Logger.getLogger(LogicalDefinitionNamer.class);

    @Override
    public Collection<String> constructNames(LinkedObject lo) {
        LinkedList<String> names = new LinkedList<String>();
        if (TermUtil.isIntersection(lo)) {
            StringBuilder name = new StringBuilder();
            for (Link dl : lo.getParents()) {
                if (!TermUtil.isIntersection(dl)) continue;
                if (name.length() > 0) {
                    name.append(" -and-");
                }
                if (!dl.getType().equals(OBOProperty.IS_A)) {
                    String relName = dl.getType().getName();
                    if (relName == null) {
                        relName = dl.getType().getID();
                    }
                    name.append(" " + relName);
                }
                name.append(" " + this.getName(dl.getParent()));
            }
            names.add(name.toString());
        } else if (TermUtil.isUnion(lo)) {
            StringBuilder name = new StringBuilder();
            for (Link link : lo.getParents()) {
                if (!TermUtil.isUnion(link)) continue;
                if (name.length() > 0) {
                    name.append(" -or- ");
                }
                name.append(this.getName(link.getParent()));
            }
            names.add(name.toString());
        } else {
            names.add(lo.getID());
        }
        return names;
    }

    protected String getName(LinkedObject lo) {
        Iterator<String> i$;
        if (lo == null) {
            return "?";
        }
        String name = lo.getName();
        if (name == null && (i$ = this.constructNames(lo).iterator()).hasNext()) {
            String sn;
            name = sn = i$.next();
        }
        if (name == null) {
            name = lo.getID();
        }
        return name;
    }

    @Override
    public Collection<String> constructTextDefs(LinkedObject lo) {
        return null;
    }
}

