/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.nlp.Namer;
import org.obo.nlp.impl.AbstractNamer;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhenotypeNamer
extends AbstractNamer
implements Namer {
    protected static final Logger logger = Logger.getLogger(PhenotypeNamer.class);

    @Override
    public Collection<String> constructNames(LinkedObject lo) {
        OBOClass genus;
        LinkedList<String> names = new LinkedList<String>();
        if (TermUtil.isIntersection(lo) && this.isSubclassByName(genus = ReasonerUtil.getGenus((OBOClass)lo), "quality")) {
            StringBuffer name = new StringBuffer();
            name.append(genus.getName());
            boolean isRelational = false;
            for (OBOClass c : ReasonerUtil.getDifferentiaByType((OBOClass)lo, "towards")) {
                name.append(c.getName());
                isRelational = true;
            }
            for (OBOClass c : ReasonerUtil.getDifferentiaByType((OBOClass)lo, "inheres_in")) {
                if (isRelational) {
                    name.insert(0, c.getName() + " ");
                    continue;
                }
                name.append(" " + c.getName());
            }
            names.add(name.toString());
        }
        return names;
    }

    @Override
    public Collection<String> constructTextDefs(LinkedObject lo) {
        return null;
    }
}

