/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.bbop.util.StringUtil;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObsoletableObject;
import org.obo.datamodel.impl.DefaultOperationModel;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.TermMacroHistoryItem;
import org.obo.nlp.Namer;
import org.obo.nlp.SemanticParser;
import org.obo.nlp.impl.RegulationTermNamer;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegulationTermParser
implements SemanticParser {
    protected static final Logger logger = Logger.getLogger("RegulationTermParser.class");
    protected Map<String, LinkedObject> name2obj = new HashMap<String, LinkedObject>();
    protected Collection<String> reports = new LinkedList<String>();
    protected OBOSession session;
    boolean replacePartOfs = true;
    LinkedObject brObj;
    LinkedObject romfObj;
    LinkedObject robqObj;
    LinkedObject robpObj;
    LinkedObject mfObj;
    LinkedObject bpObj;
    OBOProperty regRel;
    OBOProperty partOfRel;
    OBOProperty negRegRel;
    OBOProperty posRegRel;
    String regRelId = "regulates";
    String negRegRelId = "negatively_regulates";
    String posRegRelId = "positively_regulates";
    protected Namer namer;

    @Override
    public Collection<String> getReports() {
        return this.reports;
    }

    @Override
    public void index(OBOSession session) {
        this.name2obj = new HashMap<String, LinkedObject>();
        for (IdentifiedObject io : session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (String label : TermUtil.getExactLabels(lo)) {
                label = label.replace('_', ' ');
                this.name2obj.put(label, lo);
            }
        }
        this.session = session;
    }

    @Override
    public Collection<TermMacroHistoryItem> parseTerms() {
        OBORestrictionImpl subProp;
        LinkedList<TermMacroHistoryItem> items = new LinkedList<TermMacroHistoryItem>();
        this.brObj = this.lookup("biological regulation");
        this.romfObj = this.lookup("regulation of molecular function");
        this.robqObj = this.lookup("regulation of biological quality");
        this.robpObj = this.lookup("regulation of biological process");
        this.mfObj = this.lookup("molecular_function");
        this.bpObj = this.lookup("biological_process");
        this.partOfRel = (OBOProperty)this.session.getObject("part_of");
        this.regRel = (OBOProperty)this.session.getObject(this.regRelId);
        if (this.regRel == null) {
            this.regRel = (OBOProperty)this.session.getObjectFactory().createObject(this.regRelId, OBOClass.OBO_PROPERTY, false);
            this.session.addObject(this.regRel);
            this.regRel.setTransitiveOver(this.partOfRel);
        }
        this.posRegRel = (OBOProperty)this.session.getObject(this.posRegRelId);
        if (this.posRegRel == null) {
            this.posRegRel = (OBOProperty)this.session.getObjectFactory().createObject(this.posRegRelId, OBOClass.OBO_PROPERTY, false);
            this.session.addObject(this.posRegRel);
            subProp = new OBORestrictionImpl(this.posRegRel, OBOProperty.IS_A, this.regRel, false);
            this.posRegRel.addParent(subProp);
            this.posRegRel.setTransitiveOver(this.partOfRel);
        }
        this.negRegRel = (OBOProperty)this.session.getObject(this.negRegRelId);
        if (this.negRegRel == null) {
            this.negRegRel = (OBOProperty)this.session.getObjectFactory().createObject(this.negRegRelId, OBOClass.OBO_PROPERTY, false);
            this.session.addObject(this.negRegRel);
            subProp = new OBORestrictionImpl(this.negRegRel, OBOProperty.IS_A, this.regRel, false);
            this.negRegRel.addParent(subProp);
            this.negRegRel.setTransitiveOver(this.partOfRel);
        }
        for (IdentifiedObject io : this.session.getObjects()) {
            if (io.isBuiltIn() || !(io instanceof LinkedObject)) continue;
            items.addAll(this.parseTerm((LinkedObject)io));
        }
        return items;
    }

    @Override
    public Collection<TermMacroHistoryItem> parseTerm(LinkedObject lo) {
        if (lo.isBuiltIn() || lo instanceof ObsoletableObject && ((ObsoletableObject)((Object)lo)).isObsolete()) {
            return Collections.EMPTY_LIST;
        }
        TermMacroHistoryItem item = this.parseTerm(lo, lo.getName());
        if (item == null) {
            for (String label : TermUtil.getExactLabels(lo)) {
                if (!label.equals(lo.getName()) && (item = this.parseTerm(lo, label)) != null) break;
            }
        }
        if (item == null) {
            if (TermUtil.hasIsAAncestor(lo, this.brObj)) {
                this.report("NP", lo, lo.getName(), "No parse for regulation subclass");
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(item);
    }

    public TermMacroHistoryItem parseTerm(LinkedObject lo, String name) {
        if (name == null) {
            return null;
        }
        if (lo instanceof OBOClass && ReasonerUtil.getGenus((OBOClass)lo) != null) {
            this.report("PREDEFINED", lo, name, "already have a logical def");
            return null;
        }
        name = name.replace('_', ' ');
        String[] tokens = name.split("\\s");
        int p = 0;
        String dir = "";
        if (tokens[0].equals("positive") || tokens[0].equals("negative")) {
            ++p;
            dir = tokens[0];
        }
        if (tokens[p].equals("regulation") && tokens[p + 1].equals("of")) {
            String targetName = StringUtil.join((String)" ", (String[])tokens, (int)(p += 2));
            LinkedObject target = this.lookup(targetName);
            if (target == null) {
                this.report("NO_TARGET", lo, name, "cannot find regulated entity term");
                logger.info("no target: " + targetName);
            } else if (target.equals(lo)) {
                this.report("SELF_REFERENCE", lo, name, "cannot regulate itself");
                logger.info("self reference: " + targetName);
            } else {
                String relationName = dir.equals("positive") ? "positively_regulates" : (dir.equals("negative") ? "negatively_regulates" : "regulates");
                LinkedObject genus = this.lookup("biological regulation");
                if (TermUtil.hasIsAAncestor(lo, this.robpObj) && !TermUtil.hasIsAAncestor(lo, this.romfObj)) {
                    if (TermUtil.hasIsAAncestor(target, this.bpObj)) {
                        this.report("OK", lo, name, "in correct place");
                    } else {
                        this.report("HIERARCHY", lo, name, "should be in BP", target);
                    }
                }
                if (TermUtil.hasIsAAncestor(lo, this.romfObj)) {
                    if (TermUtil.hasIsAAncestor(target, this.mfObj)) {
                        this.report("OK", lo, name, "in correct place");
                    } else {
                        this.report("HIERARCHY", lo, name, "should be in MF", target);
                    }
                }
                if (TermUtil.hasIsAAncestor(lo, this.robqObj)) {
                    this.report("UNEXPECTED", lo, name, "biological quality found in GO", target);
                }
                if (!TermUtil.hasIsAAncestor(lo, this.brObj)) {
                    this.report("MISSING_LINK", lo, name, "not under biological regulation, yet I can parse it");
                }
                String relID = relationName;
                TermMacroHistoryItem item = TermUtil.createGenusDifferentiaHistoryItem(lo, genus, relID, target);
                if (this.replacePartOfs) {
                    for (Link link : lo.getParents()) {
                        if (!link.getType().equals(this.partOfRel) || !link.getParent().equals(target)) continue;
                        DeleteLinkHistoryItem delItem = new DeleteLinkHistoryItem(link);
                        item.addItem(delItem);
                    }
                }
                return item;
            }
        }
        return null;
    }

    public void report(String categ, LinkedObject lo, String name, String message) {
        this.report(categ, lo, name, message, null);
    }

    public void report(String categ, LinkedObject lo, String name, String message, LinkedObject target) {
        StringBuffer targetCode = new StringBuffer();
        if (TermUtil.hasIsAAncestor(lo, this.robpObj)) {
            targetCode.append("RoBP/");
        }
        if (TermUtil.hasIsAAncestor(lo, this.romfObj)) {
            targetCode.append("RoMF/");
        }
        if (TermUtil.hasIsAAncestor(lo, this.robqObj)) {
            targetCode.append("RoBQ/");
        }
        StringBuffer msg = new StringBuffer();
        msg.append(categ + "\t" + targetCode.toString() + "\t" + lo.getID() + "\t" + name + "\t" + message + "\t");
        if (target != null) {
            msg.append(target);
        }
        this.reports.add(msg.toString());
    }

    public LinkedObject lookup(String n) {
        n = n.replace('_', ' ');
        return this.name2obj.get(n);
    }

    @Override
    public void apply(Collection<? extends HistoryItem> items) {
        DefaultOperationModel model = new DefaultOperationModel();
        model.setSession(this.session);
        for (HistoryItem historyItem : items) {
            model.apply(historyItem);
        }
    }

    @Override
    public Namer getNamer() {
        return this.namer;
    }

    public void setNamer(Namer namer) {
        this.namer = namer;
    }

    @Override
    public void useDefaultNamer() {
        this.namer = new RegulationTermNamer();
    }
}

